package de.keksuccino.spiffyhud.customization.elements.singlelinetext;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.spiffyhud.util.ComponentUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleLineTextElement extends AbstractElement {

    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_TEXT_SCALE_STRING = "1.0";
    private static final float DEFAULT_TEXT_SCALE = 1.0F;
    private static final float MIN_TEXT_SCALE = 0.3F;

    @Nullable
    public String text = null;
    @NotNull
    public String textScale = DEFAULT_TEXT_SCALE_STRING;

    public SingleLineTextElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        float scale = this.resolveTextScale();

        if (this.shouldRender()) {

            class_2561 c = (this.text != null) ? ComponentUtils.fromJsonOrPlainText(this.text) : class_2561.method_43470("--------------------");
            if (c.getString().isBlank() && isEditor()) {
                c = class_2561.method_43470("--------------------");
            }
            this.baseWidth = (int) Math.ceil(class_310.method_1551().field_1772.method_27525(c) * scale);
            if ((this.baseWidth < 10) && isEditor()) {
                this.baseWidth = 10;
            }

            class_4587 pose = graphics.pose();
            pose.method_22903();
            pose.method_22904(this.getAbsoluteX(), this.getAbsoluteY(), 0);
            pose.method_22905(scale, scale, 1.0F);
            graphics.drawString(class_310.method_1551().field_1772, c, 0, 0, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
            pose.method_22909();

        } else {
            this.baseWidth = 100;
        }

        this.baseHeight = Math.max(1, (int) Math.ceil(class_310.method_1551().field_1772.field_2000 * scale));

    }

    private float resolveTextScale() {
        String raw = this.textScale;
        if (raw == null || raw.isBlank()) {
            return DEFAULT_TEXT_SCALE;
        }

        String replaced = PlaceholderParser.replacePlaceholders(raw);
        if (!replaced.isBlank() && MathUtils.isFloat(replaced)) {
            try {
                float parsed = Float.parseFloat(replaced);
                if (Float.isNaN(parsed) || Float.isInfinite(parsed)) {
                    return DEFAULT_TEXT_SCALE;
                }
                return Math.max(MIN_TEXT_SCALE, parsed);
            } catch (NumberFormatException ignored) {}
        }

        return DEFAULT_TEXT_SCALE;
    }

}
