package de.keksuccino.spiffyhud.customization.placeholders;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.mixin.mixins.common.client.IMixinGui;
import de.keksuccino.spiffyhud.mixin.mixins.common.client.IMixinSpectatorGui;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_310;

public class HighlightedItemTimePlaceholder extends Placeholder {

    public HighlightedItemTimePlaceholder() {
        super("highlighted_item_time");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        int time = ((IMixinGui)class_310.method_1551().field_1705).get_toolHighlightTimer_Spiffy();
        if ((class_310.method_1551().field_1724) != null && (class_310.method_1551().field_1724.method_7325())) {
            if (((IMixinSpectatorGui)class_310.method_1551().field_1705.method_1739()).invoke_getHotbarAlpha_Spiffy() > 0) {
                time = 40;
            } else {
                time = 0;
            }
        }
        return "" + time;
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return null;
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("spiffyhud.placeholders.highlighted_item_time");
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("spiffyhud.placeholders.highlighted_item_time.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        return new DeserializedPlaceholderString(this.getIdentifier(), null, "");
    }

}
