package de.keksuccino.spiffyhud.networking.packets.markercommand.suggestions;

import de.keksuccino.spiffyhud.commands.SpiffyMarkerCommand;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_3222;

public class ServerSideMarkerCommandSuggestionsPacketLogic {

    private static final Logger LOGGER = LogManager.getLogger();

    protected static boolean handle(@NotNull class_3222 sender, @NotNull MarkerCommandSuggestionsPacket packet) {
        try {
            List<String> suggestions = new ArrayList<>(Objects.requireNonNullElse(packet.groupSuggestions, List.of()));
            SpiffyMarkerCommand.cacheSuggestions(sender.method_5667(), suggestions);
            return true;
        } catch (Exception ex) {
            LOGGER.error("[SPIFFYHUD] Failed to record marker command suggestions for {}.", sender.method_5820(), ex);
        }
        return false;
    }

}
