/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenPostInitEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.screen.ScreenTickEvent;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.Renderable;
import de.keksuccino.spiffyhud.customization.Shared;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiffyGui
implements Renderable {
    public static final SpiffyGui INSTANCE = new SpiffyGui();
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean initialized = false;
    private static SpiffyOverlayScreen spiffyOverlayScreen = new SpiffyOverlayScreen(false);
    private boolean renderingHudContext = false;

    private SpiffyGui() {
        if (!initialized) {
            initialized = true;
        }
        this.setNewOverlayScreen();
        this.initOverlayScreen(false);
        this.tick();
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (!this.shouldRenderCustomizations()) {
            return;
        }
        this.runLayerTask(() -> {
            EventHandler.INSTANCE.postEvent((EventBase)new ScreenTickEvent.Pre((class_437)spiffyOverlayScreen));
            spiffyOverlayScreen.method_25393();
            EventHandler.INSTANCE.postEvent((EventBase)new ScreenTickEvent.Post((class_437)spiffyOverlayScreen));
            this.restoreRenderDefaults(graphics);
            EventHandler.INSTANCE.postEvent((EventBase)new RenderScreenEvent.Pre((class_437)spiffyOverlayScreen, graphics.pose(), mouseX, mouseY, partial));
            spiffyOverlayScreen.render(graphics, mouseX, mouseY, partial);
            this.restoreRenderDefaults(graphics);
            EventHandler.INSTANCE.postEvent((EventBase)new RenderScreenEvent.Post((class_437)spiffyOverlayScreen, graphics.pose(), mouseX, mouseY, partial));
            this.restoreRenderDefaults(graphics);
        });
    }

    private void restoreRenderDefaults(@NotNull GuiGraphics graphics) {
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
    }

    private boolean shouldRenderCustomizations() {
        if (class_310.method_1551().field_1755 instanceof LayoutEditorScreen) {
            return false;
        }
        return spiffyOverlayScreen != null && this.getLayer() != null;
    }

    @Nullable
    private ScreenCustomizationLayer getLayer() {
        if (spiffyOverlayScreen == null) {
            return null;
        }
        ScreenCustomizationLayer l = ScreenCustomizationLayerHandler.getLayerOfScreen((class_437)spiffyOverlayScreen);
        if (l != null) {
            l.loadEarly = true;
        }
        return l;
    }

    @NotNull
    public SpiffyOverlayScreen getOverlayScreen() {
        return spiffyOverlayScreen;
    }

    public boolean isRenderingHudContext() {
        return this.renderingHudContext;
    }

    public void onResize() {
        try {
            this.initOverlayScreen(true);
        }
        catch (Exception ex) {
            LOGGER.error("[SPIFFY HUD] Failed to resize SpiffyGui!", (Throwable)ex);
        }
    }

    public void tick() {
        try {
            if (Shared.reInitHudLayouts) {
                Shared.reInitHudLayouts = false;
                this.initOverlayScreen(true);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[SPIFFY HUD] Failed to tick SpiffyGui!", (Throwable)ex);
        }
    }

    private void setNewOverlayScreen() {
        spiffyOverlayScreen = new SpiffyOverlayScreen(false);
        ScreenCustomizationLayerHandler.registerScreen((class_437)spiffyOverlayScreen);
        this.getLayer();
    }

    private void initOverlayScreen(boolean resize) {
        this.runLayerTask(() -> {
            try {
                double cachedScale = class_310.method_1551().method_22683().method_4495();
                if (!resize) {
                    EventHandler.INSTANCE.postEvent((EventBase)new OpenScreenEvent((class_437)spiffyOverlayScreen));
                }
                SpiffyGui.spiffyOverlayScreen.field_22789 = class_310.method_1551().method_22683().method_4486();
                SpiffyGui.spiffyOverlayScreen.field_22790 = class_310.method_1551().method_22683().method_4502();
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenStartingEvent((class_437)spiffyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenEvent.Pre((class_437)spiffyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                spiffyOverlayScreen.method_25423(class_310.method_1551(), SpiffyGui.spiffyOverlayScreen.field_22789, SpiffyGui.spiffyOverlayScreen.field_22790);
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenEvent.Post((class_437)spiffyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                EventHandler.INSTANCE.postEvent((EventBase)new InitOrResizeScreenCompletedEvent((class_437)spiffyOverlayScreen, resize ? InitOrResizeScreenEvent.InitializationPhase.RESIZE : InitOrResizeScreenEvent.InitializationPhase.INIT));
                if (!resize) {
                    EventHandler.INSTANCE.postEvent((EventBase)new OpenScreenPostInitEvent((class_437)spiffyOverlayScreen));
                }
                class_310.method_1551().method_22683().method_15997(cachedScale);
            }
            catch (Exception ex) {
                LOGGER.error("[SPIFFY HUD] Failed to initialize SpiffyOverlayScreen!", (Throwable)ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLayerTask(@NotNull Runnable run) {
        try {
            boolean customizationEnabled = ScreenCustomization.isScreenCustomizationEnabled();
            ScreenCustomization.setScreenCustomizationEnabled((boolean)true);
            class_437 current = class_310.method_1551().field_1755;
            if (!(current instanceof SpiffyOverlayScreen)) {
                class_310.method_1551().field_1755 = spiffyOverlayScreen;
                this.renderingHudContext = true;
                try {
                    run.run();
                }
                finally {
                    this.renderingHudContext = false;
                    class_310.method_1551().field_1755 = current;
                }
            }
            ScreenCustomization.setScreenCustomizationEnabled((boolean)customizationEnabled);
        }
        catch (Exception ex) {
            LOGGER.error("[SPIFFY HUD] Failed to run layer task!", (Throwable)ex);
        }
    }
}

