/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.actions.marker;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.customization.actions.marker.MarkerActionConfig;
import de.keksuccino.spiffyhud.customization.actions.marker.MarkerEditorScreen;
import de.keksuccino.spiffyhud.customization.marker.MarkerStorage;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMarkerAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public AddMarkerAction() {
        super("spiffyhud_add_marker");
    }

    public boolean hasValue() {
        return true;
    }

    public void execute(@Nullable String value) {
        MarkerActionConfig config = MarkerActionConfig.parse(value);
        if (config == null) {
            LOGGER.error("[SPIFFYHUD] AddMarkerAction received malformed configuration.");
            return;
        }
        if (!config.hasValidTarget() || !config.hasValidMarkerName()) {
            LOGGER.error("[SPIFFYHUD] AddMarkerAction requires a target element identifier and display name.");
            return;
        }
        boolean success = MarkerStorage.addMarker(config.targetElementIdentifier, config.toMarkerData());
        if (!success) {
            LOGGER.error("[SPIFFYHUD] Failed to add marker '{}' to group '{}'.", (Object)config.uniqueMarkerName, (Object)config.targetElementIdentifier);
        }
    }

    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"spiffyhud.actions.add_marker");
    }

    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.actions.add_marker.desc", (String[])new String[0]);
    }

    public class_2561 getValueDisplayName() {
        return class_2561.method_43473();
    }

    public String getValueExample() {
        return MarkerActionConfig.defaultConfig().serialize();
    }

    public void editValue(@NotNull class_437 parentScreen, @NotNull ActionInstance instance) {
        MarkerActionConfig config = MarkerActionConfig.parse(instance.value);
        if (config == null) {
            config = MarkerActionConfig.defaultConfig();
        }
        MarkerEditorScreen screen = new MarkerEditorScreen((class_2561)class_2561.method_43471((String)"spiffyhud.actions.add_marker.editor"), config, serialized -> {
            if (serialized != null) {
                instance.value = serialized;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)screen);
    }
}

