/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.slot;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.GuiRenderTypes;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SlotElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    public String slot = "0";
    public int parsedSlot = 0;
    public boolean useSelectedSlot = false;
    public boolean showDurability = true;
    protected final class_327 font;

    public SlotElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.font = class_310.method_1551().field_1772;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            String slotString = PlaceholderParser.replacePlaceholders((String)this.slot).trim();
            this.parsedSlot = MathUtils.isInteger((String)slotString) ? Integer.parseInt(slotString) : 0;
            if (class_310.method_1551().field_1724 == null) {
                return;
            }
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            RenderSystem.enableBlend();
            if (SlotElement.isEditor()) {
                class_5250 label;
                class_5250 class_52502 = label = this.useSelectedSlot ? class_2561.method_43470((String)"SEL") : class_2561.method_43470((String)("" + this.parsedSlot));
                if (this.customElementLayerName != null) {
                    label = SlotElement.buildComponent((String)this.customElementLayerName).method_27661();
                    label.method_10852((class_2561)(this.useSelectedSlot ? class_2561.method_43470((String)" (SEL)") : class_2561.method_43470((String)(" (" + this.parsedSlot + ")"))));
                }
                graphics.fill(x, y, x + w, y + h, this.inEditorColor.getColorIntWithAlpha(0.5f));
                UIBase.renderBorder((GuiGraphics)graphics, (float)x, (float)y, (float)(x + w), (float)(y + h), (float)1.0f, (int)this.inEditorColor.getColorIntWithAlpha(0.8f), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                int n = x + w / 2;
                int n2 = y + h / 2;
                Objects.requireNonNull(this.font);
                graphics.drawCenteredString(this.font, (class_2561)label, n, n2 - 9 / 2, -1);
            } else {
                class_1799 slotItem;
                class_1799 class_17992 = slotItem = this.useSelectedSlot ? class_310.method_1551().field_1724.method_31548().method_7391() : class_310.method_1551().field_1724.method_31548().method_5438(this.parsedSlot);
                if (slotItem == class_1799.field_8037) {
                    return;
                }
                this.renderItem(graphics, x + 2, y + 2, w - 4, h - 4, mouseX, mouseY, slotItem);
            }
            RenderSystem.disableBlend();
        }
    }

    protected void renderItem(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, @NotNull class_1799 itemStack) {
        int count = itemStack.method_7947();
        this.renderScaledItem(graphics, itemStack, x, y, width, height);
        if (count > 1) {
            this.renderItemCount(graphics, this.font, x, y, Math.max(width, height), count);
        }
    }

    protected void renderScaledItem(@NotNull GuiGraphics graphics, @NotNull class_1799 stack, int x, int y, int width, int height) {
        float cooldownProgress;
        class_4587 pose = graphics.pose();
        pose.method_22903();
        pose.method_22904((double)x, (double)y, 0.0);
        float scale = (float)Math.min(width, height) / 16.0f;
        pose.method_22905(scale, scale, 1.0f);
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        graphics.renderItem(stack, 0, 0);
        if (this.showDurability && stack.method_31578()) {
            int barWidth = stack.method_31579();
            int barColor = stack.method_31580();
            int barX = 2;
            int barY = 13;
            graphics.fill(GuiRenderTypes.guiOverlay(), barX, barY, barX + 13, barY + 2, -16777216);
            graphics.fill(GuiRenderTypes.guiOverlay(), barX, barY, barX + barWidth, barY + 1, barColor | 0xFF000000);
        }
        if (class_310.method_1551().field_1724 != null && (cooldownProgress = class_310.method_1551().field_1724.method_7357().method_7905(stack.method_7909(), class_310.method_1551().method_1488())) > 0.0f) {
            int overlayTop = class_3532.method_15375((float)(16.0f * (1.0f - cooldownProgress)));
            int overlayBottom = overlayTop + class_3532.method_15386((float)(16.0f * cooldownProgress));
            graphics.fill(0, overlayTop, 16, overlayBottom, Integer.MAX_VALUE);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        pose.method_22909();
    }

    protected void renderItemCount(@NotNull GuiGraphics graphics, @NotNull class_327 font, int x, int y, int size, int count) {
        class_4587 pose = graphics.pose();
        String text = String.valueOf(count);
        float scaleFactor = (float)size / 16.0f;
        pose.method_22903();
        pose.method_22904(0.0, 0.0, 200.0);
        pose.method_22903();
        pose.method_22905(scaleFactor, scaleFactor, 1.0f);
        int scaledX = (int)((float)x / scaleFactor + 19.0f - 2.0f - (float)font.method_1727(text));
        int scaledY = (int)((float)y / scaleFactor + 6.0f + 3.0f);
        graphics.drawString(font, text, scaledX, scaledY, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity), true);
        pose.method_22909();
        pose.method_22909();
    }

    @NotNull
    public class_2561 getDisplayName() {
        class_5250 c = super.getDisplayName().method_27661();
        c.method_10852((class_2561)(this.useSelectedSlot ? class_2561.method_43470((String)" (SEL)") : class_2561.method_43470((String)(" (" + this.parsedSlot + ")"))));
        return c;
    }
}

