/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.bossbars;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_345;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeBossOverlayElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 GUI_BARS_LOCATION = new class_2960("textures/gui/bars.png");
    private static final List<class_345> DUMMY_EVENTS = List.of(new class_345(UUID.randomUUID(), (class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, class_1259.class_1260.field_5783, class_1259.class_1261.field_5795, false, false, false), new class_345(UUID.randomUUID(), (class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, class_1259.class_1260.field_5783, class_1259.class_1261.field_5795, false, false, false), new class_345(UUID.randomUUID(), (class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, class_1259.class_1260.field_5783, class_1259.class_1261.field_5795, false, false, false));
    private final class_310 minecraft = class_310.method_1551();
    private int barWidth = 182;
    private int barHeight = 0;
    private int barOriginalX = 0;
    private int barOriginalY = 0;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikeBossOverlayElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.field_1724 == null || this.minecraft.field_1687 == null) {
            return;
        }
        this.updateBodySizeAndPosCache();
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, elementWidth, elementHeight, this.barWidth, this.barHeight);
        int offsetX = alignedPosition[0] - this.barOriginalX;
        int offsetY = alignedPosition[1] - this.barOriginalY;
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        List<class_345> eventsToRender = VanillaLikeBossOverlayElement.isEditor() ? DUMMY_EVENTS : class_310.method_1551().field_1705.method_1740().field_2060.values();
        this.renderBossBars(graphics, offsetX, offsetY, eventsToRender);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void updateBodySizeAndPosCache() {
        List<class_345> eventsToRecord;
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setHeightOffset(5);
        int defaultBarWidth = 182;
        Collection<Object> collection = eventsToRecord = VanillaLikeBossOverlayElement.isEditor() ? DUMMY_EVENTS : class_310.method_1551().field_1705.method_1740().field_2060.values();
        if (!eventsToRecord.iterator().hasNext() && !VanillaLikeBossOverlayElement.isEditor()) {
            return;
        }
        int currentY = 12;
        for (class_345 bossEvent : eventsToRecord) {
            int barPosX = 0;
            int barPosY = currentY;
            recorder.updateX(barPosX);
            recorder.updateY(barPosY);
            class_2561 eventName = bossEvent.method_5414();
            int textWidth = this.minecraft.field_1772.method_27525((class_5348)eventName);
            int textPosX = (defaultBarWidth - textWidth) / 2;
            int textPosY = barPosY - 9;
            recorder.updateX(textPosX);
            recorder.updateY(textPosY);
            Objects.requireNonNull(this.minecraft.field_1772);
            currentY += 10 + 9;
        }
        this.barOriginalX = recorder.getX();
        this.barOriginalY = recorder.getY();
        this.barWidth = Math.max(defaultBarWidth, recorder.getWidth());
        this.barHeight = recorder.getHeight();
    }

    private void renderBossBars(GuiGraphics graphics, int offsetX, int offsetY, Iterable<class_345> bossEvents) {
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        int currentY = offsetY + 12;
        for (class_345 bossEvent : bossEvents) {
            int barPosX = offsetX;
            int barPosY = currentY;
            RenderSystem.enableBlend();
            graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
            this.drawBar(graphics, barPosX, barPosY, (class_1259)bossEvent);
            class_2561 eventName = bossEvent.method_5414();
            int textWidth = this.minecraft.field_1772.method_27525((class_5348)eventName);
            int textPosX = offsetX + (this.getAbsoluteWidth() - textWidth) / 2;
            int textPosY = barPosY - 9;
            RenderSystem.enableBlend();
            graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
            graphics.drawString(this.minecraft.field_1772, eventName, textPosX, textPosY, 0xFFFFFF);
            Objects.requireNonNull(this.minecraft.field_1772);
            currentY += 10 + 9;
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void drawBar(GuiGraphics graphics, int barX, int barY, class_1259 bossEvent) {
        this.drawBar(graphics, barX, barY, bossEvent, 182, 0);
        int filledWidth = (int)(bossEvent.method_5412() * 183.0f);
        if (filledWidth > 0) {
            this.drawBar(graphics, barX, barY, bossEvent, filledWidth, 5);
        }
    }

    private void drawBar(GuiGraphics graphics, int barX, int barY, class_1259 bossEvent, int width, int textureYOffset) {
        graphics.blit(GUI_BARS_LOCATION, barX, barY, 0, bossEvent.method_5420().ordinal() * 5 * 2 + textureYOffset, width, 5);
        if (bossEvent.method_5415() != class_1259.class_1261.field_5795) {
            RenderSystem.enableBlend();
            graphics.blit(GUI_BARS_LOCATION, barX, barY, 0, 80 + (bossEvent.method_5415().ordinal() - 1) * 5 * 2 + textureYOffset, width, 5);
            RenderSystem.disableBlend();
        }
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }

    protected boolean isInEditor() {
        return VanillaLikeBossOverlayElement.isEditor();
    }
}

