/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.scoreboard;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_274;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeScoreboardElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SPACER = ": ";
    private final class_310 minecraft = class_310.method_1551();
    private int sidebarWidth = 100;
    private int sidebarHeight = 100;
    private int sidebarOriginalX = 0;
    private int sidebarOriginalY = 0;
    private boolean renderSidebar = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;
    @Nullable
    public DrawableColor customTitleBackgroundColor = null;
    @Nullable
    public DrawableColor customLineBackgroundColor = null;

    public VanillaLikeScoreboardElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.field_1724 == null || this.minecraft.field_1687 == null) {
            return;
        }
        this.renderSidebar = false;
        this.renderScoreboard(graphics, 0, 0, false);
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.sidebarWidth, this.sidebarHeight);
        int offsetX = alignedPosition[0] - this.sidebarOriginalX;
        int offsetY = alignedPosition[1] - this.sidebarOriginalY;
        RenderSystem.enableBlend();
        this.renderSidebar = true;
        this.renderScoreboard(graphics, offsetX, offsetY, true);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderScoreboard(GuiGraphics graphics, int offsetX, int offsetY, boolean applyOffset) {
        class_266 objectiveToRender;
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        class_269 scoreboard = this.minecraft.field_1687.method_8428();
        class_266 objective = null;
        class_268 playerTeam = scoreboard.method_1164(this.minecraft.field_1724.method_5820());
        int colorId = -1;
        if (playerTeam != null) {
            colorId = playerTeam.method_1202().method_536();
        }
        if (playerTeam != null && colorId >= 0) {
            objective = scoreboard.method_1189(3 + colorId);
        }
        class_266 class_2662 = objectiveToRender = objective != null ? objective : scoreboard.method_1189(1);
        if (VanillaLikeScoreboardElement.isEditor()) {
            objectiveToRender = new class_266(scoreboard, "", class_274.field_1468, (class_2561)class_2561.method_43473(), class_274.class_275.field_1472);
        }
        if (objectiveToRender != null) {
            this.displayScoreboardSidebar(graphics, objectiveToRender, offsetX, offsetY, applyOffset);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void displayScoreboardSidebar(GuiGraphics guiGraphics, class_266 objective, int offsetX, int offsetY, boolean applyOffset) {
        class_269 scoreboard = objective.method_1117();
        Collection rawScores = scoreboard.method_1184(objective);
        ArrayList<DummyScore> validScores = rawScores.stream().filter(score -> score.method_1129() != null && !score.method_1129().startsWith("#")).collect(Collectors.toList());
        ArrayList<DummyScore> scoresToDisplay = validScores.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(validScores, (int)(validScores.size() - 15))) : validScores;
        ArrayList scoreComponents = Lists.newArrayListWithCapacity((int)scoresToDisplay.size());
        class_2561 title = objective.method_1114();
        if (VanillaLikeScoreboardElement.isEditor()) {
            title = class_2561.method_43471((String)"spiffyhud.elements.dummy.scoreboard_sidebar.title").method_27692(class_124.field_1067);
            ArrayList<DummyScore> dummyEntries = new ArrayList<DummyScore>();
            String dummyLineText = class_1074.method_4662((String)"spiffyhud.elements.dummy.scoreboard_sidebar.line", (Object[])new Object[0]);
            for (int i = 0; i < 6; ++i) {
                dummyEntries.add(new DummyScore(objective, dummyLineText, 0));
            }
            dummyEntries.add(new DummyScore(objective, "", 0));
            scoresToDisplay = dummyEntries;
        }
        int titleWidth = this.getFont().method_27525((class_5348)title);
        int spacerWidth = this.getFont().method_1727(SPACER);
        int maxEntryWidth = titleWidth;
        for (class_267 class_2672 : scoresToDisplay) {
            class_268 team = scoreboard.method_1164(class_2672.method_1129());
            class_5250 scoreComponent = class_268.method_1142((class_270)team, (class_2561)class_2561.method_43470((String)class_2672.method_1129()));
            scoreComponents.add(Pair.of((Object)class_2672, (Object)scoreComponent));
            int entryWidth = this.getFont().method_27525((class_5348)scoreComponent) + spacerWidth + this.getFont().method_1727(Integer.toString(class_2672.method_1126()));
            maxEntryWidth = Math.max(maxEntryWidth, entryWidth);
        }
        int numberOfLines = scoresToDisplay.size();
        Objects.requireNonNull(this.getFont());
        int n = numberOfLines * 9;
        int baseY = VanillaLikeScoreboardElement.getScreenHeight() / 2 + n / 3;
        int baseX = VanillaLikeScoreboardElement.getScreenWidth() - maxEntryWidth - 3;
        int lineBackgroundColor = this.minecraft.field_1690.method_19345(0.3f);
        if (this.customLineBackgroundColor != null) {
            lineBackgroundColor = this.customLineBackgroundColor.getColorInt();
        }
        int titleBackgroundColor = this.minecraft.field_1690.method_19345(0.4f);
        if (this.customTitleBackgroundColor != null) {
            titleBackgroundColor = this.customTitleBackgroundColor.getColorInt();
        }
        Objects.requireNonNull(this.getFont());
        int topY = baseY - numberOfLines * 9;
        this.sidebarWidth = Math.max(1, maxEntryWidth + 4);
        Objects.requireNonNull(this.getFont());
        this.sidebarHeight = Math.max(1, baseY - (topY - 9 - 1));
        this.sidebarOriginalX = baseX - 2;
        Objects.requireNonNull(this.getFont());
        this.sidebarOriginalY = topY - 9 - 1;
        int effectiveBaseX = baseX + (applyOffset ? offsetX : 0);
        int effectiveBaseY = baseY + (applyOffset ? offsetY : 0);
        if (this.renderSidebar) {
            int lineIndex = 0;
            for (Pair scorePair : scoreComponents) {
                class_267 currentScore = (class_267)scorePair.getFirst();
                class_2561 entryComponent = (class_2561)scorePair.getSecond();
                String scoreText = "" + class_124.field_1061 + currentScore.method_1126();
                int lineX = effectiveBaseX;
                int lineY = effectiveBaseY - ++lineIndex * 9;
                int rightX = VanillaLikeScoreboardElement.getScreenWidth() - 3 + 2 + (applyOffset ? offsetX : 0);
                guiGraphics.fill(lineX - 2, lineY, rightX, lineY + 9, lineBackgroundColor);
                guiGraphics.drawString(this.getFont(), entryComponent, lineX, lineY, -1, false);
                guiGraphics.drawString(this.getFont(), scoreText, rightX - this.getFont().method_1727(scoreText), lineY, -1, false);
                if (lineIndex != scoresToDisplay.size()) continue;
                guiGraphics.fill(lineX - 2, lineY - 9 - 1, rightX, lineY - 1, titleBackgroundColor);
                guiGraphics.fill(lineX - 2, lineY - 1, rightX, lineY, lineBackgroundColor);
                class_327 font = this.getFont();
                int titleX = lineX + maxEntryWidth / 2 - titleWidth / 2;
                guiGraphics.drawString(font, title, titleX, lineY - 9, -1, false);
            }
        }
    }

    private class_327 getFont() {
        return class_310.method_1551().field_1772;
    }

    public int getAbsoluteWidth() {
        return this.sidebarWidth;
    }

    public int getAbsoluteHeight() {
        return this.sidebarHeight;
    }

    private static class DummyScore
    extends class_267 {
        int score;

        public DummyScore(class_266 objective, String display, int score) {
            super(objective.method_1117(), objective, display);
            this.score = score;
        }

        public int method_1126() {
            return this.score;
        }
    }
}

