package de.keksuccino.spiffyhud;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlay;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.networking.packets.structure.structures.StructuresPacket;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_433;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SpiffyEvents {

    private static final Logger LOGGER = LogManager.getLogger();

    private static final class_2960 EDIT_BUTTON_TEXTURE = class_2960.method_60655("spiffyhud", "textures/edit_button.png");

    private ExtendedButton spiffyButton;

    @EventListener
    public void onInitOrResizeScreenCompleted(InitOrResizeScreenCompletedEvent e) {

        if ((e.getScreen() instanceof class_433 p) && p.method_53558() && CustomizationOverlay.isOverlayVisible(p)) {

            this.spiffyButton = new ExtendedButton(-30, 40, 80, 40, class_2561.method_43473(), (button) -> {

                class_310.method_1551().method_1507(new SpiffyOverlayScreen(true));

            }) {

                @Override
                public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

                    var m = CustomizationOverlay.getCurrentMenuBarInstance();
                    if ((m == null) || !m.isUserNavigatingInMenuBar()) {
                        TooltipHandler.INSTANCE.addTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("spiffyhud.edit_hud.desc")).setDefaultStyle().setScale(UIBase.getUIScale()), () -> this.field_22762, false, true);
                    }

                    if (this.method_25367()) {
                        this.method_46421(-20);
                    } else {
                        this.method_46421(-30);
                    }

                    super.method_25394(graphics, mouseX, mouseY, partial);

                    RenderSystem.enableBlend();
                    RenderingUtils.resetShaderColor(graphics);
                    graphics.method_25290(EDIT_BUTTON_TEXTURE, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
                    RenderingUtils.resetShaderColor(graphics);

                }

            };

            UIBase.applyDefaultWidgetSkinTo(this.spiffyButton);

            //2 because MenuBar and DebugOverlay need to be at pos 0 and 1
            if (e.getWidgets().size() >= 2) {
                e.getWidgets().add(2, this.spiffyButton);
            } else {
                e.getWidgets().add(0, this.spiffyButton);
            }

        }

    }

    @EventListener(priority = 0) //FM is -1
    public void onScreenRenderPost(RenderScreenEvent.Post e) {

        if ((e.getScreen() instanceof class_433 p) && p.method_53558() && CustomizationOverlay.isOverlayVisible(p)) {
            if (this.spiffyButton != null) {
                this.spiffyButton.method_25394(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
            }
        }

    }

    @EventListener
    public void onOpenScreen(OpenScreenEvent e) {
        if (class_310.method_1551().field_1687 != null) {
            StructuresPacket question = new StructuresPacket();
            question.get = true;
            PacketHandler.sendToServer(question);
        }
    }

}
