package de.keksuccino.spiffyhud.customization;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.ObjectHolder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import de.keksuccino.spiffyhud.customization.elements.Elements;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.air.VanillaLikePlayerAirElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.armor.VanillaLikePlayerArmorElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.bossbars.VanillaLikeBossOverlayElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.effects.VanillaLikeEffectsElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.experience.VanillaLikeExperienceElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.food.VanillaLikePlayerFoodElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.hotbar.VanillaLikeHotbarElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.jumpmeter.VanillaLikeJumpMeterElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.mounthealth.VanillaLikeMountHealthElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.playerhealth.VanillaLikePlayerHealthElement;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class SpiffyOverlayScreen extends class_437 {

    private static final Logger LOGGER = LogManager.getLogger();

    private static final class_2960 CROSSHAIR_SPRITE = class_2960.method_60656("hud/crosshair");
    private static final class_2960 CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = class_2960.method_60656("hud/crosshair_attack_indicator_background");
    private static final class_2960 CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = class_2960.method_60656("hud/crosshair_attack_indicator_progress");
    private static final class_2960 HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE = class_2960.method_60656("hud/hotbar_attack_indicator_background");
    private static final class_2960 HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE = class_2960.method_60656("hud/hotbar_attack_indicator_progress");

    private static final VanillaLikeHotbarElement HOTBAR_ELEMENT = Elements.VANILLA_LIKE_HOTBAR.buildDefaultInstance();
    private static final VanillaLikeJumpMeterElement JUMP_METER_ELEMENT = Elements.VANILLA_LIKE_JUMP_METER.buildDefaultInstance();
    private static final VanillaLikeExperienceElement EXPERIENCE_ELEMENT = Elements.VANILLA_LIKE_EXPERIENCE.buildDefaultInstance();
    private static final VanillaLikePlayerFoodElement FOOD_ELEMENT = Elements.VANILLA_LIKE_PLAYER_FOOD.buildDefaultInstance();
    private static final VanillaLikePlayerArmorElement ARMOR_ELEMENT = Elements.VANILLA_LIKE_PLAYER_ARMOR.buildDefaultInstance();
    private static final VanillaLikePlayerAirElement AIR_ELEMENT = Elements.VANILLA_LIKE_PLAYER_AIR.buildDefaultInstance();
    private static final VanillaLikeMountHealthElement MOUNT_HEALTH_ELEMENT = Elements.VANILLA_LIKE_MOUNT_HEALTH.buildDefaultInstance();
    private static final VanillaLikePlayerHealthElement PLAYER_HEALTH_ELEMENT = Elements.VANILLA_LIKE_PLAYER_HEALTH.buildDefaultInstance();
    private static final VanillaLikeBossOverlayElement BOSS_OVERLAY_ELEMENT = Elements.VANILLA_LIKE_BOSS_OVERLAY.buildDefaultInstance();
    private static final VanillaLikeEffectsElement EFFECTS_ELEMENT = Elements.VANILLA_LIKE_EFFECTS.buildDefaultInstance();

    public final boolean showFancyMenuOverlay;
    protected final class_327 field_22793 = class_310.method_1551().field_1772;
    protected final class_310 field_22787 = class_310.method_1551();

    public SpiffyOverlayScreen(boolean showFancyMenuOverlay) {
        super(class_2561.method_43473());
        this.forceEnableCustomizations();
        this.showFancyMenuOverlay = showFancyMenuOverlay;
    }

    protected void forceEnableCustomizations() {
        if (!ScreenCustomization.isCustomizationEnabledForScreen(this)) {
            LOGGER.info("[SPIFFY HUD] Force-enabling customizations for SpiffyOverlayScreen..");
            ScreenCustomization.setCustomizationForScreenEnabled(this, true);
        }
    }

    @Override
    protected void method_25426() {

        this.method_37063(this.buildHotbarWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.hotbar"));

        this.method_37063(this.buildJumpMeterWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.jump_meter"));

        this.method_37063(this.buildExperienceBarWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.experience_bar"));

        this.method_37063(this.buildSelectedItemNameWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.selected_item_name"));

        this.method_37063(this.buildScoreboardSidebarWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.scoreboard_sidebar"));

        this.method_37063(this.buildFoodBarWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.food_bar"));

        this.method_37063(this.buildArmorBarWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.armor_bar"));

        this.method_37063(this.buildAirBarWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.air_bar"));

        this.method_37063(this.buildHealthBarWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.health_bar"));

        this.method_37063(this.buildMountHealthBarWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.mount_health_bar"));

        this.method_37063(this.buildOverlayMessageWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.overlay_message"));

        this.method_37063(this.buildCrosshairWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.crosshair"));

        this.method_37063(this.buildAttackIndicatorWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.attack_indicator"));

        this.method_37063(this.buildTitleWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.title"));

        this.method_37063(this.buildSubtitleWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.subtitle"));

        this.method_37063(this.buildBossBarWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.boss_bars"));

        this.method_37063(this.buildEffectsWidget()).method_25355(class_2561.method_43471("spiffyhud.elements.dummy.effects"));

    }

    @Override
    public void method_25394(@NotNull class_332 $$0, int $$1, int $$2, float $$3) {

        //Don't render widgets when not in the editor
        if (!(class_310.method_1551().field_1755 instanceof LayoutEditorScreen)) return;

        this.method_25396().forEach(guiEventListener -> {
            if (guiEventListener instanceof class_4068 renderable) {
                renderable.method_25394($$0, $$1, $$2, $$3);
            }
        });

    }

    @Override
    public void method_25420(class_332 $$0, int $$1, int $$2, float $$3) {
    }

    protected RendererWidget buildHotbarWidget() {
        int screenCenter = this.field_22789 / 2;
        int x = screenCenter - 91;
        int y = this.field_22790 - 22;
        int widgetWidth = 182;
        int widgetHeight = 22;
        return new SpiffyRendererWidget(x, y, widgetWidth, widgetHeight, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            HOTBAR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            HOTBAR_ELEMENT.posOffsetX = gx;
            HOTBAR_ELEMENT.posOffsetY = gy - 2;
            HOTBAR_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.HOTBAR_IDENTIFIER);
    }

    protected RendererWidget buildJumpMeterWidget() {
        int screenCenter = this.field_22789 / 2;
        int x = screenCenter - 91;
        int y = (this.field_22790 - 32 + 3) - 5; // custom offset
        int width = 182;
        int height = 5;
        return new SpiffyRendererWidget(x, y, width, height, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            JUMP_METER_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            JUMP_METER_ELEMENT.posOffsetX = gx;
            JUMP_METER_ELEMENT.posOffsetY = gy;
            JUMP_METER_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.JUMP_METER_IDENTIFIER);
    }

    protected RendererWidget buildExperienceBarWidget() {
        int screenCenter = this.field_22789 / 2;
        int x = screenCenter - 91;
        int y = this.field_22790 - 32 + 3;
        int width = 182;
        int height = 5;
        return new SpiffyRendererWidget(x, y, width, height, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            EXPERIENCE_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            EXPERIENCE_ELEMENT.posOffsetX = gx;
            EXPERIENCE_ELEMENT.posOffsetY = gy;
            EXPERIENCE_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.EXPERIENCE_BAR_IDENTIFIER);
    }

    protected RendererWidget buildSelectedItemNameWidget() {

        class_5250 mutableComponent = class_2561.method_43473().method_10852(class_2561.method_43471("spiffyhud.elements.dummy.selected_item_name")).method_27692(class_124.field_1076);
        int textWidth = field_22793.method_27525(mutableComponent);
        int textX = (this.field_22789 - textWidth) / 2;
        int textY = (this.field_22790 - 59) - 18; // -18 is a custom offset to move the text above the bars that got moved up because of the Jump Meter

        return new SpiffyRendererWidget(textX, textY, textWidth, field_22793.field_2000,
                (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
                    RenderSystem.enableBlend();
                    graphics.method_25294(textX - 2, textY - 2, textX + textWidth + 2, textY + field_22793.field_2000 + 2, class_310.method_1551().field_1690.method_19344(0));
                    graphics.method_27535(field_22793, mutableComponent, textX, textY, -1);
                    RenderingUtils.resetShaderColor(graphics);
                }
        ).setWidgetIdentifierFancyMenu(VanillaHudElements.SELECTED_ITEM_NAME_IDENTIFIER);

    }

    protected RendererWidget buildScoreboardSidebarWidget() {

        String spacer = ": ";

        //Build line entries
        record DisplayEntry(class_2561 name, class_2561 score, int scoreWidth) {}
        List<DisplayEntry> entryList = new ArrayList<>();
        class_2561 name = class_2561.method_43471("spiffyhud.elements.dummy.scoreboard_sidebar.line");
        class_2561 score = class_2561.method_43470("0").method_27692(class_124.field_1061);
        int scoreWidth = field_22793.method_27525(score);
        entryList.add(new DisplayEntry(class_2561.method_43473(), class_2561.method_43473(), scoreWidth));
        entryList.add(new DisplayEntry(name, score, scoreWidth));
        entryList.add(new DisplayEntry(name, score, scoreWidth));
        entryList.add(new DisplayEntry(name, score, scoreWidth));
        entryList.add(new DisplayEntry(name, score, scoreWidth));
        entryList.add(new DisplayEntry(name, score, scoreWidth));
        entryList.add(new DisplayEntry(name, score, scoreWidth));
        DisplayEntry[] entries = entryList.toArray(new DisplayEntry[0]);

        class_2561 title = class_2561.method_43471("spiffyhud.elements.dummy.scoreboard_sidebar.title").method_27692(class_124.field_1067);
        int titleWidth = field_22793.method_27525(title);
        int totalSidebarWidth = titleWidth;
        int spacerWidth = field_22793.method_1727(spacer);
        for (DisplayEntry entry : entries) {
            totalSidebarWidth = Math.max(totalSidebarWidth, field_22793.method_27525(entry.name) + (entry.scoreWidth > 0 ? spacerWidth + entry.scoreWidth : 0));
        }
        int linesCount = entries.length;
        int linesHeight = linesCount * field_22793.field_2000;
        int sidebarYEnd = this.field_22790 / 2 + linesHeight / 3;
        int sidebarXStart = this.field_22789 - totalSidebarWidth - 3;
        int sidebarXEnd = this.field_22789 - 3 + 2;
        int backgroundColorNormal = field_22787.field_1690.method_19345(0.3f);
        int backgroundColorTitle = field_22787.field_1690.method_19345(0.4f);
        int sidebarYBase = sidebarYEnd - linesCount * field_22793.field_2000;
        int finalTotalSidebarWidth = totalSidebarWidth;
        int sidebarY = sidebarYBase - field_22793.field_2000 - 1;
        int sidebarHeight = Math.max(1, sidebarYEnd - sidebarY);

        return new SpiffyRendererWidget(sidebarXStart, sidebarY, totalSidebarWidth, sidebarHeight,
                (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
                    RenderSystem.enableBlend();
                    //Render title background
                    graphics.method_25294(sidebarXStart - 2, sidebarYBase - field_22793.field_2000 - 1, sidebarXEnd, sidebarYBase - 1, backgroundColorTitle);
                    //Render lines background
                    graphics.method_25294(sidebarXStart - 2, sidebarYBase - 1, sidebarXEnd, sidebarYEnd, backgroundColorNormal);
                    //Render title
                    graphics.method_51439(field_22793, title, sidebarXStart + finalTotalSidebarWidth / 2 - titleWidth / 2, sidebarYBase - field_22793.field_2000, -1, false);
                    //Render lines
                    for (int t = 0; t < linesCount; ++t) {
                        DisplayEntry entry = entries[t];
                        int u = sidebarYEnd - (linesCount - t) * field_22793.field_2000;
                        graphics.method_51439(field_22793, entry.name, sidebarXStart, u, -1, false);
                        graphics.method_51439(field_22793, entry.score, sidebarXEnd - entry.scoreWidth, u, -1, false);
                    }
                    RenderingUtils.resetShaderColor(graphics);
                }
        ).setWidgetIdentifierFancyMenu(VanillaHudElements.SCOREBOARD_SIDEBAR_IDENTIFIER);

    }

    protected RendererWidget buildFoodBarWidget() {
        int barX = this.field_22789 / 2 + 91;
        int barY = (this.field_22790 - 39) - 5;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            FOOD_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            FOOD_ELEMENT.posOffsetX = gx;
            FOOD_ELEMENT.posOffsetY = gy;
            FOOD_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            FOOD_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.FOOD_BAR_IDENTIFIER);
    }

    protected RendererWidget buildArmorBarWidget() {
        int barX = this.field_22789 / 2 - 91;
        int barY = (this.field_22790 - 39 - 10) - 5;
        return new SpiffyRendererWidget(barX, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            ARMOR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            ARMOR_ELEMENT.posOffsetX = gx;
            ARMOR_ELEMENT.posOffsetY = gy;
            ARMOR_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_LEFT;
            ARMOR_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.ARMOR_BAR_IDENTIFIER);
    }

    protected RendererWidget buildAirBarWidget() {
        int barX = this.field_22789 / 2 + 91;
        int barY = (this.field_22790 - 39 - 10) - 5;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            AIR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            AIR_ELEMENT.posOffsetX = gx;
            AIR_ELEMENT.posOffsetY = gy;
            AIR_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            AIR_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.AIR_BAR_IDENTIFIER);
    }

    protected RendererWidget buildMountHealthBarWidget() {
        int barX = this.field_22789 / 2 + 91;
        int barY = (this.field_22790 - 39 - 10) - 15;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            MOUNT_HEALTH_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            MOUNT_HEALTH_ELEMENT.posOffsetX = gx;
            MOUNT_HEALTH_ELEMENT.posOffsetY = gy;
            MOUNT_HEALTH_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            MOUNT_HEALTH_ELEMENT.isUsedAsDummy = true;
            MOUNT_HEALTH_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.MOUNT_HEALTH_BAR_IDENTIFIER);
    }

    protected RendererWidget buildHealthBarWidget() {
        int barX = this.field_22789 / 2 - 91;
        int barY = (this.field_22790 - 39) - 5;
        return new SpiffyRendererWidget(barX, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            PLAYER_HEALTH_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            PLAYER_HEALTH_ELEMENT.posOffsetX = gx;
            PLAYER_HEALTH_ELEMENT.posOffsetY = gy;
            PLAYER_HEALTH_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_LEFT;
            PLAYER_HEALTH_ELEMENT.isUsedAsDummy = true;
            PLAYER_HEALTH_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.PLAYER_HEALTH_BAR_IDENTIFIER);
    }

    protected RendererWidget buildOverlayMessageWidget() {
        class_2561 message = class_2561.method_43470("Overlay Message");
        int messageWidth = field_22793.method_27525(message);
        int textX = (this.field_22789 / 2) - (messageWidth / 2);
        int textY = ((this.field_22790 - 68) - 4) - 18;
        ObjectHolder<Float> animatedTickHolder = ObjectHolder.of(0.0f);
        return new SpiffyRendererWidget(textX - 2, textY - 2, messageWidth + 4, field_22793.field_2000 + 4, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            RenderSystem.enableBlend();
            // Update the animated tick value by incrementing it
            animatedTickHolder.set(animatedTickHolder.get() + 0.005f);
            // Use the animated tick value to create a color cycle
            int animatedTextColor = class_3532.method_15369(class_3532.method_15363(animatedTickHolder.get() % 1.0f, 0.0f, 1.0f), 0.7f, 0.6f) | 0xFF000000;
            graphics.method_27535(class_310.method_1551().field_1772, message, textX, textY, animatedTextColor);
            RenderingUtils.resetShaderColor(graphics);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.OVERLAY_MESSAGE_IDENTIFIER);
    }

    protected RendererWidget buildCrosshairWidget() {
        int crosshairX = (this.field_22789 - 15) / 2;
        int crosshairY = (this.field_22790 - 15) / 2;
        return new SpiffyRendererWidget(crosshairX, crosshairY, 15, 15, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate(GlStateManager.class_4535.ONE_MINUS_DST_COLOR,
                    GlStateManager.class_4534.ONE_MINUS_SRC_COLOR,
                    GlStateManager.class_4535.ONE,
                    GlStateManager.class_4534.ZERO);
            graphics.method_52706(CROSSHAIR_SPRITE, crosshairX, crosshairY, 15, 15);
            RenderSystem.defaultBlendFunc();
            RenderingUtils.resetShaderColor(graphics);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.CROSSHAIR_IDENTIFIER);
    }

    protected RendererWidget buildAttackIndicatorWidget() {

        int crossX = (this.field_22789 / 2) + 1;
        int crossY = (this.field_22790 / 2 - 7 + 16) + 40;
        int hotX = crossX - 2 - 18;
        int hotY = crossY - 6;
        float progress = 0.5F;

        return new SpiffyRendererWidget(hotX, hotY, 18 + 2 + 16, 18,
                (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {

                    RenderSystem.enableBlend();

                    // Render crosshair indicator with sprite system
                    int fillWidth = (int)(progress * 16.0f);
                    RenderSystem.blendFuncSeparate(GlStateManager.class_4535.ONE_MINUS_DST_COLOR, GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, GlStateManager.class_4535.ONE, GlStateManager.class_4534.ZERO);
                    graphics.method_52706(CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, crossX, crossY, 16, 4);
                    if (fillWidth > 0) {
                        graphics.method_52708(CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, crossX, crossY, fillWidth, 4);
                    }
                    RenderSystem.defaultBlendFunc();

                    RenderSystem.enableBlend();

                    // Render hotbar indicator with sprite system
                    int fillHeight = (int)(progress * 18.0f);
                    graphics.method_52706(HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE, hotX, hotY, 18, 18);
                    if (fillHeight > 0) {
                        graphics.method_52708(HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE, 18, 18, 0, 18 - fillHeight, hotX, hotY + 18 - fillHeight, 18, fillHeight);
                    }

                    RenderingUtils.resetShaderColor(graphics);

                }
        ).setWidgetIdentifierFancyMenu(VanillaHudElements.ATTACK_INDICATOR_IDENTIFIER);

    }

    protected RendererWidget buildTitleWidget() {

        class_2561 title = class_2561.method_43471("spiffyhud.elements.dummy.title");
        int titleWidth = field_22793.method_27525(title);
        int totalWidth = titleWidth * 4;
        int totalHeight = field_22793.field_2000 * 4;
        int textX = (this.field_22789 / 2) - (totalWidth / 2);
        int textY = (this.field_22790 / 2) - (12 * 4);

        return new SpiffyRendererWidget(textX, textY, totalWidth, totalHeight,
                (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
                    RenderSystem.enableBlend();
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_46416((float)this.field_22789 / 2, (float)this.field_22790 / 2, 0.0f);
                    RenderSystem.enableBlend();
                    //Render title
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_22905(4.0f, 4.0f, 4.0f);
                    graphics.method_27535(field_22793, title, -titleWidth / 2, -12, -1);
                    graphics.method_51448().method_22909();
                    graphics.method_51448().method_22909();
                    RenderingUtils.resetShaderColor(graphics);
                }
        ).setWidgetIdentifierFancyMenu(VanillaHudElements.TITLE_IDENTIFIER);

    }

    protected RendererWidget buildSubtitleWidget() {
        class_2561 subtitle = class_2561.method_43470("Subtitle");
        int subtitleWidth = field_22793.method_27525(subtitle);
        int totalWidth = subtitleWidth * 2;
        int totalHeight = field_22793.field_2000 * 2;
        int textX = (this.field_22789 / 2) - (totalWidth / 2);
        int textY = (this.field_22790 / 2) + (6 * 2);
        return new SpiffyRendererWidget(textX, textY, totalWidth, totalHeight, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            RenderSystem.enableBlend();
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(this.field_22789 / 2, this.field_22790 / 2, 0.0f);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(2.0f, 2.0f, 2.0f);
            graphics.method_27535(class_310.method_1551().field_1772, subtitle, -subtitleWidth / 2, 6, 0xFFFFFF);
            graphics.method_51448().method_22909();
            graphics.method_51448().method_22909();
            RenderingUtils.resetShaderColor(graphics);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.SUBTITLE_IDENTIFIER);
    }

    protected RendererWidget buildBossBarWidget() {
        int barX = this.field_22789 / 2 - 91;
        int barY = 12;
        int totalY = barY - 9;
        int totalHeight = 53;
        return new SpiffyRendererWidget(barX, totalY, 182, totalHeight, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            BOSS_OVERLAY_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            BOSS_OVERLAY_ELEMENT.posOffsetX = gx;
            BOSS_OVERLAY_ELEMENT.posOffsetY = gy;
            BOSS_OVERLAY_ELEMENT.spiffyAlignment = SpiffyAlignment.TOP_CENTERED;
            BOSS_OVERLAY_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.BOSS_BARS_IDENTIFIER);
    }

    protected RendererWidget buildEffectsWidget() {
        return new SpiffyRendererWidget(this.field_22789 - 50 - 1, 1, 50, 50, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            EFFECTS_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            EFFECTS_ELEMENT.posOffsetX = gx;
            EFFECTS_ELEMENT.posOffsetY = gy;
            EFFECTS_ELEMENT.spiffyAlignment = SpiffyAlignment.TOP_RIGHT;
            EFFECTS_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu(VanillaHudElements.EFFECTS_IDENTIFIER);
    }

    public static class SpiffyRendererWidget extends RendererWidget {

        public SpiffyRendererWidget(int x, int y, int width, int height, @NotNull RendererWidgetBody body) {
            super(x, y, width, height, body);
        }

        @Override
        public void method_25394(@NotNull class_332 $$0, int $$1, int $$2, float $$3) {
            //Don't render widgets when not in the editor
            if (!(class_310.method_1551().field_1755 instanceof LayoutEditorScreen)) return;
            super.method_25394($$0, $$1, $$2, $$3);
        }

    }

}
