package de.keksuccino.spiffyhud.customization.actions.marker;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.customization.marker.MarkerStorage;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveMarkerAction extends Action {

    private static final Logger LOGGER = LogManager.getLogger();

    public RemoveMarkerAction() {
        super("spiffyhud_remove_marker");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        MarkerRemovalConfig config = MarkerRemovalConfig.parse(value);
        if (config == null) {
            LOGGER.error("[SPIFFYHUD] RemoveMarkerAction received malformed configuration.");
            return;
        }
        if (!config.isValid()) {
            LOGGER.error("[SPIFFYHUD] RemoveMarkerAction is missing required data.");
            return;
        }
        boolean success = MarkerStorage.removeMarker(config.targetElementIdentifier, config.uniqueMarkerName);
        if (!success) {
            LOGGER.error("[SPIFFYHUD] Failed to remove marker '{}' from group '{}'.", config.uniqueMarkerName, config.targetElementIdentifier);
        }
    }

    @Override
    public @NotNull class_2561 getActionDisplayName() {
        return class_2561.method_43471("spiffyhud.actions.remove_marker");
    }

    @Override
    public @NotNull class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("spiffyhud.actions.remove_marker.desc");
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43473();
    }

    @Override
    public String getValueExample() {
        return MarkerRemovalConfig.defaultConfig().serialize();
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull ActionInstance instance) {
        MarkerRemovalConfig config = MarkerRemovalConfig.parse(instance.value);
        if (config == null) {
            config = MarkerRemovalConfig.defaultConfig();
        }
        MarkerRemovalScreen screen = new MarkerRemovalScreen(
                class_2561.method_43471("spiffyhud.actions.remove_marker.editor"),
                config,
                serialized -> {
                    if (serialized != null) {
                        instance.value = serialized;
                    }
                    class_310.method_1551().method_1507(parentScreen);
                }
        );
        class_310.method_1551().method_1507(screen);
    }

}
