package de.keksuccino.spiffyhud.customization.elements.vanillalike.food;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5819;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerFoodElement extends AbstractElement {

    private static final Logger LOGGER = LogManager.getLogger();

    // Sprite resources for food icons in 1.21.1
    private static final class_2960 FOOD_EMPTY_SPRITE = class_2960.method_60656("hud/food_empty");
    private static final class_2960 FOOD_HALF_SPRITE = class_2960.method_60656("hud/food_half");
    private static final class_2960 FOOD_FULL_SPRITE = class_2960.method_60656("hud/food_full");
    private static final class_2960 FOOD_EMPTY_HUNGER_SPRITE = class_2960.method_60656("hud/food_empty_hunger");
    private static final class_2960 FOOD_HALF_HUNGER_SPRITE = class_2960.method_60656("hud/food_half_hunger");
    private static final class_2960 FOOD_FULL_HUNGER_SPRITE = class_2960.method_60656("hud/food_full_hunger");

    private static final int BAR_WIDTH = 81;
    private static final int BAR_HEIGHT = 9;

    private final class_310 minecraft = class_310.method_1551();
    protected final class_5819 random = class_5819.method_43047();
    protected int tickCount;

    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerFoodElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    /**
     * Renders the food bar entirely within the element's bounds.
     * First, it updates the food bar's metrics based on a provisional position,
     * then calculates the aligned position within the element, and finally renders the bar.
     */
    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();

        if (this.minecraft.field_1724 == null || this.minecraft.field_1687 == null) {
            return;
        }

        // Calculate the aligned position of the food bar within the element.
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(
                this.spiffyAlignment,
                elementX,
                elementY,
                this.getAbsoluteWidth(),
                this.getAbsoluteHeight(),
                BAR_WIDTH,
                BAR_HEIGHT
        );
        int barPosX = alignedPosition[0];
        int barPosY = alignedPosition[1];

        // Render the food bar at the calculated aligned position.
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor(graphics);

        this.renderFoodBar(graphics, barPosX, barPosY);

        RenderingUtils.resetShaderColor(graphics);

    }

    /**
     * Renders the food bar icons (background, full, or half food) at the specified base position.
     * When the icons are to be rendered from the left side (i.e. left- or center–based alignment),
     * we mirror the texture by swapping the U texture coordinates.
     *
     * @param graphics The graphics context used for rendering.
     * @param baseX    The X coordinate where the food bar starts.
     * @param baseY    The Y coordinate where the food bar starts.
     */
    private void renderFoodBar(class_332 graphics, int baseX, int baseY) {

        class_1657 player = getCameraPlayer();
        if (player == null) return;

        // Enable blending and set the shader color with the desired opacity.
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);

        class_1702 foodData = player.method_7344();
        int foodLevel = foodData.method_7586();

        if (isEditor()) {
            foodLevel = 9;
        }

        final int numIcons = 10;
        final int ICON_WIDTH = 9;
        final int ICON_HEIGHT = 9;
        final int ICON_SPACING = 8;
        // When rendering left-to-right (for left- and center–based alignments),
        // we want to mirror the icon textures.
        boolean mirrorIcons = shouldRenderIconsLeftToRight();

        // Determine which set of sprites to use based on hunger effect
        class_2960 emptySprite;
        class_2960 halfSprite;
        class_2960 fullSprite;

        if (player.method_6059(class_1294.field_5903)) {
            emptySprite = FOOD_EMPTY_HUNGER_SPRITE;
            halfSprite = FOOD_HALF_HUNGER_SPRITE;
            fullSprite = FOOD_FULL_HUNGER_SPRITE;
        } else {
            emptySprite = FOOD_EMPTY_SPRITE;
            halfSprite = FOOD_HALF_SPRITE;
            fullSprite = FOOD_FULL_SPRITE;
        }

        // Loop through each food icon slot.
        for (int i = 0; i < numIcons; i++) {

            // Determine horizontal position based on drawing order.
            int iconX = mirrorIcons ? baseX + i * ICON_SPACING : baseX + ((numIcons - 1 - i) * ICON_SPACING);
            int iconY = baseY;

            // Apply a slight vertical wiggle if saturation is depleted.
            if (foodData.method_7589() <= 0.0f && tickCount % (foodLevel * 3 + 1) == 0) {
                iconY += this.random.method_43048(3) - 1; // Random offset: -1, 0, or 1
            }

            // Always draw the empty food icon first
            if (mirrorIcons) {
                // Draw mirrored icons
                SpiffyRenderUtils.blitSpriteMirrored(graphics, emptySprite, iconX, iconY, ICON_WIDTH, ICON_HEIGHT);

                if (i * 2 + 1 < foodLevel) {
                    // Full food icon
                    SpiffyRenderUtils.blitSpriteMirrored(graphics, fullSprite, iconX, iconY, ICON_WIDTH, ICON_HEIGHT);
                } else if (i * 2 + 1 == foodLevel) {
                    // Half food icon
                    SpiffyRenderUtils.blitSpriteMirrored(graphics, halfSprite, iconX, iconY, ICON_WIDTH, ICON_HEIGHT);
                }
            } else {
                // Normal (non-mirrored) drawing using sprites
                graphics.method_52706(emptySprite, iconX, iconY, ICON_WIDTH, ICON_HEIGHT);

                if (i * 2 + 1 < foodLevel) {
                    // Full food icon
                    graphics.method_52706(fullSprite, iconX, iconY, ICON_WIDTH, ICON_HEIGHT);
                } else if (i * 2 + 1 == foodLevel) {
                    // Half food icon
                    graphics.method_52706(halfSprite, iconX, iconY, ICON_WIDTH, ICON_HEIGHT);
                }
            }

        }

        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);

    }

    /**
     * Helper method to determine whether the food icons should be rendered left-to-right.
     * Returns true for left-based and center-based alignments.
     *
     * @return true if alignment is TOP_LEFT, MID_LEFT, BOTTOM_LEFT, TOP_CENTERED, MID_CENTERED, or BOTTOM_CENTERED.
     */
    private boolean shouldRenderIconsLeftToRight() {
        return spiffyAlignment == SpiffyAlignment.TOP_LEFT ||
                spiffyAlignment == SpiffyAlignment.MID_LEFT ||
                spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT ||
                spiffyAlignment == SpiffyAlignment.TOP_CENTERED ||
                spiffyAlignment == SpiffyAlignment.MID_CENTERED ||
                spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED;
    }

    @Nullable
    private class_1657 getCameraPlayer() {
        return (class_310.method_1551().method_1560() instanceof class_1657 p) ? p : null;
    }

    @Override
    public int getAbsoluteWidth() {
        return BAR_WIDTH;
    }

    @Override
    public int getAbsoluteHeight() {
        return BAR_HEIGHT;
    }

}
