package de.keksuccino.spiffyhud.customization.placeholders;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.spiffyhud.mixin.mixins.common.client.IMixinSpectatorGui;
import de.keksuccino.spiffyhud.util.ComponentUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_531;
import net.minecraft.class_537;

public class SlotItemDisplayNamePlaceholder extends Placeholder {

    public SlotItemDisplayNamePlaceholder() {
        super("slot_item_display_name");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String slot = dps.values.get("slot");
        boolean ignoreSpectator = SerializationUtils.deserializeBoolean(false, dps.values.get("ignore_spectator"));
        if ((slot != null) && MathUtils.isInteger(slot) && (class_310.method_1551().field_1724 != null)) {
            int slotInt = Integer.parseInt(slot);
            class_1799 stack = class_310.method_1551().field_1724.method_31548().method_5438(slotInt);
            if (class_310.method_1551().field_1724.method_7325() && (slotInt >= 0) && (slotInt <= 8) && !ignoreSpectator) { // If slot is a hotbar slot and player is Spectator, return Spectator GUI slot names
                IMixinSpectatorGui accessor = (IMixinSpectatorGui) class_310.method_1551().field_1705.method_1739();
                class_531 menu = accessor.get_menu_Spiffy();
                if (menu != null) {
                    class_537 spectatorMenuItem = menu.method_2774();
                    class_5250 mutableComponent = (class_5250) ((spectatorMenuItem == class_531.field_3260) ? menu.method_2776().method_2781() : spectatorMenuItem.method_16892());
                    return ComponentUtils.toJson(mutableComponent);
                }
            } else if (!stack.method_7960()) {
                class_5250 mutableComponent = class_2561.method_43473().method_10852(stack.method_7964()).method_27692(stack.method_7932().method_58413());
                return ComponentUtils.toJson(mutableComponent);
            }
        }
        return "";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("slot", "ignore_spectator");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("spiffyhud.placeholders.slot_item_display_name");
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("spiffyhud.placeholders.slot_item_display_name.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<>();
        values.put("slot", "slot_number");
        values.put("ignore_spectator", "false");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

}
