package de.keksuccino.spiffyhud.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.spiffyhud.customization.elements.chatcustomizer.ChatCustomizerHandler;
import net.minecraft.class_332;
import net.minecraft.class_408;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_408.class)
public class MixinChatScreen {

    /**
     * Apply custom input field background color
     */
    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"))
    private void customizeInputBackgroundFill_Spiffy(class_332 graphics, int minX, int minY, int maxX, int maxY, int color, Operation<Void> original) {
        if (ChatCustomizerHandler.inputBackgroundColor != null) {
            // Use the custom color with its own alpha
            int customColor = ChatCustomizerHandler.inputBackgroundColor.getColorInt();
            original.call(graphics, minX, minY, maxX, maxY, customColor);
        } else {
            original.call(graphics, minX, minY, maxX, maxY, color);
        }
    }

}