package de.keksuccino.spiffyhud.networking.packets.structure.structures;

import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.spiffyhud.util.level.StructureUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3222;

public class StructuresPacketLogic {

    private static final Logger LOGGER = LogManager.getLogger();

    protected static boolean handleOnServer(@NotNull StructuresPacket packet, @NotNull class_3222 sender) {
        StructuresPacket answer = new StructuresPacket();
        List<String> keys = new ArrayList<>();
        StructureUtils.getAllStructureKeys(sender.method_37908().method_30349()).forEach(structureResourceKey -> keys.add(structureResourceKey.method_29177().toString()));
        answer.keys = keys;
        PacketHandler.sendToClient(sender, answer);
        return true;
    }

    protected static boolean handleOnClient(@NotNull StructuresPacket packet) {
        if (packet.keys != null) {
            MainThreadTaskExecutor.executeInMainThread(() -> {
                StructuresPacket.CACHED_SERVER_STRUCTURE_KEYS.clear();
                StructuresPacket.CACHED_SERVER_STRUCTURE_KEYS.addAll(packet.keys);
            }, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
            return true;
        }
        return false;
    }

}
