package de.keksuccino.spiffyhud.util.rendering;

import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class ElementMobilizer {

    /**
     * Moves the render body to the given X and Y coordinates after correcting the body's position to X=0 and Y=0.
     *
     * @param graphics The {@link class_332} instance for rendering.
     * @param offsetCorrectTo0X The X offset to move the render body to X=0.
     * @param offsetCorrectTo0Y The Y offset to move the render body to Y=0.
     * @param posX The final X position of the render body.
     * @param posY The final Y position of the render body.
     * @param renderBody The render body.
     */
    public static void mobilize(@NotNull class_332 graphics, int offsetCorrectTo0X, int offsetCorrectTo0Y, int posX, int posY, @NotNull Runnable renderBody) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(offsetCorrectTo0X + posX, offsetCorrectTo0Y + posY, 0);
        renderBody.run();
        graphics.method_51448().method_22909();
    }

}
