package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_7833;

/**
 * Utility for rendering a mob's flat front view inside a GUI square.
 */
public class FlatMobRenderUtils {

    private static final class_310 MC = class_310.method_1551();
    private static final float VIEWPORT_FILL_RATIO = 0.92F; // keep a little padding so tall mobs don't clip
    private static final float HALF = 0.5F;
    private static final Map<class_1308, class_1308> RENDER_CLONES = new WeakHashMap<>();

    private FlatMobRenderUtils() {
    }

    public static boolean renderFlatMob(@NotNull class_332 graphics, int left, int top, int size, @Nullable class_1308 mob, float opacity) {
        class_1308 renderMob = prepareRenderMob(mob);
        if (renderMob == null) {
            return false;
        }
        graphics.method_44379(left, top, left + size, top + size);
        float centerX = left + size / 2.0F;
        float centerY = top + size / 2.0F;
        MobBounds bounds = captureBounds(renderMob);
        float scale = computeScale(bounds, size);
        Vector3f offset = new Vector3f(0.0F, bounds.height * HALF, 0.0F);
        Quaternionf baseRotation = class_7833.field_40718.rotationDegrees(180.0F);

        float originalBody = renderMob.field_6283;
        float originalBodyO = renderMob.field_6220;
        float originalYRot = renderMob.method_36454();
        float originalYRotO = renderMob.field_5982;
        float originalXRot = renderMob.method_36455();
        float originalXRotO = renderMob.field_6004;
        float originalHead = renderMob.field_6241;
        float originalHeadO = renderMob.field_6259;

        renderMob.method_5636(180.0F);
        renderMob.field_6220 = 180.0F;
        renderMob.method_36456(180.0F);
        renderMob.field_5982 = 180.0F;
        renderMob.method_36457(0.0F);
        renderMob.field_6004 = 0.0F;
        renderMob.method_5847(180.0F);
        renderMob.field_6259 = 180.0F;

        RenderSystem.enableBlend();
        graphics.method_51422(1.0F, 1.0F, 1.0F, opacity);
        graphics.method_51448().method_22903();
        renderEntity(graphics, centerX, centerY, scale, offset, baseRotation, renderMob);
        graphics.method_51448().method_22909();
        graphics.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
        class_308.method_24211();

        renderMob.method_5636(originalBody);
        renderMob.field_6220 = originalBodyO;
        renderMob.method_36456(originalYRot);
        renderMob.field_5982 = originalYRotO;
        renderMob.method_36457(originalXRot);
        renderMob.field_6004 = originalXRotO;
        renderMob.method_5847(originalHead);
        renderMob.field_6259 = originalHeadO;

        graphics.method_44380();
        return true;
    }

    private static void renderEntity(@NotNull class_332 graphics, float centerX, float centerY, float scale, @NotNull Vector3f offset, @NotNull Quaternionf modelRotation, @NotNull class_1308 mob) {
        graphics.method_51448().method_22904(centerX, centerY, 50.0);
        graphics.method_51448().method_22905(scale, scale, -scale);
        graphics.method_51448().method_46416(offset.x, offset.y, offset.z);
        graphics.method_51448().method_22907(modelRotation);
        class_308.method_34742();
        var dispatcher = class_310.method_1551().method_1561();
        dispatcher.method_3948(false);
        RenderSystem.runAsFancy(() -> dispatcher.method_3954(mob, 0.0, 0.0, 0.0, 0.0F, 1.0F, graphics.method_51448(), graphics.method_51450(), 15728880));
        graphics.method_51452();
        dispatcher.method_3948(true);
        class_308.method_24211();
    }

    @NotNull
    private static MobBounds captureBounds(@NotNull class_1308 mob) {
        class_238 boundingBox = mob.method_5829();
        double width = boundingBox.field_1320 - boundingBox.field_1323;
        double height = boundingBox.field_1325 - boundingBox.field_1322;
        double depth = boundingBox.field_1324 - boundingBox.field_1321;
        float widthF = (float) Math.max(width, 0.001F);
        float heightF = (float) Math.max(height, 0.001F);
        float depthF = (float) Math.max(depth, 0.001F);
        return new MobBounds(heightF, Math.max(widthF, depthF));
    }

    private static float computeScale(@NotNull MobBounds bounds, int size) {
        float dominant = Math.max(bounds.height, bounds.horizontal);
        float available = Math.max(size * VIEWPORT_FILL_RATIO, 1.0F);
        return available / dominant;
    }

    @Nullable
    private static class_1308 prepareRenderMob(@Nullable class_1308 source) {
        if (!isRenderableSource(source)) {
            evict(source);
            return null;
        }
        class_1937 level = source.method_37908();
        if (level == null) {
            evict(source);
            return null;
        }
        class_1308 clone = RENDER_CLONES.get(source);
        if (clone == null || clone.method_31481() || clone.method_37908() != level) {
            clone = createClone(source);
            if (clone == null) {
                evict(source);
                return null;
            }
            RENDER_CLONES.put(source, clone);
        }
        return clone;
    }

    private static boolean isRenderableSource(@Nullable class_1308 source) {
        return source != null && source.method_5805() && !source.method_31481();
    }

    private static void evict(@Nullable class_1308 source) {
        if (source != null) {
            RENDER_CLONES.remove(source);
        }
    }

    @Nullable
    private static class_1308 createClone(@NotNull class_1308 source) {
        class_1937 level = source.method_37908();
        if (level == null) {
            level = MC.field_1687;
        }
        if (level == null) {
            return null;
        }
        var created = source.method_5864().method_5883(level);
        if (!(created instanceof class_1308 copy)) {
            return null;
        }
        copy.method_5875(true);
        copy.method_5977(true);
        copy.field_5960 = true;
        copy.method_5803(true);
        copyMobData(source, copy);
        return copy;
    }

    private static void copyMobData(@NotNull class_1308 source, @NotNull class_1308 target) {
        class_2487 tag = new class_2487();
        source.method_5647(tag);
        tag.method_10556("PersistenceRequired", false);
        target.method_5651(tag);
        target.method_5875(true);
        target.method_5977(true);
        target.field_5960 = true;
        target.method_5803(true);
    }

    private static final class MobBounds {
        private final float height;
        private final float horizontal;

        private MobBounds(float height, float horizontal) {
            this.height = height;
            this.horizontal = horizontal;
        }
    }

}
