package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import net.minecraft.class_1058;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class SpiffyRenderUtils {

    private static boolean blendLocked = false;

    public static void lockBlend(boolean lock) {
        blendLocked = true;
    }

    public static boolean isBlendLocked() {
        return blendLocked;
    }

    /**
     * Draws a textured quad with the U texture coordinates swapped so that the image appears mirrored horizontally.
     *
     * @param graphics       The graphics context.
     * @param atlasLocation  The texture atlas.
     * @param x              The screen X coordinate.
     * @param y              The screen Y coordinate.
     * @param blitOffset     The z-level (blit offset).
     * @param u              The source U coordinate (left edge) of the texture.
     * @param v              The source V coordinate (top edge) of the texture.
     * @param width          The width of the quad.
     * @param height         The height of the quad.
     * @param textureWidth   The width of the texture.
     * @param textureHeight  The height of the texture.
     */
    public static void blitMirrored(class_332 graphics, class_2960 atlasLocation, int x, int y, int blitOffset, int u, int v, int width, int height, int textureWidth, int textureHeight) {

        RenderSystem.setShaderTexture(0, atlasLocation);
        RenderSystem.setShader(class_757::method_34542);

        RenderSystem.enableBlend();

        // Calculate texture coordinates.
        float minU = (u + width) / (float) textureWidth;
        float maxU = u / (float) textureWidth;
        float minV = v / (float) textureHeight;
        float maxV = (v + height) / (float) textureHeight;

        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, (float)x, (float)y, (float)blitOffset).method_22913(minU, minV);
        bufferBuilder.method_22918(matrix, (float)x, (float)(y + height), (float)blitOffset).method_22913(minU, maxV);
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)(y + height), (float)blitOffset).method_22913(maxU, maxV);
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)y, (float)blitOffset).method_22913(maxU, minV);
        class_286.method_43433(bufferBuilder.method_60800());

        RenderSystem.disableBlend();

    }
    
    /**
     * Draws a sprite horizontally mirrored (flipped along the vertical axis).
     * This method is specifically designed for sprite resources and handles sprite texture coordinates.
     *
     * @param graphics  The graphics context.
     * @param sprite    The sprite resource location.
     * @param x         The screen X coordinate.
     * @param y         The screen Y coordinate.
     * @param width     The width of the sprite.
     * @param height    The height of the sprite.
     */
    public static void blitSpriteMirrored(class_332 graphics, class_2960 sprite, int x, int y, int width, int height) {
        
        // Use the internal method for sprite rendering that matches what GuiGraphics does
        // but with horizontally mirrored texture coordinates
        class_1058 atlasSprite = class_310.method_1551().method_52699().method_18667(sprite);
        
        RenderSystem.setShaderTexture(0, atlasSprite.method_45852());
        RenderSystem.setShader(class_757::method_34542);
        
        // For horizontal mirroring, swap U coordinates
        float minU = atlasSprite.method_4577();
        float maxU = atlasSprite.method_4594();
        float minV = atlasSprite.method_4593();
        float maxV = atlasSprite.method_4575();
        
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(minU, minV);
        bufferBuilder.method_22918(matrix, (float)x, (float)(y + height), 0.0f).method_22913(minU, maxV);
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)(y + height), 0.0f).method_22913(maxU, maxV);
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)y, 0.0f).method_22913(maxU, minV);
        class_286.method_43433(bufferBuilder.method_60800());

    }

}
