/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.ObjectHolder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import de.keksuccino.spiffyhud.customization.elements.Elements;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.air.VanillaLikePlayerAirElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.armor.VanillaLikePlayerArmorElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.bossbars.VanillaLikeBossOverlayElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.effects.VanillaLikeEffectsElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.experience.VanillaLikeExperienceElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.food.VanillaLikePlayerFoodElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.hotbar.VanillaLikeHotbarElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.jumpmeter.VanillaLikeJumpMeterElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.mounthealth.VanillaLikeMountHealthElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.playerhealth.VanillaLikePlayerHealthElement;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SpiffyOverlayScreen
extends class_437 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 CROSSHAIR_SPRITE = class_2960.method_60656((String)"hud/crosshair");
    private static final class_2960 CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = class_2960.method_60656((String)"hud/crosshair_attack_indicator_background");
    private static final class_2960 CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = class_2960.method_60656((String)"hud/crosshair_attack_indicator_progress");
    private static final class_2960 HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE = class_2960.method_60656((String)"hud/hotbar_attack_indicator_background");
    private static final class_2960 HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE = class_2960.method_60656((String)"hud/hotbar_attack_indicator_progress");
    private static final VanillaLikeHotbarElement HOTBAR_ELEMENT = Elements.VANILLA_LIKE_HOTBAR.buildDefaultInstance();
    private static final VanillaLikeJumpMeterElement JUMP_METER_ELEMENT = Elements.VANILLA_LIKE_JUMP_METER.buildDefaultInstance();
    private static final VanillaLikeExperienceElement EXPERIENCE_ELEMENT = Elements.VANILLA_LIKE_EXPERIENCE.buildDefaultInstance();
    private static final VanillaLikePlayerFoodElement FOOD_ELEMENT = Elements.VANILLA_LIKE_PLAYER_FOOD.buildDefaultInstance();
    private static final VanillaLikePlayerArmorElement ARMOR_ELEMENT = Elements.VANILLA_LIKE_PLAYER_ARMOR.buildDefaultInstance();
    private static final VanillaLikePlayerAirElement AIR_ELEMENT = Elements.VANILLA_LIKE_PLAYER_AIR.buildDefaultInstance();
    private static final VanillaLikeMountHealthElement MOUNT_HEALTH_ELEMENT = Elements.VANILLA_LIKE_MOUNT_HEALTH.buildDefaultInstance();
    private static final VanillaLikePlayerHealthElement PLAYER_HEALTH_ELEMENT = Elements.VANILLA_LIKE_PLAYER_HEALTH.buildDefaultInstance();
    private static final VanillaLikeBossOverlayElement BOSS_OVERLAY_ELEMENT = Elements.VANILLA_LIKE_BOSS_OVERLAY.buildDefaultInstance();
    private static final VanillaLikeEffectsElement EFFECTS_ELEMENT = Elements.VANILLA_LIKE_EFFECTS.buildDefaultInstance();
    public final boolean showFancyMenuOverlay;
    protected final class_327 font;
    protected final class_310 minecraft;

    public SpiffyOverlayScreen(boolean showFancyMenuOverlay) {
        super((class_2561)class_2561.method_43473());
        this.font = class_310.method_1551().field_1772;
        this.minecraft = class_310.method_1551();
        this.forceEnableCustomizations();
        this.showFancyMenuOverlay = showFancyMenuOverlay;
    }

    protected void forceEnableCustomizations() {
        if (!ScreenCustomization.isCustomizationEnabledForScreen((class_437)this)) {
            LOGGER.info("[SPIFFY HUD] Force-enabling customizations for SpiffyOverlayScreen..");
            ScreenCustomization.setCustomizationForScreenEnabled((class_437)this, (boolean)true);
        }
    }

    protected void method_25426() {
        ((RendererWidget)this.method_37063((class_364)this.buildHotbarWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.hotbar"));
        ((RendererWidget)this.method_37063((class_364)this.buildJumpMeterWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.jump_meter"));
        ((RendererWidget)this.method_37063((class_364)this.buildExperienceBarWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.experience_bar"));
        ((RendererWidget)this.method_37063((class_364)this.buildSelectedItemNameWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.selected_item_name"));
        ((RendererWidget)this.method_37063((class_364)this.buildScoreboardSidebarWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.scoreboard_sidebar"));
        ((RendererWidget)this.method_37063((class_364)this.buildFoodBarWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.food_bar"));
        ((RendererWidget)this.method_37063((class_364)this.buildArmorBarWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.armor_bar"));
        ((RendererWidget)this.method_37063((class_364)this.buildAirBarWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.air_bar"));
        ((RendererWidget)this.method_37063((class_364)this.buildHealthBarWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.health_bar"));
        ((RendererWidget)this.method_37063((class_364)this.buildMountHealthBarWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.mount_health_bar"));
        ((RendererWidget)this.method_37063((class_364)this.buildOverlayMessageWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.overlay_message"));
        ((RendererWidget)this.method_37063((class_364)this.buildCrosshairWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.crosshair"));
        ((RendererWidget)this.method_37063((class_364)this.buildAttackIndicatorWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.attack_indicator"));
        ((RendererWidget)this.method_37063((class_364)this.buildTitleWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.title"));
        ((RendererWidget)this.method_37063((class_364)this.buildSubtitleWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.subtitle"));
        ((RendererWidget)this.method_37063((class_364)this.buildBossBarWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.boss_bars"));
        ((RendererWidget)this.method_37063((class_364)this.buildEffectsWidget())).method_25355((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.effects"));
    }

    public void method_25394(@NotNull class_332 $$0, int $$1, int $$2, float $$3) {
        if (!(class_310.method_1551().field_1755 instanceof LayoutEditorScreen)) {
            return;
        }
        this.method_25396().forEach(guiEventListener -> {
            if (guiEventListener instanceof class_4068) {
                class_4068 renderable = (class_4068)guiEventListener;
                renderable.method_25394($$0, $$1, $$2, $$3);
            }
        });
    }

    public void method_25420(class_332 $$0, int $$1, int $$2, float $$3) {
    }

    protected RendererWidget buildHotbarWidget() {
        int screenCenter = this.field_22789 / 2;
        int x = screenCenter - 91;
        int y = this.field_22790 - 22;
        int widgetWidth = 182;
        int widgetHeight = 22;
        return new SpiffyRendererWidget(x, y, widgetWidth, widgetHeight, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.HOTBAR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.HOTBAR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.HOTBAR_ELEMENT.posOffsetY = gy - 2;
            HOTBAR_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_hotbar_dummy");
    }

    protected RendererWidget buildJumpMeterWidget() {
        int screenCenter = this.field_22789 / 2;
        int x = screenCenter - 91;
        int y = this.field_22790 - 32 + 3 - 5;
        int width = 182;
        int height = 5;
        return new SpiffyRendererWidget(x, y, width, height, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.JUMP_METER_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.JUMP_METER_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.JUMP_METER_ELEMENT.posOffsetY = gy;
            JUMP_METER_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_jump_meter_dummy");
    }

    protected RendererWidget buildExperienceBarWidget() {
        int screenCenter = this.field_22789 / 2;
        int x = screenCenter - 91;
        int y = this.field_22790 - 32 + 3;
        int width = 182;
        int height = 5;
        return new SpiffyRendererWidget(x, y, width, height, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.EXPERIENCE_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.EXPERIENCE_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.EXPERIENCE_ELEMENT.posOffsetY = gy;
            EXPERIENCE_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_experience_bar_dummy");
    }

    protected RendererWidget buildSelectedItemNameWidget() {
        class_5250 mutableComponent = class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.selected_item_name")).method_27692(class_124.field_1076);
        int textWidth = this.font.method_27525((class_5348)mutableComponent);
        int textX = (this.field_22789 - textWidth) / 2;
        int textY = this.field_22790 - 59 - 18;
        Objects.requireNonNull(this.font);
        return new SpiffyRendererWidget(textX, textY, textWidth, 9, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            RenderSystem.enableBlend();
            Objects.requireNonNull(this.font);
            graphics.method_25294(textX - 2, textY - 2, textX + textWidth + 2, textY + 9 + 2, class_310.method_1551().field_1690.method_19344(0));
            graphics.method_27535(this.font, (class_2561)mutableComponent, textX, textY, -1);
            RenderingUtils.resetShaderColor((class_332)graphics);
        }).setWidgetIdentifierFancyMenu("spiffy_selected_item_name_dummy");
    }

    protected RendererWidget buildScoreboardSidebarWidget() {
        int titleWidth;
        String spacer = ": ";
        ArrayList<DisplayEntry> entryList = new ArrayList<DisplayEntry>();
        class_5250 name = class_2561.method_43471((String)"spiffyhud.elements.dummy.scoreboard_sidebar.line");
        class_5250 score = class_2561.method_43470((String)"0").method_27692(class_124.field_1061);
        int scoreWidth = this.font.method_27525((class_5348)score);
        record DisplayEntry(class_2561 name, class_2561 score, int scoreWidth) {
        }
        entryList.add(new DisplayEntry((class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), scoreWidth));
        entryList.add(new DisplayEntry((class_2561)name, (class_2561)score, scoreWidth));
        entryList.add(new DisplayEntry((class_2561)name, (class_2561)score, scoreWidth));
        entryList.add(new DisplayEntry((class_2561)name, (class_2561)score, scoreWidth));
        entryList.add(new DisplayEntry((class_2561)name, (class_2561)score, scoreWidth));
        entryList.add(new DisplayEntry((class_2561)name, (class_2561)score, scoreWidth));
        entryList.add(new DisplayEntry((class_2561)name, (class_2561)score, scoreWidth));
        DisplayEntry[] entries = entryList.toArray(new DisplayEntry[0]);
        class_5250 title = class_2561.method_43471((String)"spiffyhud.elements.dummy.scoreboard_sidebar.title").method_27692(class_124.field_1067);
        int totalSidebarWidth = titleWidth = this.font.method_27525((class_5348)title);
        int spacerWidth = this.font.method_1727(spacer);
        for (DisplayEntry entry : entries) {
            totalSidebarWidth = Math.max(totalSidebarWidth, this.font.method_27525((class_5348)entry.name) + (entry.scoreWidth > 0 ? spacerWidth + entry.scoreWidth : 0));
        }
        int linesCount = entries.length;
        Objects.requireNonNull(this.font);
        int linesHeight = linesCount * 9;
        int sidebarYEnd = this.field_22790 / 2 + linesHeight / 3;
        int sidebarXStart = this.field_22789 - totalSidebarWidth - 3;
        int sidebarXEnd = this.field_22789 - 3 + 2;
        int backgroundColorNormal = this.minecraft.field_1690.method_19345(0.3f);
        int backgroundColorTitle = this.minecraft.field_1690.method_19345(0.4f);
        Objects.requireNonNull(this.font);
        int sidebarYBase = sidebarYEnd - linesCount * 9;
        int finalTotalSidebarWidth = totalSidebarWidth;
        Objects.requireNonNull(this.font);
        int sidebarY = sidebarYBase - 9 - 1;
        int sidebarHeight = Math.max(1, sidebarYEnd - sidebarY);
        return new SpiffyRendererWidget(sidebarXStart, sidebarY, totalSidebarWidth, sidebarHeight, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> this.lambda$buildScoreboardSidebarWidget$5(sidebarXStart, sidebarYBase, sidebarXEnd, backgroundColorTitle, sidebarYEnd, backgroundColorNormal, (class_2561)title, finalTotalSidebarWidth, titleWidth, linesCount, entries, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_scoreboard_sidebar_dummy");
    }

    protected RendererWidget buildFoodBarWidget() {
        int barX = this.field_22789 / 2 + 91;
        int barY = this.field_22790 - 39 - 5;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.FOOD_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.FOOD_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.FOOD_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.FOOD_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            FOOD_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_food_bar_dummy");
    }

    protected RendererWidget buildArmorBarWidget() {
        int barX = this.field_22789 / 2 - 91;
        int barY = this.field_22790 - 39 - 10 - 5;
        return new SpiffyRendererWidget(barX, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.ARMOR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.ARMOR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.ARMOR_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.ARMOR_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_LEFT;
            ARMOR_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_armor_bar_dummy");
    }

    protected RendererWidget buildAirBarWidget() {
        int barX = this.field_22789 / 2 + 91;
        int barY = this.field_22790 - 39 - 10 - 5;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.AIR_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.AIR_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.AIR_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.AIR_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            AIR_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_air_bar_dummy");
    }

    protected RendererWidget buildMountHealthBarWidget() {
        int barX = this.field_22789 / 2 + 91;
        int barY = this.field_22790 - 39 - 10 - 15;
        return new SpiffyRendererWidget(barX - 80, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_RIGHT;
            SpiffyOverlayScreen.MOUNT_HEALTH_ELEMENT.isUsedAsDummy = true;
            MOUNT_HEALTH_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_mount_health_bar_dummy");
    }

    protected RendererWidget buildHealthBarWidget() {
        int barX = this.field_22789 / 2 - 91;
        int barY = this.field_22790 - 39 - 5;
        return new SpiffyRendererWidget(barX, barY, 80, 9, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.spiffyAlignment = SpiffyAlignment.MID_LEFT;
            SpiffyOverlayScreen.PLAYER_HEALTH_ELEMENT.isUsedAsDummy = true;
            PLAYER_HEALTH_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_health_bar_dummy");
    }

    protected RendererWidget buildOverlayMessageWidget() {
        class_5250 message = class_2561.method_43470((String)"Overlay Message");
        int messageWidth = this.font.method_27525((class_5348)message);
        int textX = this.field_22789 / 2 - messageWidth / 2;
        int textY = this.field_22790 - 68 - 4 - 18;
        ObjectHolder animatedTickHolder = ObjectHolder.of((Object)Float.valueOf(0.0f));
        Objects.requireNonNull(this.font);
        return new SpiffyRendererWidget(textX - 2, textY - 2, messageWidth + 4, 9 + 4, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> SpiffyOverlayScreen.lambda$buildOverlayMessageWidget$11(animatedTickHolder, (class_2561)message, textX, textY, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_overlay_message_dummy");
    }

    protected RendererWidget buildCrosshairWidget() {
        int crosshairX = (this.field_22789 - 15) / 2;
        int crosshairY = (this.field_22790 - 15) / 2;
        return new SpiffyRendererWidget(crosshairX, crosshairY, 15, 15, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            graphics.method_52706(CROSSHAIR_SPRITE, crosshairX, crosshairY, 15, 15);
            RenderSystem.defaultBlendFunc();
            RenderingUtils.resetShaderColor((class_332)graphics);
        }).setWidgetIdentifierFancyMenu("spiffy_crosshair_dummy");
    }

    protected RendererWidget buildAttackIndicatorWidget() {
        int crossX = this.field_22789 / 2 + 1;
        int crossY = this.field_22790 / 2 - 7 + 16 + 40;
        int hotX = crossX - 2 - 18;
        int hotY = crossY - 6;
        float progress = 0.5f;
        return new SpiffyRendererWidget(hotX, hotY, 36, 18, (graphics, mouseX, mouseY, partial, x, y, width, height, widget) -> {
            RenderSystem.enableBlend();
            int fillWidth = (int)(progress * 16.0f);
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            graphics.method_52706(CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, crossX, crossY, 16, 4);
            if (fillWidth > 0) {
                graphics.method_52708(CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, crossX, crossY, fillWidth, 4);
            }
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableBlend();
            int fillHeight = (int)(progress * 18.0f);
            graphics.method_52706(HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE, hotX, hotY, 18, 18);
            if (fillHeight > 0) {
                graphics.method_52708(HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE, 18, 18, 0, 18 - fillHeight, hotX, hotY + 18 - fillHeight, 18, fillHeight);
            }
            RenderingUtils.resetShaderColor((class_332)graphics);
        }).setWidgetIdentifierFancyMenu("spiffy_attack_indicator_dummy");
    }

    protected RendererWidget buildTitleWidget() {
        class_5250 title = class_2561.method_43471((String)"spiffyhud.elements.dummy.title");
        int titleWidth = this.font.method_27525((class_5348)title);
        int totalWidth = titleWidth * 4;
        Objects.requireNonNull(this.font);
        int totalHeight = 9 * 4;
        int textX = this.field_22789 / 2 - totalWidth / 2;
        int textY = this.field_22790 / 2 - 48;
        return new SpiffyRendererWidget(textX, textY, totalWidth, totalHeight, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> this.lambda$buildTitleWidget$14((class_2561)title, titleWidth, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_title_dummy");
    }

    protected RendererWidget buildSubtitleWidget() {
        class_5250 subtitle = class_2561.method_43470((String)"Subtitle");
        int subtitleWidth = this.font.method_27525((class_5348)subtitle);
        int totalWidth = subtitleWidth * 2;
        Objects.requireNonNull(this.font);
        int totalHeight = 9 * 2;
        int textX = this.field_22789 / 2 - totalWidth / 2;
        int textY = this.field_22790 / 2 + 12;
        return new SpiffyRendererWidget(textX, textY, totalWidth, totalHeight, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> this.lambda$buildSubtitleWidget$15((class_2561)subtitle, subtitleWidth, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8)).setWidgetIdentifierFancyMenu("spiffy_subtitle_dummy");
    }

    protected RendererWidget buildBossBarWidget() {
        int barX = this.field_22789 / 2 - 91;
        int barY = 12;
        int totalY = barY - 9;
        int totalHeight = 53;
        return new SpiffyRendererWidget(barX, totalY, 182, totalHeight, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.BOSS_OVERLAY_ELEMENT.spiffyAlignment = SpiffyAlignment.TOP_CENTERED;
            BOSS_OVERLAY_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_boss_bars_dummy");
    }

    protected RendererWidget buildEffectsWidget() {
        return new SpiffyRendererWidget(this.field_22789 - 50 - 1, 1, 50, 50, (graphics, mX, mY, partial, gx, gy, gwidth, gheight, widget) -> {
            SpiffyOverlayScreen.EFFECTS_ELEMENT.anchorPoint = ElementAnchorPoints.TOP_LEFT;
            SpiffyOverlayScreen.EFFECTS_ELEMENT.posOffsetX = gx;
            SpiffyOverlayScreen.EFFECTS_ELEMENT.posOffsetY = gy;
            SpiffyOverlayScreen.EFFECTS_ELEMENT.spiffyAlignment = SpiffyAlignment.TOP_RIGHT;
            EFFECTS_ELEMENT.method_25394(graphics, mX, mY, partial);
        }).setWidgetIdentifierFancyMenu("spiffy_effects_dummy");
    }

    private /* synthetic */ void lambda$buildSubtitleWidget$15(class_2561 subtitle, int subtitleWidth, class_332 graphics, int mX, int mY, float partial, int gx, int gy, int gwidth, int gheight, RendererWidget widget) {
        RenderSystem.enableBlend();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)(this.field_22789 / 2), (float)(this.field_22790 / 2), 0.0f);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(2.0f, 2.0f, 2.0f);
        graphics.method_27535(class_310.method_1551().field_1772, subtitle, -subtitleWidth / 2, 6, 0xFFFFFF);
        graphics.method_51448().method_22909();
        graphics.method_51448().method_22909();
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    private /* synthetic */ void lambda$buildTitleWidget$14(class_2561 title, int titleWidth, class_332 graphics, int mouseX, int mouseY, float partial, int x, int y, int width, int height, RendererWidget widget) {
        RenderSystem.enableBlend();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(4.0f, 4.0f, 4.0f);
        graphics.method_27535(this.font, title, -titleWidth / 2, -12, -1);
        graphics.method_51448().method_22909();
        graphics.method_51448().method_22909();
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    private static /* synthetic */ void lambda$buildOverlayMessageWidget$11(ObjectHolder animatedTickHolder, class_2561 message, int textX, int textY, class_332 graphics, int mX, int mY, float partial, int gx, int gy, int gwidth, int gheight, RendererWidget widget) {
        RenderSystem.enableBlend();
        animatedTickHolder.set((Object)Float.valueOf(((Float)animatedTickHolder.get()).floatValue() + 0.005f));
        int animatedTextColor = class_3532.method_15369((float)class_3532.method_15363((float)(((Float)animatedTickHolder.get()).floatValue() % 1.0f), (float)0.0f, (float)1.0f), (float)0.7f, (float)0.6f) | 0xFF000000;
        graphics.method_27535(class_310.method_1551().field_1772, message, textX, textY, animatedTextColor);
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    private /* synthetic */ void lambda$buildScoreboardSidebarWidget$5(int sidebarXStart, int sidebarYBase, int sidebarXEnd, int backgroundColorTitle, int sidebarYEnd, int backgroundColorNormal, class_2561 title, int finalTotalSidebarWidth, int titleWidth, int linesCount, 1DisplayEntry[] entries, class_332 graphics, int mouseX, int mouseY, float partial, int x, int y, int width, int height, RendererWidget widget) {
        RenderSystem.enableBlend();
        Objects.requireNonNull(this.font);
        graphics.method_25294(sidebarXStart - 2, sidebarYBase - 9 - 1, sidebarXEnd, sidebarYBase - 1, backgroundColorTitle);
        graphics.method_25294(sidebarXStart - 2, sidebarYBase - 1, sidebarXEnd, sidebarYEnd, backgroundColorNormal);
        int n = sidebarXStart + finalTotalSidebarWidth / 2 - titleWidth / 2;
        Objects.requireNonNull(this.font);
        graphics.method_51439(this.font, title, n, sidebarYBase - 9, -1, false);
        for (int t = 0; t < linesCount; ++t) {
            DisplayEntry entry = entries[t];
            Objects.requireNonNull(this.font);
            int u = sidebarYEnd - (linesCount - t) * 9;
            graphics.method_51439(this.font, entry.name, sidebarXStart, u, -1, false);
            graphics.method_51439(this.font, entry.score, sidebarXEnd - entry.scoreWidth, u, -1, false);
        }
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    public static class SpiffyRendererWidget
    extends RendererWidget {
        public SpiffyRendererWidget(int x, int y, int width, int height, @NotNull RendererWidget.RendererWidgetBody body) {
            super(x, y, width, height, body);
        }

        public void method_25394(@NotNull class_332 $$0, int $$1, int $$2, float $$3) {
            if (!(class_310.method_1551().field_1755 instanceof LayoutEditorScreen)) {
                return;
            }
            super.method_25394($$0, $$1, $$2, $$3);
        }
    }
}

