/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.player;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.player.PlayerEditorElement;
import de.keksuccino.spiffyhud.customization.elements.player.PlayerElement;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerElementBuilder
extends ElementBuilder<PlayerElement, PlayerEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PlayerElementBuilder() {
        super("spiffy_player");
    }

    @NotNull
    public PlayerElement buildDefaultInstance() {
        PlayerElement i = new PlayerElement(this);
        i.baseWidth = 80;
        i.baseHeight = 300;
        i.stayOnScreen = false;
        i.stickyAnchor = true;
        return i;
    }

    public PlayerElement deserializeElement(@NotNull SerializedElement serialized) {
        PlayerElement element = this.buildDefaultInstance();
        return element;
    }

    @Nullable
    public PlayerElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        PlayerElement e = (PlayerElement)super.deserializeElementInternal(serialized);
        if (e != null) {
            e.stayOnScreen = this.deserializeBoolean(e.stayOnScreen, serialized.getValue("stay_on_screen"));
        }
        return e;
    }

    protected SerializedElement serializeElement(@NotNull PlayerElement element, @NotNull SerializedElement serializeTo) {
        return serializeTo;
    }

    @NotNull
    public PlayerEditorElement wrapIntoEditorElement(@NotNull PlayerElement element, @NotNull LayoutEditorScreen editor) {
        return new PlayerEditorElement(element, editor);
    }

    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return class_2561.method_43471((String)"spiffyhud.elements.player");
    }

    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.elements.player.desc", (String[])new String[0]);
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

