/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.playerheartbar;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerHeartHealthBarElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_SCALE_STRING = "1.0";
    private static final float DEFAULT_SCALE = 1.0f;
    private static final float MIN_SCALE = 0.2f;
    private static final float MAX_SCALE = 70.0f;
    private static final int BASE_HEART_PIXEL_SIZE = 8;
    private static final long BLINK_DURATION_MS = 650L;
    private static final long EDITOR_PREVIEW_INTERVAL_MS = 10000L;
    private static final HeartVisualStyle[] EDITOR_PREVIEW_STYLES = HeartVisualStyle.values();
    private final class_310 minecraft = class_310.method_1551();
    private final class_5819 shakeRandom = class_5819.method_43047();
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;
    public int heartsPerRow = 10;
    public int heartGap = 1;
    @NotNull
    public String scaleMultiplier = "1.0";
    public boolean blinkOnLoss = true;
    public boolean lowHealthShakeEnabled = true;
    public int lowHealthShakeThresholdHearts = 4;
    private final EnumMap<HeartTextureKind, ResourceSupplier<ITexture>> customTextures = new EnumMap(HeartTextureKind.class);
    private float lastRecordedHealth = -1.0f;
    private int cachedTickCount = 0;
    private final Map<Integer, BlinkState> activeBlinkSlots = new HashMap<Integer, BlinkState>();

    public PlayerHeartHealthBarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.stickyAnchor = true;
        this.stayOnScreen = false;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.cachedTickCount = this.safeTickCount();
        PlayerData data = this.collectPlayerData();
        float scale = this.resolveScale();
        RenderMetrics metrics = this.computeMetrics(data, scale);
        this.baseWidth = Math.max(1, metrics.bodyWidth);
        this.baseHeight = Math.max(1, metrics.bodyHeight);
        this.updateBlinkState(data.currentHealth, data.baseHeartSlots);
        if (!this.shouldRender()) {
            return;
        }
        Integer[] aligned = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), metrics.bodyWidth, metrics.bodyHeight);
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
        this.drawHearts(graphics, aligned[0], aligned[1], data, metrics, scale);
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    private void drawHearts(@NotNull class_332 graphics, int originX, int originY, @NotNull PlayerData data, @NotNull RenderMetrics metrics, float scale) {
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        pose.method_46416((float)originX, (float)originY, 0.0f);
        long now = System.currentTimeMillis();
        boolean shake = this.shouldShake(data.currentHealth);
        float shakeStrengthBase = shake ? 0.9f : 0.0f;
        int totalSlots = data.baseHeartSlots + data.absorptionSlots;
        for (int logicalIndex = totalSlots - 1; logicalIndex >= 0; --logicalIndex) {
            HeartTextureKind textureKind;
            boolean isAbsorption = logicalIndex >= data.baseHeartSlots;
            SlotPlacement placement = this.computeSlotPlacement(logicalIndex, metrics);
            if (isAbsorption) {
                int absorptionSlot = logicalIndex - data.baseHeartSlots;
                float absorptionValue = data.absorption - (float)absorptionSlot * 2.0f;
                if (absorptionValue <= 0.0f) continue;
                textureKind = absorptionValue >= 2.0f ? HeartTextureKind.ABSORPTION_FULL : HeartTextureKind.ABSORPTION_HALF;
            } else {
                textureKind = this.resolveBaseTexture(logicalIndex, data, now);
            }
            float appliedShake = shakeStrengthBase > 0.0f && textureKind != HeartTextureKind.EMPTY ? shakeStrengthBase : 0.0f;
            this.renderSingleHeart(graphics, metrics, placement, logicalIndex, textureKind, appliedShake, scale);
        }
        pose.method_22909();
    }

    private HeartTextureKind resolveBaseTexture(int logicalIndex, @NotNull PlayerData data, long now) {
        BlinkState blink = this.activeBlinkSlots.get(logicalIndex);
        if (blink != null) {
            if (now < blink.endTimeMs) {
                HeartTextureKind previous = this.textureFromFill(blink.previousFill, data.visualStyle);
                if (previous == HeartTextureKind.EMPTY) {
                    previous = data.visualStyle.halfTexture;
                }
                return now / 120L % 2L == 0L ? previous : HeartTextureKind.EMPTY;
            }
            this.activeBlinkSlots.remove(logicalIndex);
        }
        float displayedHealth = data.currentHealth;
        float heartLowerBound = (float)logicalIndex * 2.0f;
        float fillValue = displayedHealth - heartLowerBound;
        return this.textureFromFill(fillValue, data.visualStyle);
    }

    private void renderSingleHeart(@NotNull class_332 graphics, @NotNull RenderMetrics metrics, @NotNull SlotPlacement placement, int logicalIndex, @NotNull HeartTextureKind textureKind, float shakeStrengthBase, float scale) {
        float gap = this.heartGap;
        float baseSpacingX = ((float)metrics.baseHeartSize + gap) * scale;
        float baseSpacingY = ((float)metrics.baseHeartSize + gap) * scale;
        float baseX = (float)placement.column * baseSpacingX;
        float baseY = (float)placement.row * baseSpacingY;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (shakeStrengthBase > 0.0f && textureKind != HeartTextureKind.EMPTY) {
            float[] offsets = this.computeShakeOffset(logicalIndex, shakeStrengthBase);
            offsetX = offsets[0];
            offsetY = offsets[1];
        }
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        pose.method_46416(baseX + offsetX, baseY + offsetY, 0.0f);
        pose.method_22905(scale, scale, 1.0f);
        this.drawHeartTexture(graphics, textureKind, metrics.baseHeartSize);
        pose.method_22909();
    }

    private float[] computeShakeOffset(int logicalIndex, float shakeStrengthBase) {
        this.shakeRandom.method_43052((long)this.cachedTickCount * 341873128712L + (long)logicalIndex * 132897987541L);
        float dx = (this.shakeRandom.method_43057() - 0.5f) * shakeStrengthBase;
        float dy = (this.shakeRandom.method_43057() - 0.5f) * shakeStrengthBase;
        return new float[]{dx, dy};
    }

    private void drawHeartTexture(@NotNull class_332 graphics, @NotNull HeartTextureKind kind, int size) {
        ResourceSupplier<ITexture> supplier = this.customTextures.get((Object)kind);
        if (supplier != null) {
            try {
                ITexture texture = (ITexture)supplier.get();
                if (texture != null && texture.isReady() && texture.getResourceLocation() != null) {
                    RenderSystem.enableBlend();
                    graphics.method_25290(texture.getResourceLocation(), 0, 0, 0.0f, 0.0f, size, size, size, size);
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.error("[SpiffyHUD] Failed to draw heart texture {}", (Object)kind.name(), (Object)ex);
            }
        }
        graphics.method_25294(0, 0, size, size, this.applyOpacity(kind.defaultColor));
    }

    private int applyOpacity(int argb) {
        int alpha = argb >>> 24 & 0xFF;
        int rgb = argb & 0xFFFFFF;
        int adjustedAlpha = (int)Math.max(0.0f, Math.min(255.0f, (float)alpha * this.opacity));
        return adjustedAlpha << 24 | rgb;
    }

    private RenderMetrics computeMetrics(@NotNull PlayerData data, float scale) {
        int totalSlots = Math.max(1, data.baseHeartSlots + data.absorptionSlots);
        int heartsPerRowClamped = Math.max(1, this.heartsPerRow);
        int rowSize = Math.min(heartsPerRowClamped, totalSlots);
        int rows = Math.max(1, (int)Math.ceil((double)totalSlots / (double)heartsPerRowClamped));
        int gap = Math.max(0, this.heartGap);
        float scaledWidth = (float)(rowSize * 8) * scale + (float)(Math.max(0, rowSize - 1) * gap) * scale;
        float scaledHeight = (float)(rows * 8) * scale + (float)(Math.max(0, rows - 1) * gap) * scale;
        int bodyWidth = Math.max(1, class_3532.method_15386((float)scaledWidth));
        int bodyHeight = Math.max(1, class_3532.method_15386((float)scaledHeight));
        return new RenderMetrics(heartsPerRowClamped, 8, Math.max(1, totalSlots), bodyWidth, bodyHeight, rows, gap, gap);
    }

    private void updateBlinkState(float currentHealth, int baseHeartSlots) {
        long now = System.currentTimeMillis();
        this.cleanupExpiredBlinks(now);
        if (!this.blinkOnLoss || baseHeartSlots <= 0) {
            this.activeBlinkSlots.clear();
            this.lastRecordedHealth = currentHealth;
            return;
        }
        if (this.lastRecordedHealth < 0.0f) {
            this.lastRecordedHealth = currentHealth;
            return;
        }
        if (currentHealth < this.lastRecordedHealth - 0.01f) {
            this.registerBlinkSlots(this.lastRecordedHealth, currentHealth, baseHeartSlots, now);
        } else if (currentHealth > this.lastRecordedHealth + 0.01f) {
            this.activeBlinkSlots.clear();
        }
        this.lastRecordedHealth = currentHealth;
    }

    private boolean shouldShake(float currentHealth) {
        if (!this.lowHealthShakeEnabled) {
            return false;
        }
        if (this.lowHealthShakeThresholdHearts <= 0) {
            return false;
        }
        float threshold = (float)this.lowHealthShakeThresholdHearts * 2.0f;
        return currentHealth <= threshold;
    }

    private int safeTickCount() {
        try {
            return SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private PlayerData collectPlayerData() {
        if (PlayerHeartHealthBarElement.isEditor()) {
            HeartVisualStyle style = this.pickEditorPreviewStyle();
            return new PlayerData(13.0f, 20.0f, 6.0f, style);
        }
        class_746 player = this.minecraft.field_1724;
        if (player == null) {
            return new PlayerData(10.0f, 20.0f, 0.0f, HeartVisualStyle.NORMAL);
        }
        float currentHealth = Math.max(0.0f, player.method_6032());
        float maxHealth = Math.max(2.0f, player.method_6063());
        float absorption = Math.max(0.0f, player.method_6067());
        HeartVisualStyle style = this.resolveVisualStyle((class_1657)player);
        return new PlayerData(currentHealth, maxHealth, absorption, style);
    }

    private HeartVisualStyle resolveVisualStyle(@NotNull class_1657 player) {
        if (player.method_6059(class_1294.field_5920)) {
            return HeartVisualStyle.WITHER;
        }
        if (player.method_6059(class_1294.field_5899)) {
            return HeartVisualStyle.POISON;
        }
        if (player.method_32312() > 0) {
            return HeartVisualStyle.FROZEN;
        }
        if (player.method_5809()) {
            return HeartVisualStyle.BURNING;
        }
        return HeartVisualStyle.NORMAL;
    }

    private float resolveScale() {
        String raw = this.scaleMultiplier;
        if (raw == null || raw.isBlank()) {
            return 1.0f;
        }
        String replaced = PlaceholderParser.replacePlaceholders((String)raw).trim();
        if (MathUtils.isFloat((String)replaced)) {
            try {
                float parsed = Float.parseFloat(replaced);
                if (!Float.isFinite(parsed)) {
                    return 1.0f;
                }
                return class_3532.method_15363((float)parsed, (float)0.2f, (float)70.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0f;
    }

    private HeartTextureKind textureFromFill(float fillValue, @NotNull HeartVisualStyle style) {
        if (fillValue >= 2.0f) {
            return style.fullTexture;
        }
        if (fillValue > 0.0f) {
            return style.halfTexture;
        }
        return HeartTextureKind.EMPTY;
    }

    private void registerBlinkSlots(float previousHealth, float currentHealth, int baseHeartSlots, long now) {
        for (int slot = 0; slot < baseHeartSlots; ++slot) {
            float newFill;
            float prevFill = this.fillForSlot(previousHealth, slot);
            if (!(prevFill > (newFill = this.fillForSlot(currentHealth, slot)) + 0.01f) || !(prevFill > 0.0f)) continue;
            this.activeBlinkSlots.put(slot, new BlinkState(prevFill, now + 650L));
        }
    }

    private float fillForSlot(float value, int slot) {
        float heartLowerBound = (float)slot * 2.0f;
        return class_3532.method_15363((float)(value - heartLowerBound), (float)0.0f, (float)2.0f);
    }

    private void cleanupExpiredBlinks(long now) {
        Iterator<Map.Entry<Integer, BlinkState>> iterator = this.activeBlinkSlots.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BlinkState> entry = iterator.next();
            if (now < entry.getValue().endTimeMs) continue;
            iterator.remove();
        }
    }

    private SlotPlacement computeSlotPlacement(int logicalIndex, RenderMetrics metrics) {
        int heartsInRow;
        int perRow = metrics.heartsPerRow;
        int rawRow = logicalIndex / perRow;
        int row = this.isTopAligned() ? rawRow : metrics.rows - 1 - rawRow;
        int topRowRawIndex = (metrics.totalSlots - 1) / perRow;
        int n = heartsInRow = rawRow == topRowRawIndex ? metrics.totalSlots - rawRow * perRow : perRow;
        if (heartsInRow <= 0) {
            heartsInRow = perRow;
        }
        int alignmentOffset = 0;
        if (rawRow == topRowRawIndex && this.isCenterAligned()) {
            alignmentOffset = (perRow - heartsInRow) / 2;
        }
        int rawColumn = logicalIndex % perRow;
        int column = this.isRightAligned() ? perRow - 1 - rawColumn : rawColumn;
        column = Math.max(0, column + alignmentOffset);
        return new SlotPlacement(column, Math.max(0, row));
    }

    private boolean isTopAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_LEFT, SpiffyAlignment.TOP_CENTERED, SpiffyAlignment.TOP_RIGHT -> true;
            default -> false;
        };
    }

    private boolean isCenterAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_CENTERED, SpiffyAlignment.MID_CENTERED, SpiffyAlignment.BOTTOM_CENTERED -> true;
            default -> false;
        };
    }

    private boolean isRightAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_RIGHT, SpiffyAlignment.MID_RIGHT, SpiffyAlignment.BOTTOM_RIGHT -> true;
            default -> false;
        };
    }

    public void setCustomTexture(@NotNull HeartTextureKind kind, @Nullable ResourceSupplier<ITexture> supplier) {
        if (supplier == null) {
            this.customTextures.remove((Object)kind);
        } else {
            this.customTextures.put(kind, supplier);
        }
    }

    @Nullable
    public ResourceSupplier<ITexture> getCustomTexture(@NotNull HeartTextureKind kind) {
        return this.customTextures.get((Object)kind);
    }

    @NotNull
    public Map<HeartTextureKind, ResourceSupplier<ITexture>> getCustomTextureMap() {
        return Collections.unmodifiableMap(this.customTextures);
    }

    private HeartVisualStyle pickEditorPreviewStyle() {
        long bucket = System.currentTimeMillis() / 10000L;
        int index = (int)(bucket % (long)EDITOR_PREVIEW_STYLES.length);
        return EDITOR_PREVIEW_STYLES[Math.max(0, index)];
    }

    public static enum HeartTextureKind {
        EMPTY("empty", -2145378272),
        HALF("half", -29813),
        FULL("full", -45233),
        ABSORPTION_HALF("absorption_half", -3674),
        ABSORPTION_FULL("absorption_full", -10929),
        WITHER_HALF("wither_half", -9474193),
        WITHER_FULL("wither_full", -12237499),
        POISON_HALF("poison_half", -7540611),
        POISON_FULL("poison_full", -11551419),
        FROZEN_HALF("frozen_half", -6363137),
        FROZEN_FULL("frozen_full", -10893569),
        BURNING_HALF("burning_half", -18572),
        BURNING_FULL("burning_full", -34304);

        private final String translationKeySuffix;
        private final int defaultColor;

        private HeartTextureKind(String translationKeySuffix, int defaultColor) {
            this.translationKeySuffix = translationKeySuffix;
            this.defaultColor = defaultColor;
        }

        public String getTranslationKey() {
            return "spiffyhud.elements.player_heart_health_bar.texture." + this.translationKeySuffix;
        }
    }

    private static class PlayerData {
        final float currentHealth;
        final float maxHealth;
        final float absorption;
        final HeartVisualStyle visualStyle;
        final int baseHeartSlots;
        final int absorptionSlots;

        PlayerData(float currentHealth, float maxHealth, float absorption, HeartVisualStyle style) {
            this.currentHealth = Math.max(0.0f, currentHealth);
            this.maxHealth = Math.max(2.0f, maxHealth);
            this.absorption = Math.max(0.0f, absorption);
            this.visualStyle = style;
            this.baseHeartSlots = Math.max(1, class_3532.method_15386((float)(this.maxHealth / 2.0f)));
            this.absorptionSlots = Math.max(0, class_3532.method_15386((float)(this.absorption / 2.0f)));
        }
    }

    private record RenderMetrics(int heartsPerRow, int baseHeartSize, int totalSlots, int bodyWidth, int bodyHeight, int rows, int horizontalGap, int verticalGap) {
    }

    private record SlotPlacement(int column, int row) {
    }

    private record BlinkState(float previousFill, long endTimeMs) {
    }

    private static enum HeartVisualStyle {
        NORMAL(HeartTextureKind.HALF, HeartTextureKind.FULL),
        WITHER(HeartTextureKind.WITHER_HALF, HeartTextureKind.WITHER_FULL),
        POISON(HeartTextureKind.POISON_HALF, HeartTextureKind.POISON_FULL),
        FROZEN(HeartTextureKind.FROZEN_HALF, HeartTextureKind.FROZEN_FULL),
        BURNING(HeartTextureKind.BURNING_HALF, HeartTextureKind.BURNING_FULL);

        private final HeartTextureKind halfTexture;
        private final HeartTextureKind fullTexture;

        private HeartVisualStyle(HeartTextureKind halfTexture, HeartTextureKind fullTexture) {
            this.halfTexture = halfTexture;
            this.fullTexture = fullTexture;
        }
    }
}

