/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.bossbars;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_345;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeBossOverlayElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960[] BAR_BACKGROUND_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/pink_background"), class_2960.method_60656((String)"boss_bar/blue_background"), class_2960.method_60656((String)"boss_bar/red_background"), class_2960.method_60656((String)"boss_bar/green_background"), class_2960.method_60656((String)"boss_bar/yellow_background"), class_2960.method_60656((String)"boss_bar/purple_background"), class_2960.method_60656((String)"boss_bar/white_background")};
    private static final class_2960[] BAR_PROGRESS_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/pink_progress"), class_2960.method_60656((String)"boss_bar/blue_progress"), class_2960.method_60656((String)"boss_bar/red_progress"), class_2960.method_60656((String)"boss_bar/green_progress"), class_2960.method_60656((String)"boss_bar/yellow_progress"), class_2960.method_60656((String)"boss_bar/purple_progress"), class_2960.method_60656((String)"boss_bar/white_progress")};
    private static final class_2960[] OVERLAY_BACKGROUND_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/notched_6_background"), class_2960.method_60656((String)"boss_bar/notched_10_background"), class_2960.method_60656((String)"boss_bar/notched_12_background"), class_2960.method_60656((String)"boss_bar/notched_20_background")};
    private static final class_2960[] OVERLAY_PROGRESS_SPRITES = new class_2960[]{class_2960.method_60656((String)"boss_bar/notched_6_progress"), class_2960.method_60656((String)"boss_bar/notched_10_progress"), class_2960.method_60656((String)"boss_bar/notched_12_progress"), class_2960.method_60656((String)"boss_bar/notched_20_progress")};
    private static final List<class_345> DUMMY_EVENTS = List.of(new class_345(UUID.randomUUID(), (class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, class_1259.class_1260.field_5783, class_1259.class_1261.field_5795, false, false, false), new class_345(UUID.randomUUID(), (class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, class_1259.class_1260.field_5783, class_1259.class_1261.field_5795, false, false, false), new class_345(UUID.randomUUID(), (class_2561)class_2561.method_43471((String)"spiffyhud.elements.dummy.boss_bars.bar"), 0.5f, class_1259.class_1260.field_5783, class_1259.class_1261.field_5795, false, false, false));
    private final class_310 minecraft = class_310.method_1551();
    private int barWidth = 182;
    private int barHeight = 0;
    private int barOriginalX = 0;
    private int barOriginalY = 0;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikeBossOverlayElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.field_1724 == null || this.minecraft.field_1687 == null) {
            return;
        }
        this.updateBodySizeAndPosCache();
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, elementWidth, elementHeight, this.barWidth, this.barHeight);
        int offsetX = alignedPosition[0] - this.barOriginalX;
        int offsetY = alignedPosition[1] - this.barOriginalY;
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((class_332)graphics);
        List<class_345> eventsToRender = VanillaLikeBossOverlayElement.isEditor() ? DUMMY_EVENTS : class_310.method_1551().field_1705.method_1740().field_2060.values();
        this.renderBossBars(graphics, offsetX, offsetY, eventsToRender);
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    private void updateBodySizeAndPosCache() {
        List<class_345> eventsToRecord;
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setHeightOffset(5);
        int defaultBarWidth = 182;
        Collection<Object> collection = eventsToRecord = VanillaLikeBossOverlayElement.isEditor() ? DUMMY_EVENTS : class_310.method_1551().field_1705.method_1740().field_2060.values();
        if (!eventsToRecord.iterator().hasNext() && !VanillaLikeBossOverlayElement.isEditor()) {
            return;
        }
        int currentY = 12;
        for (class_345 bossEvent : eventsToRecord) {
            int barPosX = 0;
            int barPosY = currentY;
            recorder.updateX(barPosX);
            recorder.updateY(barPosY);
            class_2561 eventName = bossEvent.method_5414();
            int textWidth = this.minecraft.field_1772.method_27525((class_5348)eventName);
            int textPosX = (defaultBarWidth - textWidth) / 2;
            int textPosY = barPosY - 9;
            recorder.updateX(textPosX);
            recorder.updateY(textPosY);
            Objects.requireNonNull(this.minecraft.field_1772);
            currentY += 10 + 9;
        }
        this.barOriginalX = recorder.getX();
        this.barOriginalY = recorder.getY();
        this.barWidth = Math.max(defaultBarWidth, recorder.getWidth());
        this.barHeight = recorder.getHeight();
    }

    private void renderBossBars(class_332 graphics, int offsetX, int offsetY, Iterable<class_345> bossEvents) {
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
        int currentY = offsetY + 12;
        for (class_345 bossEvent : bossEvents) {
            int barPosX = offsetX;
            int barPosY = currentY;
            RenderSystem.enableBlend();
            graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
            this.drawBar(graphics, barPosX, barPosY, (class_1259)bossEvent);
            class_2561 eventName = bossEvent.method_5414();
            int textWidth = this.minecraft.field_1772.method_27525((class_5348)eventName);
            int textPosX = offsetX + (this.getAbsoluteWidth() - textWidth) / 2;
            int textPosY = barPosY - 9;
            RenderSystem.enableBlend();
            graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
            graphics.method_27535(this.minecraft.field_1772, eventName, textPosX, textPosY, 0xFFFFFF);
            Objects.requireNonNull(this.minecraft.field_1772);
            currentY += 10 + 9;
        }
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void drawBar(class_332 graphics, int barX, int barY, class_1259 bossEvent) {
        this.drawBar(graphics, barX, barY, bossEvent, 182, BAR_BACKGROUND_SPRITES, OVERLAY_BACKGROUND_SPRITES);
        int filledWidth = class_3532.method_53063((float)bossEvent.method_5412(), (int)0, (int)182);
        if (filledWidth > 0) {
            this.drawBar(graphics, barX, barY, bossEvent, filledWidth, BAR_PROGRESS_SPRITES, OVERLAY_PROGRESS_SPRITES);
        }
    }

    private void drawBar(class_332 graphics, int barX, int barY, class_1259 bossEvent, int progress, class_2960[] barSprites, class_2960[] overlaySprites) {
        RenderSystem.enableBlend();
        graphics.method_52708(barSprites[bossEvent.method_5420().ordinal()], 182, 5, 0, 0, barX, barY, progress, 5);
        if (bossEvent.method_5415() != class_1259.class_1261.field_5795) {
            graphics.method_52708(overlaySprites[bossEvent.method_5415().ordinal() - 1], 182, 5, 0, 0, barX, barY, progress, 5);
        }
        RenderSystem.disableBlend();
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }
}

