/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.food;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5819;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerFoodElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 FOOD_EMPTY_SPRITE = class_2960.method_60656((String)"hud/food_empty");
    private static final class_2960 FOOD_HALF_SPRITE = class_2960.method_60656((String)"hud/food_half");
    private static final class_2960 FOOD_FULL_SPRITE = class_2960.method_60656((String)"hud/food_full");
    private static final class_2960 FOOD_EMPTY_HUNGER_SPRITE = class_2960.method_60656((String)"hud/food_empty_hunger");
    private static final class_2960 FOOD_HALF_HUNGER_SPRITE = class_2960.method_60656((String)"hud/food_half_hunger");
    private static final class_2960 FOOD_FULL_HUNGER_SPRITE = class_2960.method_60656((String)"hud/food_full_hunger");
    private static final int BAR_WIDTH = 81;
    private static final int BAR_HEIGHT = 9;
    private final class_310 minecraft = class_310.method_1551();
    protected final class_5819 random = class_5819.method_43047();
    protected int tickCount;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerFoodElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.field_1724 == null || this.minecraft.field_1687 == null) {
            return;
        }
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, this.getAbsoluteWidth(), this.getAbsoluteHeight(), 81, 9);
        int barPosX = alignedPosition[0];
        int barPosY = alignedPosition[1];
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((class_332)graphics);
        this.renderFoodBar(graphics, barPosX, barPosY);
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    private void renderFoodBar(class_332 graphics, int baseX, int baseY) {
        class_2960 fullSprite;
        class_2960 halfSprite;
        class_2960 emptySprite;
        class_1657 player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
        class_1702 foodData = player.method_7344();
        int foodLevel = foodData.method_7586();
        if (VanillaLikePlayerFoodElement.isEditor()) {
            foodLevel = 9;
        }
        int numIcons = 10;
        int ICON_WIDTH = 9;
        int ICON_HEIGHT = 9;
        int ICON_SPACING = 8;
        boolean mirrorIcons = this.shouldRenderIconsLeftToRight();
        if (player.method_6059(class_1294.field_5903)) {
            emptySprite = FOOD_EMPTY_HUNGER_SPRITE;
            halfSprite = FOOD_HALF_HUNGER_SPRITE;
            fullSprite = FOOD_FULL_HUNGER_SPRITE;
        } else {
            emptySprite = FOOD_EMPTY_SPRITE;
            halfSprite = FOOD_HALF_SPRITE;
            fullSprite = FOOD_FULL_SPRITE;
        }
        for (int i = 0; i < 10; ++i) {
            int iconX = mirrorIcons ? baseX + i * 8 : baseX + (9 - i) * 8;
            int iconY = baseY;
            if (foodData.method_7589() <= 0.0f && this.tickCount % (foodLevel * 3 + 1) == 0) {
                iconY += this.random.method_43048(3) - 1;
            }
            if (mirrorIcons) {
                SpiffyRenderUtils.blitSpriteMirrored(graphics, emptySprite, iconX, iconY, 9, 9);
                if (i * 2 + 1 < foodLevel) {
                    SpiffyRenderUtils.blitSpriteMirrored(graphics, fullSprite, iconX, iconY, 9, 9);
                    continue;
                }
                if (i * 2 + 1 != foodLevel) continue;
                SpiffyRenderUtils.blitSpriteMirrored(graphics, halfSprite, iconX, iconY, 9, 9);
                continue;
            }
            graphics.method_52706(emptySprite, iconX, iconY, 9, 9);
            if (i * 2 + 1 < foodLevel) {
                graphics.method_52706(fullSprite, iconX, iconY, 9, 9);
                continue;
            }
            if (i * 2 + 1 != foodLevel) continue;
            graphics.method_52706(halfSprite, iconX, iconY, 9, 9);
        }
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private boolean shouldRenderIconsLeftToRight() {
        return this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED;
    }

    @Nullable
    private class_1657 getCameraPlayer() {
        class_1657 p;
        class_1297 class_12972 = class_310.method_1551().method_1560();
        return class_12972 instanceof class_1657 ? (p = (class_1657)class_12972) : null;
    }

    public int getAbsoluteWidth() {
        return 81;
    }

    public int getAbsoluteHeight() {
        return 9;
    }
}

