/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.playerhealth;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerHealthElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 HEART_CONTAINER_SPRITE = class_2960.method_60656((String)"hud/heart/container");
    private static final class_2960 HEART_CONTAINER_BLINKING_SPRITE = class_2960.method_60656((String)"hud/heart/container_blinking");
    private static final class_2960 HEART_CONTAINER_HARDCORE_SPRITE = class_2960.method_60656((String)"hud/heart/container_hardcore");
    private static final class_2960 HEART_CONTAINER_HARDCORE_BLINKING_SPRITE = class_2960.method_60656((String)"hud/heart/container_hardcore_blinking");
    private final class_310 minecraft = class_310.method_1551();
    protected final class_5819 random = class_5819.method_43047();
    protected int lastHealth;
    protected int displayHealth;
    protected long lastHealthTime;
    protected long healthBlinkTime;
    protected int tickCount;
    private int barWidth = 100;
    private int barHeight = 100;
    private boolean shouldRenderBar = false;
    public boolean isUsedAsDummy = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerHealthElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.field_1724 == null) {
            return;
        }
        if (this.minecraft.field_1687 == null) {
            return;
        }
        this.shouldRenderBar = false;
        this.renderPlayerHealthInternal(graphics, 0, 0);
        int elementAbsX = this.getAbsoluteX();
        int elementAbsY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementAbsX, elementAbsY, elementWidth, elementHeight, this.barWidth, this.barHeight);
        int alignedBarX = alignedPosition[0];
        int alignedBarY = alignedPosition[1];
        RenderSystem.enableBlend();
        this.shouldRenderBar = true;
        this.renderPlayerHealthInternal(graphics, alignedBarX, alignedBarY);
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    private void renderPlayerHealthInternal(class_332 graphics, int originX, int originY) {
        class_1657 player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
        int currentHealthCeil = class_3532.method_15386((float)player.method_6032());
        boolean heartBlink = this.healthBlinkTime > (long)this.tickCount && (this.healthBlinkTime - (long)this.tickCount) / 3L % 2L == 1L;
        long currentTime = class_156.method_658();
        if (currentHealthCeil < this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = this.tickCount + 20;
        } else if (currentHealthCeil > this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = this.tickCount + 10;
        }
        if (currentTime - this.lastHealthTime > 1000L) {
            this.displayHealth = currentHealthCeil;
            this.lastHealthTime = currentTime;
        }
        this.lastHealth = currentHealthCeil;
        class_1702 foodData = player.method_7344();
        int baseX = originX;
        int baseY = originY;
        float maxHealth = Math.max((float)player.method_45325(class_5134.field_23716), (float)Math.max(this.displayHealth, currentHealthCeil));
        int absorptionHalfHearts = class_3532.method_15386((float)player.method_6067());
        int totalHealthHearts = class_3532.method_15386((float)(maxHealth / 2.0f));
        int totalHearts = totalHealthHearts + VanillaLikePlayerHealthElement.toFullHearts(absorptionHalfHearts);
        int displayedHealth = this.displayHealth;
        if (VanillaLikePlayerHealthElement.isEditor()) {
            maxHealth = 40.0f;
            currentHealthCeil = 9;
            displayedHealth = 9;
            absorptionHalfHearts = 5;
            totalHealthHearts = class_3532.method_15386((float)(maxHealth / 2.0f));
            totalHearts = totalHealthHearts + VanillaLikePlayerHealthElement.toFullHearts(absorptionHalfHearts);
        }
        if (this.isUsedAsDummy) {
            maxHealth = 20.0f;
            currentHealthCeil = 9;
            displayedHealth = 9;
            absorptionHalfHearts = 0;
            totalHealthHearts = class_3532.method_15386((float)(maxHealth / 2.0f));
            totalHearts = totalHealthHearts + VanillaLikePlayerHealthElement.toFullHearts(absorptionHalfHearts);
        }
        int fullRowSlots = 10;
        int numRows = (totalHearts + 10 - 1) / 10;
        int rowSpacing = Math.max(10 - (numRows - 2), 3);
        int regenHeartIndex = -1;
        if (player.method_6059(class_1294.field_5924)) {
            regenHeartIndex = this.tickCount % class_3532.method_15386((float)(maxHealth + 5.0f));
        }
        class_329.class_6411 baseHeartType = class_329.class_6411.method_37301((class_1657)player);
        boolean isHardcore = player.method_37908().method_8401().method_152();
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setWidthOffset(9);
        recorder.setHeightOffset(9);
        for (int m = totalHearts - 1; m >= 0; --m) {
            boolean isLastHeart;
            int absorptionIndex;
            int rawRow = m / 10;
            int row = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT ? rawRow : numRows - 1 - rawRow;
            int heartsInRow = rawRow == (totalHearts - 1) / 10 ? totalHearts - rawRow * 10 : 10;
            int alignmentOffset = 0;
            if (rawRow == (totalHearts - 1) / 10 && (this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED)) {
                alignmentOffset = (10 - heartsInRow) / 2;
            }
            int col = this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT ? 9 - m % 10 : m % 10;
            int effectiveCol = col + alignmentOffset;
            int heartX = baseX + effectiveCol * 8;
            int heartY = baseY + row * rowSpacing;
            if (currentHealthCeil + absorptionHalfHearts <= 4) {
                heartY += this.random.method_43048(2);
            }
            if (m < totalHealthHearts && m == regenHeartIndex) {
                heartY -= 2;
            }
            recorder.updateX(heartX);
            recorder.updateY(heartY);
            if (this.shouldRenderBar) {
                this.renderEmptyHeart(graphics, heartX, heartY, heartBlink, isHardcore);
            }
            int heartValue = m * 2;
            if (m >= totalHealthHearts && (absorptionIndex = heartValue - totalHealthHearts * 2) < absorptionHalfHearts) {
                boolean isLastAbsorption;
                boolean bl = isLastAbsorption = absorptionIndex + 1 == absorptionHalfHearts;
                if (this.shouldRenderBar) {
                    this.renderHeart(graphics, baseHeartType == class_329.class_6411.field_33947 ? baseHeartType : class_329.class_6411.field_33948, heartX, heartY, false, isHardcore, isLastAbsorption);
                }
            }
            if (heartBlink && heartValue < displayedHealth) {
                boolean isLastHighlight;
                boolean bl = isLastHighlight = heartValue + 1 == displayedHealth;
                if (this.shouldRenderBar) {
                    this.renderHeart(graphics, baseHeartType, heartX, heartY, true, isHardcore, isLastHighlight);
                }
            }
            if (heartValue >= currentHealthCeil) continue;
            boolean bl = isLastHeart = heartValue + 1 == currentHealthCeil;
            if (!this.shouldRenderBar) continue;
            this.renderHeart(graphics, baseHeartType, heartX, heartY, false, isHardcore, isLastHeart);
        }
        if (!this.shouldRenderBar && recorder.isUpdated()) {
            this.barWidth = recorder.getWidth();
            this.barHeight = recorder.getHeight();
        } else if (!this.shouldRenderBar) {
            this.barWidth = 1;
            this.barHeight = 9;
        }
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderEmptyHeart(class_332 graphics, int x, int y, boolean blinking, boolean hardcore) {
        class_2960 spriteLocation;
        if (hardcore) {
            spriteLocation = blinking ? HEART_CONTAINER_HARDCORE_BLINKING_SPRITE : HEART_CONTAINER_HARDCORE_SPRITE;
        } else {
            class_2960 class_29602 = spriteLocation = blinking ? HEART_CONTAINER_BLINKING_SPRITE : HEART_CONTAINER_SPRITE;
        }
        if (this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
            SpiffyRenderUtils.blitSpriteMirrored(graphics, spriteLocation, x, y, 9, 9);
        } else {
            graphics.method_52706(spriteLocation, x, y, 9, 9);
        }
    }

    private void renderHeart(class_332 graphics, class_329.class_6411 heartType, int x, int y, boolean blinking, boolean hardcore, boolean halfHeart) {
        class_2960 spriteLocation = heartType.method_52705(hardcore, halfHeart, blinking);
        if (this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
            SpiffyRenderUtils.blitSpriteMirrored(graphics, spriteLocation, x, y, 9, 9);
        } else {
            graphics.method_52706(spriteLocation, x, y, 9, 9);
        }
    }

    private static int toFullHearts(int halfHearts) {
        return (halfHearts + 1) / 2;
    }

    @Nullable
    private class_1657 getCameraPlayer() {
        class_1657 p;
        class_1297 class_12972 = class_310.method_1551().method_1560();
        return class_12972 instanceof class_1657 ? (p = (class_1657)class_12972) : null;
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }
}

