/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.scoreboard;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Comparator;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_274;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8646;
import net.minecraft.class_9011;
import net.minecraft.class_9022;
import net.minecraft.class_9025;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeScoreboardElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SPACER = ": ";
    private static final Comparator<class_9011> SCORE_DISPLAY_ORDER = Comparator.comparing(class_9011::comp_2128).reversed().thenComparing(class_9011::comp_2127, String.CASE_INSENSITIVE_ORDER);
    private final class_310 minecraft = class_310.method_1551();
    private int sidebarWidth = 100;
    private int sidebarHeight = 100;
    private int sidebarOriginalX = 0;
    private int sidebarOriginalY = 0;
    private boolean renderSidebar = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;
    @Nullable
    public DrawableColor customTitleBackgroundColor = null;
    @Nullable
    public DrawableColor customLineBackgroundColor = null;

    public VanillaLikeScoreboardElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.field_1724 == null || this.minecraft.field_1687 == null) {
            return;
        }
        this.renderSidebar = false;
        this.renderScoreboard(graphics, 0, 0, false);
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.sidebarWidth, this.sidebarHeight);
        int offsetX = alignedPosition[0] - this.sidebarOriginalX;
        int offsetY = alignedPosition[1] - this.sidebarOriginalY;
        RenderSystem.enableBlend();
        this.renderSidebar = true;
        this.renderScoreboard(graphics, offsetX, offsetY, true);
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    private void renderScoreboard(class_332 graphics, int offsetX, int offsetY, boolean applyOffset) {
        class_266 objectiveToRender;
        class_8646 displaySlot;
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
        class_269 scoreboard = this.minecraft.field_1687.method_8428();
        class_266 objective = null;
        class_268 playerTeam = scoreboard.method_1164(this.minecraft.field_1724.method_5820());
        if (playerTeam != null && (displaySlot = class_8646.method_52622((class_124)playerTeam.method_1202())) != null) {
            objective = scoreboard.method_1189(displaySlot);
        }
        class_266 class_2662 = objectiveToRender = objective != null ? objective : scoreboard.method_1189(class_8646.field_45157);
        if (VanillaLikeScoreboardElement.isEditor()) {
            objectiveToRender = new DummyObjective(scoreboard);
        }
        if (objectiveToRender != null) {
            this.displayScoreboardSidebar(graphics, objectiveToRender, offsetX, offsetY, applyOffset);
        }
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void displayScoreboardSidebar(class_332 guiGraphics, class_266 objective, int offsetX, int offsetY, boolean applyOffset) {
        int titleWidth;
        DisplayEntry[] displayEntries;
        class_269 scoreboard = objective.method_1117();
        class_2561 title = objective.method_1114();
        if (VanillaLikeScoreboardElement.isEditor()) {
            title = class_2561.method_43471((String)"spiffyhud.elements.dummy.scoreboard_sidebar.title").method_27692(class_124.field_1067);
            String dummyLineText = class_1074.method_4662((String)"spiffyhud.elements.dummy.scoreboard_sidebar.line", (Object[])new Object[0]);
            displayEntries = new DisplayEntry[6];
            for (int i = 0; i < 6; ++i) {
                class_5250 name = class_2561.method_43470((String)dummyLineText);
                DisplayEntry[] score = class_2561.method_43470((String)("" + i));
                displayEntries[i] = new DisplayEntry((class_2561)name, (class_2561)score, this.getFont().method_27525((class_5348)score));
            }
        } else {
            displayEntries = (DisplayEntry[])scoreboard.method_1184(objective).stream().filter(entry -> !entry.method_55385()).sorted(SCORE_DISPLAY_ORDER).limit(15L).map(entry -> {
                class_268 team = scoreboard.method_1164(entry.comp_2127());
                class_2561 name = entry.method_55387();
                class_5250 formattedName = class_268.method_1142((class_270)team, (class_2561)name);
                class_5250 scoreText = entry.method_55386(objective.method_55380((class_9022)class_9025.field_47567));
                int scoreWidth = this.getFont().method_27525((class_5348)scoreText);
                return new DisplayEntry((class_2561)formattedName, (class_2561)scoreText, scoreWidth);
            }).toArray(DisplayEntry[]::new);
        }
        int maxEntryWidth = titleWidth = this.getFont().method_27525((class_5348)title);
        int spacerWidth = this.getFont().method_1727(SPACER);
        for (DisplayEntry entry2 : displayEntries) {
            int entryWidth = this.getFont().method_27525((class_5348)entry2.name) + (entry2.scoreWidth > 0 ? spacerWidth + entry2.scoreWidth : 0);
            maxEntryWidth = Math.max(maxEntryWidth, entryWidth);
        }
        int numberOfLines = displayEntries.length;
        int lineHeight = 9;
        int totalLineHeight = numberOfLines * lineHeight;
        int baseY = VanillaLikeScoreboardElement.getScreenHeight() / 2 + totalLineHeight / 3;
        int baseX = VanillaLikeScoreboardElement.getScreenWidth() - maxEntryWidth - 3;
        int lineBackgroundColor = this.minecraft.field_1690.method_19345(0.3f);
        if (this.customLineBackgroundColor != null) {
            lineBackgroundColor = this.customLineBackgroundColor.getColorInt();
        }
        int titleBackgroundColor = this.minecraft.field_1690.method_19345(0.4f);
        if (this.customTitleBackgroundColor != null) {
            titleBackgroundColor = this.customTitleBackgroundColor.getColorInt();
        }
        int topY = baseY - numberOfLines * lineHeight;
        this.sidebarWidth = Math.max(1, maxEntryWidth + 4);
        this.sidebarHeight = Math.max(1, baseY - (topY - lineHeight - 1));
        this.sidebarOriginalX = baseX - 2;
        this.sidebarOriginalY = topY - lineHeight - 1;
        int effectiveBaseX = baseX + (applyOffset ? offsetX : 0);
        int effectiveBaseY = baseY + (applyOffset ? offsetY : 0);
        if (this.renderSidebar) {
            guiGraphics.method_51448().method_22903();
            int finalLineBackgroundColor = lineBackgroundColor;
            int finalTitleBackgroundColor = titleBackgroundColor;
            int finalMaxEntryWidth = maxEntryWidth;
            class_2561 finalTitle = title;
            guiGraphics.method_51741(() -> {
                int rightX = VanillaLikeScoreboardElement.getScreenWidth() - 3 + 2 + (applyOffset ? offsetX : 0);
                for (int i = 0; i < displayEntries.length; ++i) {
                    DisplayEntry entry = displayEntries[i];
                    int lineY = effectiveBaseY - (i + 1) * lineHeight;
                    guiGraphics.method_25294(effectiveBaseX - 2, lineY, rightX, lineY + lineHeight, finalLineBackgroundColor);
                    guiGraphics.method_51439(this.getFont(), entry.name, effectiveBaseX, lineY, -1, false);
                    guiGraphics.method_51439(this.getFont(), entry.score, rightX - entry.scoreWidth, lineY, -1, false);
                    if (i != displayEntries.length - 1) continue;
                    guiGraphics.method_25294(effectiveBaseX - 2, lineY - lineHeight - 1, rightX, lineY - 1, finalTitleBackgroundColor);
                    guiGraphics.method_25294(effectiveBaseX - 2, lineY - 1, rightX, lineY, finalLineBackgroundColor);
                    class_327 font = this.getFont();
                    int titleX = effectiveBaseX + finalMaxEntryWidth / 2 - titleWidth / 2;
                    guiGraphics.method_51439(font, finalTitle, titleX, lineY - lineHeight, -1, false);
                }
            });
            guiGraphics.method_51448().method_22909();
        }
    }

    private class_327 getFont() {
        return class_310.method_1551().field_1772;
    }

    public int getAbsoluteWidth() {
        return this.sidebarWidth;
    }

    public int getAbsoluteHeight() {
        return this.sidebarHeight;
    }

    private static class DummyObjective
    extends class_266 {
        public DummyObjective(class_269 scoreboard) {
            super(scoreboard, "dummy", class_274.field_1468, (class_2561)class_2561.method_43470((String)"Scoreboard"), class_274.class_275.field_1472, false, null);
        }
    }

    private record DisplayEntry(class_2561 name, class_2561 score, int scoreWidth) {
    }
}

