/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.networking.Packet;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import de.keksuccino.spiffyhud.networking.packets.structure.playerpos.PlayerPosStructuresPacket;
import de.keksuccino.spiffyhud.networking.packets.structure.structures.StructuresPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IsPlayerInStructureRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static long lastStructureUpdate = -1L;

    public IsPlayerInStructureRequirement() {
        super("spiffy_is_player_in_structure");
    }

    public boolean hasValue() {
        return true;
    }

    public boolean isRequirementMet(@Nullable String value) {
        if (value != null) {
            try {
                long now = System.currentTimeMillis();
                if (lastStructureUpdate + 1000L < now) {
                    PacketHandler.sendToServer((Packet)new PlayerPosStructuresPacket());
                    lastStructureUpdate = now;
                }
                return PlayerPosStructuresPacket.CACHED_CURRENT_STRUCTURES.contains(value);
            }
            catch (Exception ex) {
                LOGGER.error("[SPIFFY HUD] Failed to check for 'Is Player In Structure' requirement!", (Throwable)ex);
            }
        }
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"spiffyhud.requirements.is_player_in_structure", (Object[])new Object[0]);
    }

    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines((String)"spiffyhud.requirements.is_player_in_structure.desc", (String[])new String[0]));
    }

    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.requirements.categories.world", (Object[])new Object[0]);
    }

    public String getValueDisplayName() {
        return "";
    }

    public String getValuePreset() {
        return "minecraft:village";
    }

    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    public void editValue(@NotNull class_437 parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsPlayerInStructureValueConfigScreen s = new IsPlayerInStructureValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, this.getValuePreset()), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)s);
    }

    public static class IsPlayerInStructureValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String oldStructureKey;
        protected CellScreen.TextInputCell structureKeyCell;
        protected EditBoxSuggestions structureKeySuggestions;

        protected IsPlayerInStructureValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((class_2561)class_2561.method_43471((String)"fancymenu.editor.elements.visibilityrequirements.edit_value"), callback);
            this.oldStructureKey = value;
        }

        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getStructureKeyString();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"spiffyhud.requirements.is_player_in_structure.key"));
            this.structureKeyCell = this.addTextInputCell(null, true, true).setText(id);
            this.addCellGroupEndSpacerCell();
            this.structureKeySuggestions = EditBoxSuggestions.createWithCustomSuggestions((class_437)this, (class_342)this.structureKeyCell.editBox, (EditBoxSuggestions.SuggestionsRenderPosition)EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, new ArrayList<String>(StructuresPacket.CACHED_SERVER_STRUCTURE_KEYS));
            UIBase.applyDefaultWidgetSkinTo((Object)this.structureKeySuggestions);
            this.structureKeyCell.editBox.method_1863(s -> this.structureKeySuggestions.method_23934());
            this.addSpacerCell(20);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {
            super.method_25394(graphics, mouseX, mouseY, partial);
            this.structureKeySuggestions.method_23923(graphics, mouseX, mouseY);
        }

        public boolean method_25404(int $$0, int $$1, int $$2) {
            if (this.structureKeySuggestions.method_23924($$0, $$1, $$2)) {
                return true;
            }
            return super.method_25404($$0, $$1, $$2);
        }

        public boolean method_25401(double $$0, double $$1, double $$2, double d) {
            if (this.structureKeySuggestions.method_23921(d)) {
                return true;
            }
            return super.method_25401($$0, $$1, $$2, d);
        }

        public boolean method_25402(double $$0, double $$1, int $$2) {
            if (this.structureKeySuggestions.method_23922($$0, $$1, $$2)) {
                return true;
            }
            return super.method_25402($$0, $$1, $$2);
        }

        @NotNull
        public String buildString() {
            return this.getStructureKeyString();
        }

        @NotNull
        protected String getStructureKeyString() {
            if (this.structureKeyCell != null) {
                return this.structureKeyCell.getText();
            }
            return this.oldStructureKey;
        }
    }
}

