/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.networking.packets.markercommand.command;

import de.keksuccino.spiffyhud.customization.actions.marker.MarkerActionConfig;
import de.keksuccino.spiffyhud.customization.actions.marker.MarkerRemovalConfig;
import de.keksuccino.spiffyhud.customization.marker.MarkerStorage;
import de.keksuccino.spiffyhud.networking.packets.markercommand.MarkerCommandEditField;
import de.keksuccino.spiffyhud.networking.packets.markercommand.MarkerCommandOperation;
import de.keksuccino.spiffyhud.networking.packets.markercommand.command.MarkerCommandPacket;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkerCommandPacketLogic {
    private static final Logger LOGGER = LogManager.getLogger();

    protected static boolean handle(@NotNull MarkerCommandPacket packet) {
        if (packet.operation == null) {
            LOGGER.error("[SPIFFYHUD] Received marker command packet without operation.");
            return false;
        }
        return switch (packet.operation) {
            default -> throw new MatchException(null, null);
            case MarkerCommandOperation.ADD -> MarkerCommandPacketLogic.handleAdd(packet);
            case MarkerCommandOperation.EDIT -> MarkerCommandPacketLogic.handleEdit(packet);
            case MarkerCommandOperation.REMOVE -> MarkerCommandPacketLogic.handleRemove(packet);
            case MarkerCommandOperation.CLEAR_GROUP -> MarkerCommandPacketLogic.handleClearGroup(packet);
        };
    }

    private static boolean handleAdd(@NotNull MarkerCommandPacket packet) {
        MarkerActionConfig config = packet.actionConfig;
        if (config == null) {
            LOGGER.error("[SPIFFYHUD] Marker add command missing config.");
            return false;
        }
        config.normalize();
        if (!config.hasValidTarget() || !config.hasValidMarkerName()) {
            LOGGER.error("[SPIFFYHUD] Marker add command missing required fields.");
            return false;
        }
        boolean success = MarkerStorage.addMarker(config.targetElementIdentifier, config.toMarkerData());
        if (success) {
            MarkerCommandPacketLogic.sendClientFeedback(packet, class_2561.method_43469((String)"spiffyhud.commands.marker.client.add.success", (Object[])new Object[]{config.uniqueMarkerName, config.targetElementIdentifier}), false);
        } else {
            MarkerCommandPacketLogic.sendClientFeedback(packet, class_2561.method_43469((String)"spiffyhud.commands.marker.client.add.failure", (Object[])new Object[]{config.uniqueMarkerName, config.targetElementIdentifier}), true);
        }
        return success;
    }

    private static boolean handleEdit(@NotNull MarkerCommandPacket packet) {
        MarkerActionConfig config = packet.actionConfig;
        if (config == null) {
            LOGGER.error("[SPIFFYHUD] Marker edit command missing config.");
            return false;
        }
        config.normalize();
        String markerName = config.getMarkerName();
        if (!config.hasValidTarget() || markerName.isBlank() || !config.hasValidMarkerName()) {
            LOGGER.error("[SPIFFYHUD] Marker edit command missing required field: target or marker name invalid");
            return false;
        }
        EnumSet<MarkerCommandEditField> overrides = MarkerCommandPacketLogic.sanitizeEditFields(packet.editFields);
        boolean success = MarkerStorage.editMarker(config.targetElementIdentifier, markerName, marker -> {
            marker.setName(config.uniqueMarkerName);
            marker.setMarkerPosX(config.positionX);
            marker.setMarkerPosZ(config.positionZ);
            if (MarkerCommandPacketLogic.shouldUpdate(overrides, MarkerCommandEditField.COLOR)) {
                marker.setColor(config.colorHex);
            }
            if (MarkerCommandPacketLogic.shouldUpdate(overrides, MarkerCommandEditField.DOT_TEXTURE)) {
                marker.setDotTexture(config.dotTexture);
            }
            if (MarkerCommandPacketLogic.shouldUpdate(overrides, MarkerCommandEditField.NEEDLE_TEXTURE)) {
                marker.setNeedleTexture(config.needleTexture);
            }
            if (MarkerCommandPacketLogic.shouldUpdate(overrides, MarkerCommandEditField.SHOW_AS_NEEDLE)) {
                marker.setShowAsNeedle(config.showAsNeedle);
            }
        });
        if (success) {
            MarkerCommandPacketLogic.sendClientFeedback(packet, class_2561.method_43469((String)"spiffyhud.commands.marker.client.edit.success", (Object[])new Object[]{markerName, config.targetElementIdentifier}), false);
        } else {
            MarkerCommandPacketLogic.sendClientFeedback(packet, class_2561.method_43469((String)"spiffyhud.commands.marker.client.edit.failure", (Object[])new Object[]{markerName, config.targetElementIdentifier}), true);
        }
        return success;
    }

    private static boolean handleRemove(@NotNull MarkerCommandPacket packet) {
        MarkerRemovalConfig config = packet.removalConfig;
        if (config == null) {
            LOGGER.error("[SPIFFYHUD] Marker remove command missing config.");
            return false;
        }
        config.normalize();
        if (!config.isValid()) {
            LOGGER.error("[SPIFFYHUD] Marker remove command invalid config.");
            return false;
        }
        boolean success = MarkerStorage.removeMarker(config.targetElementIdentifier, config.uniqueMarkerName);
        if (success) {
            MarkerCommandPacketLogic.sendClientFeedback(packet, class_2561.method_43469((String)"spiffyhud.commands.marker.client.remove.success", (Object[])new Object[]{config.uniqueMarkerName, config.targetElementIdentifier}), false);
        } else {
            MarkerCommandPacketLogic.sendClientFeedback(packet, class_2561.method_43469((String)"spiffyhud.commands.marker.client.remove.failure", (Object[])new Object[]{config.uniqueMarkerName, config.targetElementIdentifier}), true);
        }
        return success;
    }

    private static boolean handleClearGroup(@NotNull MarkerCommandPacket packet) {
        MarkerRemovalConfig config = packet.removalConfig;
        if (config == null) {
            LOGGER.error("[SPIFFYHUD] Marker clear command missing config.");
            return false;
        }
        config.normalize();
        if (!config.hasValidTarget()) {
            LOGGER.error("[SPIFFYHUD] Marker clear command missing target element identifier.");
            return false;
        }
        boolean success = MarkerStorage.clearGroup(config.targetElementIdentifier);
        if (success) {
            MarkerCommandPacketLogic.sendClientFeedback(packet, class_2561.method_43469((String)"spiffyhud.commands.marker.client.clear.success", (Object[])new Object[]{config.targetElementIdentifier}), false);
        } else {
            MarkerCommandPacketLogic.sendClientFeedback(packet, class_2561.method_43469((String)"spiffyhud.commands.marker.client.clear.failure", (Object[])new Object[]{config.targetElementIdentifier}), true);
        }
        return success;
    }

    private static EnumSet<MarkerCommandEditField> sanitizeEditFields(@Nullable Set<MarkerCommandEditField> fields) {
        if (fields == null || fields.isEmpty()) {
            return EnumSet.noneOf(MarkerCommandEditField.class);
        }
        return EnumSet.copyOf(fields);
    }

    private static boolean shouldUpdate(@NotNull EnumSet<MarkerCommandEditField> fields, @NotNull MarkerCommandEditField field) {
        return fields.contains((Object)field);
    }

    private static void sendClientFeedback(@NotNull MarkerCommandPacket packet, class_5250 message, boolean failure) {
        if (!packet.silenceClientFeedback) {
            packet.sendChatFeedback(message, failure);
        }
    }
}

