/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util;

public class SizeAndPositionRecorder {
    protected int startX = -10000000;
    protected int startY = -10000000;
    protected int endX = -10000000;
    protected int endY = -10000000;
    protected int widthModifier = 0;
    protected int heightModifier = 0;
    protected int xModifier = 0;
    protected int yModifier = 0;
    protected boolean updatedX = false;
    protected boolean updatedY = false;

    public void updateX(int x) {
        this.updateStartX(x);
        this.updateEndX(x);
        this.updatedX = true;
    }

    protected void updateStartX(int x) {
        if (this.startX == -10000000) {
            this.startX = x;
        } else if (x < this.startX) {
            this.startX = x;
        }
    }

    protected void updateEndX(int x) {
        if (this.endX == -10000000) {
            this.endX = x;
        } else if (x > this.endX) {
            this.endX = x;
        }
    }

    public void updateY(int y) {
        this.updateStartY(y);
        this.updateEndY(y);
        this.updatedY = true;
    }

    protected void updateStartY(int y) {
        if (this.startY == -10000000) {
            this.startY = y;
        } else if (y < this.startY) {
            this.startY = y;
        }
    }

    protected void updateEndY(int y) {
        if (this.endY == -10000000) {
            this.endY = y;
        } else if (y > this.endY) {
            this.endY = y;
        }
    }

    public boolean isUpdated() {
        return this.updatedX && this.updatedY;
    }

    public int getX() {
        if (!this.isUpdated()) {
            return 0;
        }
        return Math.min(this.startX, this.endX) + this.xModifier;
    }

    public int getY() {
        if (!this.isUpdated()) {
            return 0;
        }
        return Math.min(this.startY, this.endY) + this.yModifier;
    }

    public int getWidth() {
        if (!this.isUpdated()) {
            return 0;
        }
        return Math.max(this.startX, this.endX) - Math.min(this.startX, this.endX) + this.widthModifier;
    }

    public int getHeight() {
        if (!this.isUpdated()) {
            return 0;
        }
        return Math.max(this.startY, this.endY) - Math.min(this.startY, this.endY) + this.heightModifier;
    }

    public int setWidthOffset(int offset) {
        this.widthModifier = offset;
        return this.getWidth();
    }

    public int setHeightOffset(int offset) {
        this.heightModifier = offset;
        return this.getHeight();
    }

    public int setXOffset(int offset) {
        this.xModifier = offset;
        return this.getX();
    }

    public int setYOffset(int offset) {
        this.yModifier = offset;
        return this.getY();
    }
}

