package de.keksuccino.spiffyhud.customization.elements.vanillalike.playerhealth;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerHealthElement extends AbstractElement {

    private static final Logger LOGGER = LogManager.getLogger();

    // Vanilla heart sheet used in 1.20.1
    private static final class_2960 GUI_ICONS_LOCATION = new class_2960("textures/gui/icons.png");

    private final class_310 minecraft = class_310.method_1551();
    protected final class_5819 random = class_5819.method_43047();
    protected int lastHealth;
    protected int displayHealth;
    protected long lastHealthTime;
    protected long healthBlinkTime;
    protected int tickCount;

    // Recorded dimensions and position for the hearts bar.
    private int barWidth = 100;
    private int barHeight = 100;

    // When true, the hearts are drawn; when false, only the bar bounds are recorded.
    private boolean shouldRenderBar = false;
    public boolean isUsedAsDummy = false;

    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerHealthElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    /**
     * Renders the hearts bar directly using the element's absolute position and size.
     * This method performs two passes:
     * 1. A recording pass (with shouldRenderBar==false) using a local origin (0,0)
     *    so that the bar's dimensions are captured.
     * 2. An actual drawing pass (with shouldRenderBar==true) at the computed aligned
     *    absolute coordinates (using getAbsoluteX/Y/Width/Height).
     */
    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        // Update tick counter for animations.
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();

        if (this.minecraft.field_1724 == null) return;
        if (this.minecraft.field_1687 == null) return;

        // === First Pass: Record Bar Dimensions ===
        this.shouldRenderBar = false;
        this.renderPlayerHealthInternal(graphics, 0, 0);

        // === Compute the Aligned Absolute Position for the Bar ===
        int elementAbsX = this.getAbsoluteX();
        int elementAbsY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementAbsX, elementAbsY, elementWidth, elementHeight, this.barWidth, this.barHeight);
        int alignedBarX = alignedPosition[0];
        int alignedBarY = alignedPosition[1];

        RenderSystem.enableBlend();

        // === Second Pass: Draw the Hearts Bar at the Computed Absolute Position ===
        this.shouldRenderBar = true;
        this.renderPlayerHealthInternal(graphics, alignedBarX, alignedBarY);

        RenderingUtils.resetShaderColor(graphics);

    }

    /**
     * Renders (or records) the player's hearts bar.
     * @param graphics The graphics context.
     * @param originX  The absolute x-coordinate where the hearts bar should be drawn.
     * @param originY  The absolute y-coordinate where the hearts bar should be drawn.
     *
     * When shouldRenderBar is false, this method only records the bar's bounds.
     */
    private void renderPlayerHealthInternal(GuiGraphics graphics, int originX, int originY) {

        class_1657 player = this.getCameraPlayer();
        if (player == null) {
            return;
        }

        // Enable blending and set the shader color with the desired opacity.
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);

        // Compute current health (rounded up) and determine blink status.
        int currentHealthCeil = class_3532.method_15386(player.method_6032());
        boolean heartBlink = (this.healthBlinkTime > (long)this.tickCount) &&
                (((this.healthBlinkTime - (long)this.tickCount) / 3L) % 2L == 1L);
        long currentTime = class_156.method_658();

        if (currentHealthCeil < this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = this.tickCount + 20;
        } else if (currentHealthCeil > this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = this.tickCount + 10;
        }
        if (currentTime - this.lastHealthTime > 1000L) {
            this.displayHealth = currentHealthCeil;
            this.lastHealthTime = currentTime;
        }
        this.lastHealth = currentHealthCeil;

        // Food data is retrieved for compatibility.
        class_1702 foodData = player.method_7344();

        // Base drawing origin.
        int baseX = originX;
        int baseY = originY;

        // Compute max health and absorption values.
        float maxHealth = Math.max((float) player.method_26825(class_5134.field_23716),
                (float) Math.max(this.displayHealth, currentHealthCeil));
        int absorptionHalfHearts = class_3532.method_15386(player.method_6067());
        int totalHealthHearts = class_3532.method_15386(maxHealth / 2.0f);
        int totalHearts = totalHealthHearts + toFullHearts(absorptionHalfHearts);
        int displayedHealth = this.displayHealth;

        // --- Editor Preview Override ---
        if (isEditor()) {
            maxHealth = 40;
            currentHealthCeil = 9;
            displayedHealth = 9;
            absorptionHalfHearts = 5;
            totalHealthHearts = class_3532.method_15386(maxHealth / 2.0f);
            totalHearts = totalHealthHearts + toFullHearts(absorptionHalfHearts);
        }
        if (this.isUsedAsDummy) {
            maxHealth = 20;
            currentHealthCeil = 9;
            displayedHealth = 9;
            absorptionHalfHearts = 0;
            totalHealthHearts = class_3532.method_15386(maxHealth / 2.0f);
            totalHearts = totalHealthHearts + toFullHearts(absorptionHalfHearts);
        }

        // Determine number of slots per row (max 10) and total number of rows.
        final int fullRowSlots = 10;
        int numRows = (totalHearts + fullRowSlots - 1) / fullRowSlots;
        // Compute row spacing (mimicking vanilla spacing).
        int rowSpacing = Math.max(10 - (numRows - 2), 3);

        // Determine regeneration effect offset.
        int regenHeartIndex = -1;
        if (player.method_6059(class_1294.field_5924)) {
            regenHeartIndex = this.tickCount % class_3532.method_15386(maxHealth + 5.0f);
        }

        // Determine heart type.
        class_329.class_6411 baseHeartType = class_329.class_6411.method_37301(player);
        boolean isHardcore = player.field_6002.method_8401().method_152();

        // Recorder to capture the bounds of the hearts bar.
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setWidthOffset(9);
        recorder.setHeightOffset(9);

        /*
         * Loop over heart slots.
         * We use a single index m from 0 to totalHearts-1.
         * We derive a raw row as (m / fullRowSlots). By default we flip rows so that row 0 is at the top.
         * However, for top-based alignments we reverse the row order so that extra rows (absorption or empty hearts)
         * are rendered last.
         */
        for (int m = totalHearts - 1; m >= 0; m--) {
            int rawRow = m / fullRowSlots;
            int row;
            if (this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT) {
                row = rawRow;
            } else {
                row = numRows - 1 - rawRow;
            }
            // For the incomplete (top) row, determine how many hearts are in that row.
            int heartsInRow = (rawRow == (totalHearts - 1) / fullRowSlots) ?
                    totalHearts - rawRow * fullRowSlots : fullRowSlots;
            // Compute alignment offset for centered alignment only (left and right alignments need no offset)
            int alignmentOffset = 0;
            if (rawRow == (totalHearts - 1) / fullRowSlots) {
                if (this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED) {
                    alignmentOffset = (fullRowSlots - heartsInRow) / 2;
                }
            }
            int col;
            // For right-based orientations, reverse the column index so hearts render from the right.
            if (this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
                col = fullRowSlots - 1 - (m % fullRowSlots);
            } else {
                col = m % fullRowSlots;
            }
            int effectiveCol = col + alignmentOffset;
            int heartX = baseX + effectiveCol * 8;
            int heartY = baseY + row * rowSpacing;

            // Add slight random offset for very low health.
            if (currentHealthCeil + absorptionHalfHearts <= 4) {
                heartY += this.random.method_43048(2);
            }
            // Adjust for regeneration effect.
            if (m < totalHealthHearts && m == regenHeartIndex) {
                heartY -= 2;
            }

            // Record heart position.
            recorder.updateX(heartX);
            recorder.updateY(heartY);

            // Render the container (empty heart) for every slot.
            if (this.shouldRenderBar) {
                renderEmptyHeart(graphics, heartX, heartY, heartBlink, isHardcore);
            }

            int heartValue = m * 2; // Each heart slot represents 2 health points.

            // Render absorption hearts (should be drawn in the top row).
            if (m >= totalHealthHearts) {
                int absorptionIndex = heartValue - totalHealthHearts * 2;
                if (absorptionIndex < absorptionHalfHearts) {
                    boolean isLastAbsorption = (absorptionIndex + 1 == absorptionHalfHearts);
                    if (this.shouldRenderBar) {
                        renderHeart(graphics,
                                baseHeartType == class_329.class_6411.field_33947 ? baseHeartType : class_329.class_6411.field_33948,
                                heartX, heartY, false, isHardcore, isLastAbsorption);
                    }
                }
            }
            // Render highlighted heart if blink effect is active.
            if (heartBlink && heartValue < displayedHealth) {
                boolean isLastHighlight = (heartValue + 1 == displayedHealth);
                if (this.shouldRenderBar) {
                    renderHeart(graphics, baseHeartType, heartX, heartY, true, isHardcore, isLastHighlight);
                }
            }
            // Render normal (filled) heart if player's health covers this slot.
            if (heartValue < currentHealthCeil) {
                boolean isLastHeart = (heartValue + 1 == currentHealthCeil);
                if (this.shouldRenderBar) {
                    renderHeart(graphics, baseHeartType, heartX, heartY, false, isHardcore, isLastHeart);
                }
            }
        }

        // When in recording mode, update the stored bar bounds.
        if (!this.shouldRenderBar && recorder.isUpdated()) {
            this.barWidth = recorder.getWidth();
            this.barHeight = recorder.getHeight();
        } else if (!this.shouldRenderBar) {
            this.barWidth = 1;
            this.barHeight = 9;
        }

        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    /**
     * Renders a heart container (empty heart)
     */
    private void renderEmptyHeart(GuiGraphics graphics, int x, int y, boolean blinking, boolean hardcore) {
        int textureYOffset = hardcore ? 45 : 0;
        int textureX = class_329.class_6411.field_33944.method_37302(false, blinking);

        if (this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
            SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, x, y, 0, textureX, textureYOffset, 9, 9, 256, 256);
        } else {
            graphics.blit(GUI_ICONS_LOCATION, x, y, textureX, textureYOffset, 9, 9);
        }
    }

    /**
     * Renders a single heart icon.
     *
     * @param graphics    The graphics context.
     * @param heartType   The type of heart icon to render.
     * @param x           The x-coordinate of the heart.
     * @param y           The y-coordinate of the heart.
     * @param blinking    Whether the heart should be blinking.
     * @param hardcore    Whether to use hardcore sprites.
     * @param halfHeart   Whether to render a half heart.
     */
    private void renderHeart(GuiGraphics graphics, class_329.class_6411 heartType, int x, int y, boolean blinking, boolean hardcore, boolean halfHeart) {
        int textureYOffset = hardcore ? 45 : 0;
        int textureX = heartType.method_37302(halfHeart, blinking);

        if (this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
            SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, x, y, 0, textureX, textureYOffset, 9, 9, 256, 256);
        } else {
            graphics.blit(GUI_ICONS_LOCATION, x, y, textureX, textureYOffset, 9, 9);
        }
    }

    private static int toFullHearts(int halfHearts) {
        return (halfHearts + 1) / 2;
    }

    @Nullable
    private class_1657 getCameraPlayer() {
        return (class_310.method_1551().method_1560() instanceof class_1657 p) ? p : null;
    }

    @Override
    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    @Override
    public int getAbsoluteHeight() {
        return this.barHeight;
    }

}
