package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_757;

public class SpiffyRenderUtils {

    private static boolean blendLocked = false;

    public static void lockBlend(boolean lock) {
        blendLocked = true;
    }

    public static boolean isBlendLocked() {
        return blendLocked;
    }

    /**
     * Draws a textured quad with the U texture coordinates swapped so that the image appears mirrored horizontally.
     *
     * @param graphics       The graphics context.
     * @param atlasLocation  The texture atlas.
     * @param x              The screen X coordinate.
     * @param y              The screen Y coordinate.
     * @param blitOffset     The z-level (blit offset).
     * @param u              The source U coordinate (left edge) of the texture.
     * @param v              The source V coordinate (top edge) of the texture.
     * @param width          The width of the quad.
     * @param height         The height of the quad.
     * @param textureWidth   The width of the texture.
     * @param textureHeight  The height of the texture.
     */
    public static void blitMirrored(GuiGraphics graphics, class_2960 atlasLocation, int x, int y, int blitOffset, int u, int v, int width, int height, int textureWidth, int textureHeight) {

        RenderSystem.setShaderTexture(0, atlasLocation);
        RenderSystem.setShader(class_757::method_34542);

        RenderSystem.enableBlend();

        // Calculate texture coordinates.
        float minU = (u + width) / (float) textureWidth;
        float maxU = u / (float) textureWidth;
        float minV = v / (float) textureHeight;
        float maxV = (v + height) / (float) textureHeight;

        class_1159 matrix = graphics.pose().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, (float)x, (float)y, (float)blitOffset).method_22913(minU, minV).method_1344();
        bufferBuilder.method_22918(matrix, (float)x, (float)(y + height), (float)blitOffset).method_22913(minU, maxV).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)(y + height), (float)blitOffset).method_22913(maxU, maxV).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)y, (float)blitOffset).method_22913(maxU, minV).method_1344();
        class_286.method_43433(bufferBuilder.method_1326());

        RenderSystem.disableBlend();

    }

}
