/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.actions.marker;

import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.ILocalizedValueCycle;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.spiffyhud.customization.actions.marker.MarkerActionConfig;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class MarkerEditorScreen
extends CellScreen {
    private final MarkerActionConfig config;
    private final Consumer<String> callback;
    private CellScreen.TextInputCell dotTextureCell;
    private CellScreen.TextInputCell needleTextureCell;

    public MarkerEditorScreen(@NotNull class_2561 title, @NotNull MarkerActionConfig config, @NotNull Consumer<String> callback) {
        super(title);
        this.config = Objects.requireNonNull(config);
        this.callback = Objects.requireNonNull(callback);
    }

    protected void initCells() {
        this.addStartEndSpacerCell();
        this.addLabelCell((class_2561)class_2561.method_43471((String)"spiffyhud.actions.marker.target_element"));
        CellScreen.TextInputCell targetElementCell = this.addTextInputCell(null, false, true).setEditListener(s -> {
            this.config.targetElementIdentifier = s.trim();
        }).setText(this.config.targetElementIdentifier);
        targetElementCell.editBox.setTooltip(() -> Tooltip.of((class_2561[])LocalizationUtils.splitLocalizedLines((String)"spiffyhud.actions.marker.target_element.desc", (String[])new String[0])));
        this.addCellGroupEndSpacerCell();
        this.addLabelCell((class_2561)class_2561.method_43471((String)"spiffyhud.actions.marker.display_name"));
        CellScreen.TextInputCell displayNameCell = this.addTextInputCell(null, false, true).setEditListener(s -> {
            this.config.uniqueMarkerName = s.trim();
        }).setText(this.config.uniqueMarkerName);
        displayNameCell.editBox.setTooltip(() -> Tooltip.of((class_2561[])LocalizationUtils.splitLocalizedLines((String)"spiffyhud.actions.marker.display_name.desc", (String[])new String[0])));
        this.addCellGroupEndSpacerCell();
        this.addLabelCell((class_2561)class_2561.method_43471((String)"spiffyhud.actions.marker.color"));
        CellScreen.TextInputCell colorCell = this.addTextInputCell(null, true, true).setEditListener(s -> {
            this.config.colorHex = s.trim();
        }).setText(this.config.colorHex);
        colorCell.editBox.setTooltip(() -> Tooltip.of((class_2561[])LocalizationUtils.splitLocalizedLines((String)"spiffyhud.actions.marker.color.desc", (String[])new String[0])));
        this.addCellGroupEndSpacerCell();
        this.addTextureRow(TextureField.DOT);
        this.addTextureRow(TextureField.NEEDLE);
        this.addLabelCell((class_2561)class_2561.method_43471((String)"spiffyhud.actions.marker.show_as_needle"));
        CycleButton showNeedleButton = new CycleButton(0, 0, 80, 20, (ILocalizedValueCycle)CommonCycles.cycleEnabledDisabled((String)"spiffyhud.actions.marker.show_as_needle.cycle", (boolean)this.config.showAsNeedle), (value, button) -> {
            this.config.showAsNeedle = value.getAsBoolean();
        });
        showNeedleButton.setTooltip(Tooltip.of((class_2561[])LocalizationUtils.splitLocalizedLines((String)"spiffyhud.actions.marker.show_as_needle.desc", (String[])new String[0])));
        this.addWidgetCell((class_339)showNeedleButton, true);
        this.addCellGroupEndSpacerCell();
        this.addLabelCell((class_2561)class_2561.method_43471((String)"spiffyhud.actions.marker.position_x"));
        CellScreen.TextInputCell positionXCell = this.addTextInputCell(null, true, true).setEditListener(s -> {
            this.config.positionX = s.trim();
        }).setText(this.config.positionX);
        positionXCell.editBox.setTooltip(() -> Tooltip.of((class_2561[])LocalizationUtils.splitLocalizedLines((String)"spiffyhud.actions.marker.position_x.desc", (String[])new String[0])));
        this.addCellGroupEndSpacerCell();
        this.addLabelCell((class_2561)class_2561.method_43471((String)"spiffyhud.actions.marker.position_z"));
        CellScreen.TextInputCell positionZCell = this.addTextInputCell(null, true, true).setEditListener(s -> {
            this.config.positionZ = s.trim();
        }).setText(this.config.positionZ);
        positionZCell.editBox.setTooltip(() -> Tooltip.of((class_2561[])LocalizationUtils.splitLocalizedLines((String)"spiffyhud.actions.marker.position_z.desc", (String[])new String[0])));
        this.addStartEndSpacerCell();
    }

    protected void onCancel() {
        this.callback.accept(null);
    }

    protected void onDone() {
        this.config.uniqueMarkerName = PlaceholderParser.replacePlaceholders((String)this.config.uniqueMarkerName);
        this.config.normalize();
        this.callback.accept(this.config.serialize());
    }

    public boolean allowDone() {
        return this.config.hasValidTarget() && this.config.hasValidMarkerName();
    }

    private void addTextureRow(@NotNull TextureField field) {
        boolean needle = field == TextureField.NEEDLE;
        String baseKey = needle ? "spiffyhud.actions.marker.needle_texture" : "spiffyhud.actions.marker.dot_texture";
        this.addLabelCell((class_2561)class_2561.method_43471((String)baseKey));
        CellScreen.TextInputCell cell = this.addTextInputCell(null, true, true);
        if (needle) {
            this.needleTextureCell = cell;
            cell.setEditListener(s -> {
                this.config.needleTexture = s.trim();
            });
            cell.setText(this.config.needleTexture == null ? "" : this.config.needleTexture);
        } else {
            this.dotTextureCell = cell;
            cell.setEditListener(s -> {
                this.config.dotTexture = s.trim();
            });
            cell.setText(this.config.dotTexture == null ? "" : this.config.dotTexture);
        }
        cell.editBox.setTooltip(() -> Tooltip.of((class_2561[])LocalizationUtils.splitLocalizedLines((String)(baseKey + ".desc"), (String[])new String[0])));
        ExtendedButton pickButton = new ExtendedButton(0, 0, 20, 20, (class_2561)class_2561.method_43471((String)(baseKey + ".pick")), button -> this.openTexturePicker(field));
        pickButton.setTooltip(Tooltip.of((class_2561[])LocalizationUtils.splitLocalizedLines((String)(baseKey + ".pick.desc"), (String[])new String[0])));
        this.addWidgetCell((class_339)pickButton, true);
        ExtendedButton clearButton = new ExtendedButton(0, 0, 20, 20, (class_2561)class_2561.method_43471((String)(baseKey + ".clear")), button -> this.clearTexture(field));
        clearButton.setTooltip(Tooltip.of((class_2561[])LocalizationUtils.splitLocalizedLines((String)(baseKey + ".clear.desc"), (String[])new String[0])));
        this.addWidgetCell((class_339)clearButton, true);
        this.addCellGroupEndSpacerCell();
    }

    private void clearTexture(@NotNull TextureField field) {
        if (field == TextureField.NEEDLE) {
            this.config.needleTexture = "";
            if (this.needleTextureCell != null) {
                this.needleTextureCell.setText("");
            }
        } else {
            this.config.dotTexture = "";
            if (this.dotTextureCell != null) {
                this.dotTextureCell.setText("");
            }
        }
    }

    private void openTexturePicker(@NotNull TextureField field) {
        String stored = field == TextureField.NEEDLE ? this.config.needleTexture : this.config.dotTexture;
        String source = stored == null ? "" : stored;
        ResourceChooserScreen chooser = ResourceChooserScreen.image(null, selection -> {
            if (selection != null) {
                if (field == TextureField.NEEDLE) {
                    this.config.needleTexture = selection;
                    if (this.needleTextureCell != null) {
                        this.needleTextureCell.setText(selection);
                    }
                } else {
                    this.config.dotTexture = selection;
                    if (this.dotTextureCell != null) {
                        this.dotTextureCell.setText(selection);
                    }
                }
            }
            class_310.method_1551().method_1507((class_437)this);
        });
        chooser.setSource(source.isBlank() ? null : source, false);
        class_310.method_1551().method_1507((class_437)chooser);
    }

    private static enum TextureField {
        DOT,
        NEEDLE;

    }
}

