/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.playerairbar;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerAirBubbleBarElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_SCALE_STRING = "1.0";
    private static final float DEFAULT_SCALE = 1.0f;
    private static final float MIN_SCALE = 0.2f;
    private static final float MAX_SCALE = 70.0f;
    private static final int BASE_BUBBLE_PIXEL_SIZE = 8;
    private static final int BASE_SLOT_COUNT = 10;
    public static final int DEFAULT_POPPING_DURATION_MS = 217;
    private final class_310 minecraft = class_310.method_1551();
    private final class_5819 shakeRandom = class_5819.method_43047();
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;
    public int bubblesPerRow = 10;
    public int bubbleGap = 1;
    @NotNull
    public String scaleMultiplier = "1.0";
    public boolean blinkOnLoss = true;
    public boolean lowAirShakeEnabled = true;
    public int lowAirShakeThresholdBubbles = 4;
    public int poppingDurationMs = 217;
    private final EnumMap<AirTextureKind, ResourceSupplier<ITexture>> customTextures = new EnumMap(AirTextureKind.class);
    private float lastRecordedAirAmount = -1.0f;
    private int lastRecordedMaxAir = -1;
    private int cachedTickCount = 0;
    private final Map<Integer, BlinkState> activeBlinkSlots = new HashMap<Integer, BlinkState>();

    public PlayerAirBubbleBarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.stickyAnchor = true;
        this.stayOnScreen = false;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.cachedTickCount = this.safeTickCount();
        PlayerData data = this.collectPlayerData();
        float scale = this.resolveScale();
        RenderMetrics metrics = this.computeMetrics(scale);
        this.baseWidth = Math.max(1, metrics.bodyWidth);
        this.baseHeight = Math.max(1, metrics.bodyHeight);
        this.updateBlinkState(data);
        if (!this.shouldRender()) {
            return;
        }
        Integer[] aligned = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), metrics.bodyWidth, metrics.bodyHeight);
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        this.drawBubbles(graphics, aligned[0], aligned[1], data, metrics, scale);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void drawBubbles(@NotNull GuiGraphics graphics, int originX, int originY, @NotNull PlayerData data, @NotNull RenderMetrics metrics, float scale) {
        class_4587 pose = graphics.pose();
        pose.method_22903();
        pose.method_22904((double)originX, (double)originY, 0.0);
        long now = System.currentTimeMillis();
        boolean shake = this.shouldShake(data);
        float shakeStrengthBase = shake ? 0.9f : 0.0f;
        int totalSlots = metrics.totalSlots;
        for (int logicalIndex = totalSlots - 1; logicalIndex >= 0; --logicalIndex) {
            SlotPlacement placement = this.computeSlotPlacement(logicalIndex, metrics);
            AirTextureKind textureKind = this.resolveTextureKind(logicalIndex, data, now);
            float appliedShake = shakeStrengthBase > 0.0f && textureKind != AirTextureKind.EMPTY ? shakeStrengthBase : 0.0f;
            this.renderSingleBubble(graphics, metrics, placement, logicalIndex, textureKind, appliedShake, scale);
        }
        pose.method_22909();
    }

    private AirTextureKind resolveTextureKind(int logicalIndex, @NotNull PlayerData data, long now) {
        BlinkState blink = this.activeBlinkSlots.get(logicalIndex);
        if (blink != null) {
            if (now < blink.endTimeMs) {
                return AirTextureKind.POPPING;
            }
            this.activeBlinkSlots.remove(logicalIndex);
        }
        int fullCutoff = data.fullBubbles;
        int poppingCutoff = data.fullBubbles + data.poppingBubbles;
        if (logicalIndex < fullCutoff) {
            return AirTextureKind.FULL;
        }
        if (logicalIndex < poppingCutoff) {
            return AirTextureKind.POPPING;
        }
        return AirTextureKind.EMPTY;
    }

    private void renderSingleBubble(@NotNull GuiGraphics graphics, @NotNull RenderMetrics metrics, @NotNull SlotPlacement placement, int logicalIndex, @NotNull AirTextureKind textureKind, float shakeStrengthBase, float scale) {
        float gap = this.bubbleGap;
        float baseSpacingX = ((float)metrics.baseBubbleSize + gap) * scale;
        float baseSpacingY = ((float)metrics.baseBubbleSize + gap) * scale;
        float baseX = (float)placement.column * baseSpacingX;
        float baseY = (float)placement.row * baseSpacingY;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (shakeStrengthBase > 0.0f && textureKind != AirTextureKind.EMPTY) {
            float[] offsets = this.computeShakeOffset(logicalIndex, shakeStrengthBase);
            offsetX = offsets[0];
            offsetY = offsets[1];
        }
        class_4587 pose = graphics.pose();
        pose.method_22903();
        pose.method_22904((double)(baseX + offsetX), (double)(baseY + offsetY), 0.0);
        pose.method_22905(scale, scale, 1.0f);
        this.drawBubbleTexture(graphics, textureKind, metrics.baseBubbleSize);
        pose.method_22909();
    }

    private float[] computeShakeOffset(int logicalIndex, float shakeStrengthBase) {
        this.shakeRandom.method_43052((long)this.cachedTickCount * 341873128712L + (long)logicalIndex * 132897987541L);
        float dx = (this.shakeRandom.method_43057() - 0.5f) * shakeStrengthBase;
        float dy = (this.shakeRandom.method_43057() - 0.5f) * shakeStrengthBase;
        return new float[]{dx, dy};
    }

    private void drawBubbleTexture(@NotNull GuiGraphics graphics, @NotNull AirTextureKind kind, int size) {
        ResourceSupplier<ITexture> supplier = this.customTextures.get((Object)kind);
        if (supplier != null) {
            try {
                ITexture texture = (ITexture)supplier.get();
                if (texture != null && texture.isReady() && texture.getResourceLocation() != null) {
                    RenderSystem.enableBlend();
                    graphics.blit(texture.getResourceLocation(), 0, 0, 0.0f, 0.0f, size, size, size, size);
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.error("[SpiffyHUD] Failed to draw air bubble texture {}", (Object)kind.name(), (Object)ex);
            }
        }
        graphics.fill(0, 0, size, size, this.applyOpacity(kind.defaultColor));
    }

    private int applyOpacity(int argb) {
        int alpha = argb >>> 24 & 0xFF;
        int rgb = argb & 0xFFFFFF;
        int adjustedAlpha = (int)Math.max(0.0f, Math.min(255.0f, (float)alpha * this.opacity));
        return adjustedAlpha << 24 | rgb;
    }

    private RenderMetrics computeMetrics(float scale) {
        int totalSlots = 10;
        int perRow = Math.max(1, this.bubblesPerRow);
        int rowSize = Math.min(perRow, totalSlots);
        int rows = Math.max(1, (int)Math.ceil((double)totalSlots / (double)perRow));
        int gap = Math.max(0, this.bubbleGap);
        float scaledWidth = (float)(rowSize * 8) * scale + (float)(Math.max(0, rowSize - 1) * gap) * scale;
        float scaledHeight = (float)(rows * 8) * scale + (float)(Math.max(0, rows - 1) * gap) * scale;
        int bodyWidth = Math.max(1, class_3532.method_15386((float)scaledWidth));
        int bodyHeight = Math.max(1, class_3532.method_15386((float)scaledHeight));
        return new RenderMetrics(perRow, 8, totalSlots, bodyWidth, bodyHeight, rows, gap, gap);
    }

    private void updateBlinkState(@NotNull PlayerData data) {
        long now = System.currentTimeMillis();
        this.cleanupExpiredBlinks(now);
        float currentAir = data.currentAir;
        int currentMaxAir = data.maxAir;
        if (!this.blinkOnLoss || this.poppingDurationMs <= 0) {
            this.activeBlinkSlots.clear();
            this.lastRecordedAirAmount = currentAir;
            this.lastRecordedMaxAir = currentMaxAir;
            return;
        }
        if (this.lastRecordedAirAmount < 0.0f) {
            this.lastRecordedAirAmount = currentAir;
            this.lastRecordedMaxAir = currentMaxAir;
            return;
        }
        if (currentAir < this.lastRecordedAirAmount - 0.01f) {
            int previousMax = this.lastRecordedMaxAir > 0 ? this.lastRecordedMaxAir : currentMaxAir;
            this.registerBlinkSlots(this.lastRecordedAirAmount, previousMax, currentAir, currentMaxAir, now);
        } else if (currentAir > this.lastRecordedAirAmount + 0.01f) {
            this.activeBlinkSlots.clear();
        }
        this.lastRecordedAirAmount = currentAir;
        this.lastRecordedMaxAir = currentMaxAir;
    }

    private boolean shouldShake(@NotNull PlayerData data) {
        if (!this.lowAirShakeEnabled) {
            return false;
        }
        if (this.lowAirShakeThresholdBubbles <= 0) {
            return false;
        }
        if (data.airPerSlot <= 0.0f) {
            return false;
        }
        float threshold = (float)this.lowAirShakeThresholdBubbles * data.airPerSlot;
        return data.currentAir <= threshold;
    }

    private int safeTickCount() {
        try {
            return SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private PlayerData collectPlayerData() {
        if (PlayerAirBubbleBarElement.isEditor()) {
            int fakeMaxAir = 300;
            int fakeCurrentAir = (int)((float)fakeMaxAir * 0.7f);
            return new PlayerData(fakeCurrentAir, fakeMaxAir);
        }
        class_746 player = this.minecraft.field_1724;
        if (player == null) {
            int defaultMax = 300;
            return new PlayerData(defaultMax, defaultMax);
        }
        int maxAir = Math.max(1, player.method_5748());
        int currentAir = class_3532.method_15340((int)player.method_5669(), (int)0, (int)maxAir);
        return new PlayerData(currentAir, maxAir);
    }

    private float resolveScale() {
        String raw = this.scaleMultiplier;
        if (raw == null || raw.isBlank()) {
            return 1.0f;
        }
        String replaced = PlaceholderParser.replacePlaceholders((String)raw).trim();
        if (MathUtils.isFloat((String)replaced)) {
            try {
                float parsed = Float.parseFloat(replaced);
                if (!Float.isFinite(parsed)) {
                    return 1.0f;
                }
                return class_3532.method_15363((float)parsed, (float)0.2f, (float)70.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0f;
    }

    private void registerBlinkSlots(float previousAir, int previousMaxAir, float currentAir, int currentMaxAir, long now) {
        int duration = Math.max(0, this.poppingDurationMs);
        if (duration <= 0) {
            return;
        }
        BubbleCounts previousCounts = PlayerAirBubbleBarElement.calculateBubbleCounts(previousAir, previousMaxAir);
        BubbleCounts currentCounts = PlayerAirBubbleBarElement.calculateBubbleCounts(currentAir, currentMaxAir);
        for (int slot = 0; slot < 10; ++slot) {
            boolean isFull;
            boolean wasFull = slot < previousCounts.full();
            boolean bl = isFull = slot < currentCounts.full();
            if (!wasFull || isFull) continue;
            this.activeBlinkSlots.put(slot, new BlinkState(now + (long)duration));
        }
    }

    private static BubbleCounts calculateBubbleCounts(float airValue, int maxAir) {
        int safeMaxAir = Math.max(1, maxAir);
        int clampedAir = class_3532.method_15340((int)class_3532.method_15375((float)airValue), (int)0, (int)safeMaxAir);
        double ratio = 10.0 / (double)safeMaxAir;
        int full = class_3532.method_15384((double)(((double)clampedAir - 2.0) * ratio));
        int popping = class_3532.method_15384((double)((double)clampedAir * ratio)) - full;
        full = class_3532.method_15340((int)full, (int)0, (int)10);
        popping = class_3532.method_15340((int)popping, (int)0, (int)(10 - full));
        return new BubbleCounts(full, popping);
    }

    private void cleanupExpiredBlinks(long now) {
        Iterator<Map.Entry<Integer, BlinkState>> iterator = this.activeBlinkSlots.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BlinkState> entry = iterator.next();
            if (now < entry.getValue().endTimeMs) continue;
            iterator.remove();
        }
    }

    private SlotPlacement computeSlotPlacement(int logicalIndex, RenderMetrics metrics) {
        int bubblesInRow;
        int perRow = metrics.bubblesPerRow;
        int rawRow = logicalIndex / perRow;
        int row = this.isTopAligned() ? rawRow : metrics.rows - 1 - rawRow;
        int topRowRawIndex = (metrics.totalSlots - 1) / perRow;
        int n = bubblesInRow = rawRow == topRowRawIndex ? metrics.totalSlots - rawRow * perRow : perRow;
        if (bubblesInRow <= 0) {
            bubblesInRow = perRow;
        }
        int alignmentOffset = 0;
        if (rawRow == topRowRawIndex && this.isCenterAligned()) {
            alignmentOffset = (perRow - bubblesInRow) / 2;
        }
        int rawColumn = logicalIndex % perRow;
        int column = this.isRightAligned() ? perRow - 1 - rawColumn : rawColumn;
        column = Math.max(0, column + alignmentOffset);
        return new SlotPlacement(column, Math.max(0, row));
    }

    private boolean isTopAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_LEFT, SpiffyAlignment.TOP_CENTERED, SpiffyAlignment.TOP_RIGHT -> true;
            default -> false;
        };
    }

    private boolean isCenterAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_CENTERED, SpiffyAlignment.MID_CENTERED, SpiffyAlignment.BOTTOM_CENTERED -> true;
            default -> false;
        };
    }

    private boolean isRightAligned() {
        return switch (this.spiffyAlignment) {
            case SpiffyAlignment.TOP_RIGHT, SpiffyAlignment.MID_RIGHT, SpiffyAlignment.BOTTOM_RIGHT -> true;
            default -> false;
        };
    }

    public void setCustomTexture(@NotNull AirTextureKind kind, @Nullable ResourceSupplier<ITexture> supplier) {
        if (supplier == null) {
            this.customTextures.remove((Object)kind);
        } else {
            this.customTextures.put(kind, supplier);
        }
    }

    @Nullable
    public ResourceSupplier<ITexture> getCustomTexture(@NotNull AirTextureKind kind) {
        return this.customTextures.get((Object)kind);
    }

    @NotNull
    public Map<AirTextureKind, ResourceSupplier<ITexture>> getCustomTextureMap() {
        return Collections.unmodifiableMap(this.customTextures);
    }

    public static enum AirTextureKind {
        EMPTY("empty", -2145180878),
        FULL("full", -8862721),
        POPPING("popping", -4267777);

        private final String translationKeySuffix;
        private final int defaultColor;

        private AirTextureKind(String translationKeySuffix, int defaultColor) {
            this.translationKeySuffix = translationKeySuffix;
            this.defaultColor = defaultColor;
        }

        public String getTranslationKey() {
            return "spiffyhud.elements.player_air_bubble_bar.texture." + this.translationKeySuffix;
        }
    }

    private static class PlayerData {
        final float currentAir;
        final int maxAir;
        final float airPerSlot;
        final int fullBubbles;
        final int poppingBubbles;

        PlayerData(int currentAir, int maxAir) {
            this.maxAir = Math.max(1, maxAir);
            this.currentAir = class_3532.method_15340((int)currentAir, (int)0, (int)this.maxAir);
            this.airPerSlot = (float)this.maxAir / 10.0f;
            BubbleCounts counts = PlayerAirBubbleBarElement.calculateBubbleCounts(this.currentAir, this.maxAir);
            this.fullBubbles = counts.full();
            this.poppingBubbles = counts.popping();
        }
    }

    private record RenderMetrics(int bubblesPerRow, int baseBubbleSize, int totalSlots, int bodyWidth, int bodyHeight, int rows, int horizontalGap, int verticalGap) {
    }

    private record SlotPlacement(int column, int row) {
    }

    private record BlinkState(long endTimeMs) {
    }

    private record BubbleCounts(int full, int popping) {
    }
}

