/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.playerarmorbar;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.playerarmorbar.PlayerArmorBarEditorElement;
import de.keksuccino.spiffyhud.customization.elements.playerarmorbar.PlayerArmorBarElement;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerArmorBarElementBuilder
extends ElementBuilder<PlayerArmorBarElement, PlayerArmorBarEditorElement> {
    public PlayerArmorBarElementBuilder() {
        super("spiffy_player_armor_bar");
    }

    @NotNull
    public PlayerArmorBarElement buildDefaultInstance() {
        PlayerArmorBarElement element = new PlayerArmorBarElement(this);
        element.baseWidth = 100;
        element.baseHeight = 100;
        return element;
    }

    public PlayerArmorBarElement deserializeElement(@NotNull SerializedElement serialized) {
        SpiffyAlignment parsed;
        PlayerArmorBarElement element = this.buildDefaultInstance();
        element.iconsPerRow = Math.max(1, (Integer)this.deserializeNumber(Integer.class, element.iconsPerRow, serialized.getValue("icons_per_row")));
        element.iconGap = Math.max(0, (Integer)this.deserializeNumber(Integer.class, element.iconGap, serialized.getValue("icon_gap")));
        element.scaleMultiplier = Objects.requireNonNullElse(serialized.getValue("scale_multiplier"), element.scaleMultiplier);
        element.blinkOnLoss = this.deserializeBoolean(element.blinkOnLoss, serialized.getValue("blink_on_loss"));
        element.lowArmorShakeEnabled = this.deserializeBoolean(element.lowArmorShakeEnabled, serialized.getValue("shake_enabled"));
        element.lowArmorShakeThresholdIcons = Math.max(0, (Integer)this.deserializeNumber(Integer.class, element.lowArmorShakeThresholdIcons, serialized.getValue("shake_threshold_icons")));
        String alignment = serialized.getValue("spiffy_alignment");
        if (alignment != null && (parsed = SpiffyAlignment.getByName(alignment)) != null) {
            element.spiffyAlignment = parsed;
        }
        for (PlayerArmorBarElement.ArmorTextureKind kind : PlayerArmorBarElement.ArmorTextureKind.values()) {
            String key = PlayerArmorBarElementBuilder.texturePropertyKey(kind);
            ResourceSupplier supplier = PlayerArmorBarElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue(key));
            element.setCustomTexture(kind, (ResourceSupplier<ITexture>)supplier);
        }
        return element;
    }

    @Nullable
    public PlayerArmorBarElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        PlayerArmorBarElement element = (PlayerArmorBarElement)super.deserializeElementInternal(serialized);
        if (element != null) {
            element.stayOnScreen = this.deserializeBoolean(element.stayOnScreen, serialized.getValue("stay_on_screen"));
        }
        return element;
    }

    protected SerializedElement serializeElement(@NotNull PlayerArmorBarElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("icons_per_row", "" + element.iconsPerRow);
        serializeTo.putProperty("icon_gap", "" + element.iconGap);
        serializeTo.putProperty("scale_multiplier", element.scaleMultiplier);
        serializeTo.putProperty("blink_on_loss", "" + element.blinkOnLoss);
        serializeTo.putProperty("shake_enabled", "" + element.lowArmorShakeEnabled);
        serializeTo.putProperty("shake_threshold_icons", "" + element.lowArmorShakeThresholdIcons);
        serializeTo.putProperty("spiffy_alignment", element.spiffyAlignment.getName());
        for (PlayerArmorBarElement.ArmorTextureKind kind : PlayerArmorBarElement.ArmorTextureKind.values()) {
            ResourceSupplier<ITexture> supplier = element.getCustomTexture(kind);
            if (supplier == null) continue;
            serializeTo.putProperty(PlayerArmorBarElementBuilder.texturePropertyKey(kind), supplier.getSourceWithPrefix());
        }
        return serializeTo;
    }

    private static String texturePropertyKey(@NotNull PlayerArmorBarElement.ArmorTextureKind kind) {
        return "texture_" + kind.name().toLowerCase(Locale.ROOT);
    }

    @NotNull
    public PlayerArmorBarEditorElement wrapIntoEditorElement(@NotNull PlayerArmorBarElement element, @NotNull LayoutEditorScreen editor) {
        return new PlayerArmorBarEditorElement(element, editor);
    }

    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return class_2561.method_43471((String)"spiffyhud.elements.player_armor_bar");
    }

    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.elements.player_armor_bar.desc", (String[])new String[0]);
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

