/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeHotbarElement
extends AbstractElement {
    private static final class_2960 WIDGETS_LOCATION = new class_2960("textures/gui/widgets.png");
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 22;

    public VanillaLikeHotbarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        this.renderHotbar(graphics, partialTick, elementX, elementY, elementWidth, elementHeight);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderHotbar(GuiGraphics graphics, float partialTick, int elementX, int elementY, int elementWidth, int elementHeight) {
        class_1657 player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        class_1799 offhandItem = player.method_6079();
        class_1306 oppositeMainArm = player.method_6068().method_5928();
        graphics.blit(WIDGETS_LOCATION, elementX, elementY, 0, 0, elementWidth, elementHeight);
        int selectedSlot = player.method_31548().field_7545;
        graphics.blit(WIDGETS_LOCATION, elementX - 1 + selectedSlot * 20, elementY - 1, 0, 22, 24, 22);
        if (!VanillaLikeHotbarElement.isEditor()) {
            if (!offhandItem.method_7960()) {
                if (oppositeMainArm == class_1306.field_6182) {
                    graphics.blit(WIDGETS_LOCATION, elementX - 29, elementY - 1, 24, 22, 29, 24);
                } else {
                    graphics.blit(WIDGETS_LOCATION, elementX + elementWidth, elementY - 1, 53, 22, 29, 24);
                }
            }
        } else {
            graphics.blit(WIDGETS_LOCATION, elementX - 29, elementY - 1, 24, 22, 29, 24);
            graphics.blit(WIDGETS_LOCATION, elementX + elementWidth, elementY - 1, 53, 22, 29, 24);
        }
        int slotStartX = elementX + 3;
        int slotY = elementY + 3;
        int renderSeed = 1;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int slotX = slotStartX + slotIndex * 20;
            this.renderSlot(graphics, slotX, slotY, partialTick, player, (class_1799)player.method_31548().field_7547.get(slotIndex), renderSeed++);
        }
        if (!offhandItem.method_7960()) {
            if (oppositeMainArm == class_1306.field_6182) {
                this.renderSlot(graphics, elementX - 26, slotY, partialTick, player, offhandItem, renderSeed++);
            } else {
                this.renderSlot(graphics, elementX + elementWidth + 10, slotY, partialTick, player, offhandItem, renderSeed++);
            }
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderSlot(GuiGraphics graphics, int slotX, int slotY, float partialTick, class_1657 player, class_1799 stack, int renderSeed) {
        if (stack.method_7960()) {
            return;
        }
        float popTimeRemaining = (float)stack.method_7965() - partialTick;
        if (popTimeRemaining > 0.0f) {
            float scaleFactor = 1.0f + popTimeRemaining / 5.0f;
            graphics.pose().method_22903();
            graphics.pose().method_22904((double)(slotX + 8), (double)(slotY + 12), 0.0);
            graphics.pose().method_22905(1.0f / scaleFactor, (scaleFactor + 1.0f) / 2.0f, 1.0f);
            graphics.pose().method_22904((double)(-(slotX + 8)), (double)(-(slotY + 12)), 0.0);
        }
        graphics.renderItem((class_1309)player, stack, slotX, slotY, renderSeed);
        if (popTimeRemaining > 0.0f) {
            graphics.pose().method_22909();
        }
        this.renderSlotDecorations(graphics, player, stack, slotX, slotY);
    }

    private void renderSlotDecorations(GuiGraphics graphics, @Nullable class_1657 player, class_1799 stack, int slotX, int slotY) {
        float cooldownProgress;
        graphics.pose().method_22903();
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        if (stack.method_7947() != 1) {
            String countText = String.valueOf(stack.method_7947());
            graphics.pose().method_22904(0.0, 0.0, 200.0);
            graphics.drawString(font, countText, slotX + 19 - 2 - font.method_1727(countText), slotY + 6 + 3, 0xFFFFFF, true);
        }
        if (stack.method_31578()) {
            int barWidth = stack.method_31579();
            int barColor = stack.method_31580();
            int barX = slotX + 2;
            int barY = slotY + 13;
            graphics.fill(barX, barY, barX + 13, barY + 2, -16777216);
            graphics.fill(barX, barY, barX + barWidth, barY + 1, barColor | 0xFF000000);
        }
        if (player != null && (cooldownProgress = player.method_7357().method_7905(stack.method_7909(), minecraft.method_1488())) > 0.0f) {
            int overlayTop = slotY + class_3532.method_15375((float)(16.0f * (1.0f - cooldownProgress)));
            int overlayBottom = overlayTop + class_3532.method_15386((float)(16.0f * cooldownProgress));
            graphics.fill(slotX, overlayTop, slotX + 16, overlayBottom, Integer.MAX_VALUE);
        }
        graphics.pose().method_22909();
    }

    @Nullable
    private class_1657 getCameraPlayer() {
        class_1657 p;
        class_1297 class_12972 = class_310.method_1551().method_1560();
        return class_12972 instanceof class_1657 ? (p = (class_1657)class_12972) : null;
    }

    public int getAbsoluteWidth() {
        return 182;
    }

    public int getAbsoluteHeight() {
        return 22;
    }
}

