/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.marker;

import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.SerializationUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkerData {
    @NotNull
    private String name = "";
    @Nullable
    private String color;
    @Nullable
    private String dotTexture;
    @Nullable
    private String needleTexture;
    private boolean showAsNeedle;
    @NotNull
    private String markerPosX = "0";
    @NotNull
    private String markerPosZ = "0";

    public MarkerData() {
    }

    public MarkerData(@NotNull String name, @Nullable String color, @Nullable String dotTexture, @Nullable String needleTexture, boolean showAsNeedle, @NotNull String markerPosX, @NotNull String markerPosZ) {
        this.name = MarkerData.normalizeName(name);
        this.color = MarkerData.normalizeString(color);
        this.dotTexture = MarkerData.normalizeString(dotTexture);
        this.needleTexture = MarkerData.normalizeString(needleTexture);
        this.showAsNeedle = showAsNeedle;
        this.markerPosX = markerPosX;
        this.markerPosZ = markerPosZ;
    }

    public MarkerData(@NotNull MarkerData source) {
        this.name = source.name;
        this.color = source.color;
        this.dotTexture = source.dotTexture;
        this.needleTexture = source.needleTexture;
        this.showAsNeedle = source.showAsNeedle;
        this.markerPosX = source.markerPosX;
        this.markerPosZ = source.markerPosZ;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = MarkerData.normalizeName(name);
    }

    @Nullable
    public String getColor() {
        return this.color;
    }

    public void setColor(@Nullable String color) {
        this.color = MarkerData.normalizeString(color);
    }

    @Nullable
    public String getDotTexture() {
        return this.dotTexture;
    }

    public void setDotTexture(@Nullable String texture) {
        this.dotTexture = MarkerData.normalizeString(texture);
    }

    @Nullable
    public String getNeedleTexture() {
        return this.needleTexture;
    }

    public void setNeedleTexture(@Nullable String texture) {
        this.needleTexture = MarkerData.normalizeString(texture);
    }

    public boolean isShowAsNeedle() {
        return this.showAsNeedle;
    }

    public void setShowAsNeedle(boolean showAsNeedle) {
        this.showAsNeedle = showAsNeedle;
    }

    public double getResolvedMarkerPosX() {
        return (Double)SerializationUtils.deserializeNumber(Double.class, (Number)0.0, (String)PlaceholderParser.replacePlaceholders((String)this.markerPosX));
    }

    @NotNull
    public String getMarkerPosX() {
        return this.markerPosX;
    }

    public void setMarkerPosX(@NotNull String markerPosX) {
        this.markerPosX = markerPosX;
    }

    public double getResolvedMarkerPosZ() {
        return (Double)SerializationUtils.deserializeNumber(Double.class, (Number)0.0, (String)PlaceholderParser.replacePlaceholders((String)this.markerPosZ));
    }

    @NotNull
    public String getMarkerPosZ() {
        return this.markerPosZ;
    }

    public void setMarkerPosZ(@NotNull String markerPosZ) {
        this.markerPosZ = markerPosZ;
    }

    public boolean hasValidName() {
        return !this.name.isBlank();
    }

    public boolean hasTexture() {
        return this.dotTexture != null && !this.dotTexture.isBlank() || this.needleTexture != null && !this.needleTexture.isBlank();
    }

    @NotNull
    public MarkerData copy() {
        return new MarkerData(this);
    }

    public void copyFrom(@NotNull MarkerData source) {
        this.name = source.name;
        this.color = source.color;
        this.dotTexture = source.dotTexture;
        this.needleTexture = source.needleTexture;
        this.showAsNeedle = source.showAsNeedle;
        this.markerPosX = source.markerPosX;
        this.markerPosZ = source.markerPosZ;
    }

    @NotNull
    private static String normalizeName(@NotNull String name) {
        Objects.requireNonNull(name, "name");
        return PlaceholderParser.replacePlaceholders((String)name.trim());
    }

    @Nullable
    private static String normalizeString(@Nullable String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }
}

