package de.keksuccino.spiffyhud.customization.elements.playernbthelper;

import de.keksuccino.fancymenu.util.ObjectUtils;
import de.keksuccino.fancymenu.util.rendering.text.markdown.ScrollableMarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.spiffyhud.util.level.EntityNbtUtils;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class PlayerNbtPathHelpScreen extends class_437 {

    protected class_437 parent;
    protected ScrollableMarkdownRenderer markdownRenderer;
    protected int headerHeight = 20;
    protected int footerHeight = 40;
    protected int border = 40;
    protected boolean textSet = false;
    protected final List<String> lines = ObjectUtils.build(() -> {

        List<String> l = (class_310.method_1551().field_1724 == null) ? new ArrayList<>() : EntityNbtUtils.getAllNbtPaths(class_310.method_1551().field_1724);

        // start
        l.add(0, "^^^");
        l.add(1, " ");
        l.add(2, class_1074.method_4662("spiffyhud.elements.player_nbt_helper.paths.headline"));
        l.add(3, " ");

        // existing lines here

        // end
        l.add("^^^");

        return l;

    });

    public PlayerNbtPathHelpScreen(@NotNull class_437 parent) {
        super(class_2561.method_43473());
        this.parent = parent;
    }

    protected void method_25426() {

        int centerX = this.field_22789 / 2;
        int scrollWidth = this.field_22789 - this.border * 2;
        int scrollHeight = this.field_22790 - this.headerHeight - this.footerHeight;

        if (this.markdownRenderer == null) {
            this.markdownRenderer = new ScrollableMarkdownRenderer((float)(centerX - scrollWidth / 2), (float)this.headerHeight, (float)scrollWidth, (float)scrollHeight);
        } else {
            this.markdownRenderer.rebuild((float)(centerX - scrollWidth / 2), (float)this.headerHeight, (float)scrollWidth, (float)scrollHeight);
        }
        this.markdownRenderer.getMarkdownRenderer().setHeadlineLineColor(UIBase.getUIColorTheme().screen_background_color_darker);
        this.markdownRenderer.getMarkdownRenderer().setTextBaseColor(UIBase.getUIColorTheme().generic_text_base_color);
        this.markdownRenderer.getMarkdownRenderer().setTextShadow(false);
        this.method_37063(this.markdownRenderer);

        UIBase.applyDefaultWidgetSkinTo(this.method_37063(new ExtendedButton(centerX - 100, this.field_22790 - this.footerHeight / 2 - 10, 200, 20, class_2561.method_43471("fancymenu.common.close"), (var1) -> this.method_25419())));

    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        if (!this.textSet) {
            StringBuilder lineString = new StringBuilder();
            for(String s : lines) {
                lineString.append(s).append("\n");
            }
            this.markdownRenderer.setText(lineString.toString());
            this.textSet = true;
        }

        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color_darker.getColorInt());
        graphics.method_25294(0, this.field_22790 - this.footerHeight, this.field_22789, this.field_22790, UIBase.getUIColorTheme().area_background_color.getColorInt());

        super.method_25394(graphics, mouseX, mouseY, partial);

    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.markdownRenderer.method_25401(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
    }

    @Override
    public boolean method_25406(class_11909 event) {
        return this.markdownRenderer.method_25406(event);
    }

    @Override
    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }

}
