package de.keksuccino.spiffyhud.customization.elements.slot;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

public class SlotElement extends AbstractElement {

    private static final Logger LOGGER = LogManager.getLogger();

    @NotNull
    public String slot = "0";
    public int parsedSlot = 0;
    public boolean useSelectedSlot = false;
    public boolean showDurability = true;

    protected final class_327 font = class_310.method_1551().field_1772;

    public SlotElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        if (this.shouldRender()) {

            String slotString = PlaceholderParser.replacePlaceholders(this.slot).trim();
            if (MathUtils.isInteger(slotString)) {
                this.parsedSlot = Integer.parseInt(slotString);
            } else {
                this.parsedSlot = 0;
            }

            if (class_310.method_1551().field_1724 == null) return;

            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();

            if (isEditor()) {

                class_5250 label = this.useSelectedSlot ? class_2561.method_43470("SEL") : class_2561.method_43470("" + this.parsedSlot);
                if (this.customElementLayerName != null) {
                    label = buildComponent(this.customElementLayerName).method_27661();
                    label.method_10852(this.useSelectedSlot ? class_2561.method_43470(" (SEL)") : class_2561.method_43470(" (" + this.parsedSlot + ")"));
                }

                graphics.method_25294(x, y, x + w, y + h, this.inEditorColor.getColorIntWithAlpha(0.5F));
                UIBase.renderBorder(graphics, x, y, x + w, y + h, 1, this.inEditorColor.getColorIntWithAlpha(0.8F), true, true, true, true);

                graphics.method_27534(this.font, label, x + (w / 2), y + (h / 2) - (this.font.field_2000 / 2), -1);

            } else {

                class_1799 slotItem = this.useSelectedSlot ? class_310.method_1551().field_1724.method_31548().method_7391() : class_310.method_1551().field_1724.method_31548().method_5438(this.parsedSlot);
                if (slotItem == class_1799.field_8037) return;

                //Render the item slightly smaller than the actual element, so it renders at 16x16 pixels when the element is 20x20 (like Vanilla)
                this.renderItem(graphics, x + 2, y + 2, w - 4, h - 4, mouseX, mouseY, slotItem);

            }

        }

    }

    protected void renderItem(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY, @NotNull class_1799 itemStack) {

        int count = itemStack.method_7947();

        this.renderScaledItem(graphics, itemStack, x, y, width, height);

        if (count > 1) {
            this.renderItemCount(graphics, this.font, x, y, Math.max(width, height), count);
        }

    }

    protected void renderScaledItem(@NotNull class_332 graphics, @NotNull class_1799 stack, int x, int y, int width, int height) {

        // Save the current transformation state.
        Matrix3x2fStack pose = graphics.method_51448();
        pose.pushMatrix();

        // Translate to the top-left of where you want the item to be drawn.
        pose.translate(x, y);

        // Calculate a uniform scale factor based on the desired size.
        // (Items are rendered at a base size of 16x16.)
        float scale = Math.min(width, height) / 16.0F;
        pose.scale(scale, scale);

        // Now render the item at (0,0) because the translation has been applied.
        graphics.method_51427(stack, 0, 0);

        // Render durability bar if enabled and needed
        if (this.showDurability && stack.method_31578()) {
            int barWidth = stack.method_31579();
            int barColor = stack.method_31580();
            
            // Position the bar - using the same positioning logic as in GuiGraphics
            int barX = 2;
            int barY = 13;
            
            // Draw the background (black)
            graphics.method_25294(barX, barY,
                          barX + 13, barY + 2, 
                          SpiffyRenderUtils.colorWithAlpha(-16777216, this.opacity));
            
            // Draw the colored part of the bar
            graphics.method_25294(barX, barY,
                          barX + barWidth, barY + 1,
                    SpiffyRenderUtils.colorWithAlpha(barColor | 0xFF000000, this.opacity));
        }

        // Render item cooldown overlay similar to vanilla hotbar slots.
        if (class_310.method_1551().field_1724 != null) {
            float cooldownProgress = class_310.method_1551().field_1724.method_7357().method_7905(stack, class_310.method_1551().method_61966().method_60637(true));
            if (cooldownProgress > 0.0F) {
                int overlayTop = class_3532.method_15375(16.0F * (1.0F - cooldownProgress));
                int overlayBottom = overlayTop + class_3532.method_15386(16.0F * cooldownProgress);
                graphics.method_25294(0, overlayTop, 16, overlayBottom, Integer.MAX_VALUE);
            }
        }

        // Restore the previous transformation state.
        pose.popMatrix();

    }

    protected void renderItemCount(@NotNull class_332 graphics, @NotNull class_327 font, int x, int y, int size, int count) {

        Matrix3x2fStack pose = graphics.method_51448();
        String text = String.valueOf(count);
        // Calculate scaling factor relative to original 16x16 size
        float scaleFactor = size / 16.0F;

        pose.pushMatrix();
        pose.translate(0.0F, 0.0F);
        pose.pushMatrix();

        // Scale text exactly proportionally to item size
        pose.scale(scaleFactor, scaleFactor);

        // Convert item-space coordinates to scaled text-space coordinates
        int scaledX = (int)((x / scaleFactor) + 19 - 2 - font.method_1727(text));
        int scaledY = (int)((y / scaleFactor) + 6 + 3);

        graphics.method_51433(font, text, scaledX, scaledY, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity), true);
        pose.popMatrix();
        pose.popMatrix();

    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        class_5250 c = super.getDisplayName().method_27661();
        c.method_10852(this.useSelectedSlot ? class_2561.method_43470(" (SEL)") : class_2561.method_43470(" (" + this.parsedSlot + ")"));
        return c;
    }

}
