package de.keksuccino.spiffyhud.customization.placeholders;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.spiffyhud.mixin.mixins.common.client.IMixinGui;
import de.keksuccino.spiffyhud.util.ComponentUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ActionBarMessagePlaceholder extends Placeholder {

    public ActionBarMessagePlaceholder() {
        super("action_bar_message");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_2561 message = ((IMixinGui)class_310.method_1551().field_1705).get_overlayMessageString_Spiffy();
        if (message != null) {
            return ComponentUtils.toJson(message);
        }
        return "";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return null;
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("spiffyhud.placeholders.action_bar_message");
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("spiffyhud.placeholders.action_bar_message.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        return new DeserializedPlaceholderString(this.getIdentifier(), null, "");
    }

}
