package de.keksuccino.spiffyhud.networking.packets.structure.playerpos;

import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.spiffyhud.util.level.StructureUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PlayerPosStructuresPacketLogic {

    private static final Logger LOGGER = LogManager.getLogger();

    protected static boolean handleOnServer(@NotNull PlayerPosStructuresPacket packet, @NotNull class_3222 sender) {
        if (sender.method_51469() instanceof class_3218 level) {
            PlayerPosStructuresPacket answer = new PlayerPosStructuresPacket();
            answer.structures = StructureUtils.convertStructureKeysToStrings(StructureUtils.getAllStructuresAt(level, sender.method_24515()));
            PacketHandler.sendToClient(sender, answer);
            return true;
        }
        return false;
    }

    protected static boolean handleOnClient(@NotNull PlayerPosStructuresPacket packet) {
        MainThreadTaskExecutor.executeInMainThread(() -> {
            PlayerPosStructuresPacket.CACHED_CURRENT_STRUCTURES.clear();
            PlayerPosStructuresPacket.CACHED_CURRENT_STRUCTURES.addAll(Objects.requireNonNullElse(packet.structures, new ArrayList<>()));
        }, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
        return true;
    }

}
