package de.keksuccino.spiffyhud.util.rendering;

import org.jetbrains.annotations.NotNull;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10017;

public class EntityRenderingUtils {

    private static final Map<class_10017, Float> LIVING_ENTITY_OPACITIES = new HashMap<>();

    public static void submitLivingEntityOpacity(@NotNull class_10017 entityRenderState, float opacity) {
        LIVING_ENTITY_OPACITIES.put(entityRenderState, opacity);
    }

    public static float getLivingEntityOpacity(@NotNull class_10017 entityRenderState) {
        return LIVING_ENTITY_OPACITIES.getOrDefault(entityRenderState, 1.0F);
    }

    public static void resetLivingEntityOpacities() {
        LIVING_ENTITY_OPACITIES.clear();
    }

}
