package de.keksuccino.spiffyhud.util.rendering;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_10017;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3730;
import net.minecraft.class_7833;
import net.minecraft.class_8942;
import net.minecraft.class_897;
import net.minecraft.class_898;

/**
 * Utility for rendering a mob's flat front view inside a GUI square.
 */
public class FlatMobRenderUtils {

    private static final class_310 MC = class_310.method_1551();
    private static final float VIEWPORT_FILL_RATIO = 0.92F; // keep a little padding so tall mobs don't clip
    private static final float HALF = 0.5F;
    private static final Map<class_1308, class_1308> RENDER_CLONES = new WeakHashMap<>();

    private FlatMobRenderUtils() {
    }

    public static boolean renderFlatMob(@NotNull class_332 graphics, int left, int top, int size, @Nullable class_1308 mob, float opacity) {
        class_1308 renderMob = prepareRenderMob(mob);
        if (renderMob == null) {
            return false;
        }
        graphics.method_44379(left, top, left + size, top + size);
        MobBounds bounds = captureBounds(renderMob);
        float scale = computeScale(bounds, size);
        Vector3f offset = new Vector3f(0.0F, bounds.height * HALF, 0.0F);
        Quaternionf baseRotation = class_7833.field_40718.rotationDegrees(180.0F);

        float originalBody = renderMob.field_6283;
        float originalBodyO = renderMob.field_6220;
        float originalYRot = renderMob.method_36454();
        float originalYRotO = renderMob.field_5982;
        float originalXRot = renderMob.method_36455();
        float originalXRotO = renderMob.field_6004;
        float originalHead = renderMob.field_6241;
        float originalHeadO = renderMob.field_6259;

        renderMob.method_5636(180.0F);
        renderMob.field_6220 = 180.0F;
        renderMob.method_36456(180.0F);
        renderMob.field_5982 = 180.0F;
        renderMob.method_36457(0.0F);
        renderMob.field_6004 = 0.0F;
        renderMob.method_5847(180.0F);
        renderMob.field_6259 = 180.0F;

        renderEntity(graphics, left, top, size, scale, offset, baseRotation, renderMob);

        renderMob.method_5636(originalBody);
        renderMob.field_6220 = originalBodyO;
        renderMob.method_36456(originalYRot);
        renderMob.field_5982 = originalYRotO;
        renderMob.method_36457(originalXRot);
        renderMob.field_6004 = originalXRotO;
        renderMob.method_5847(originalHead);
        renderMob.field_6259 = originalHeadO;

        graphics.method_44380();
        return true;
    }

    private static void renderEntity(
            @NotNull class_332 graphics,
            int left,
            int top,
            int size,
            float scale,
            @NotNull Vector3f offset,
            @NotNull Quaternionf modelRotation,
            @NotNull class_1308 mob
    ) {
        class_898 dispatcher = class_310.method_1551().method_1561();
        class_897<? super class_1308, ?> renderer = dispatcher.method_3953(mob);
        class_10017 renderState = renderer.method_62425(mob, 1.0F);
        renderState.field_61820 = 15728880;
        renderState.field_58169 = null;
        renderState.field_58170 = null;
        renderState.field_61823.clear();
        renderState.field_61821 = class_10017.field_61824;

        graphics.method_70856(
                renderState,
                scale,
                offset,
                modelRotation,
                null,
                left,
                top,
                left + size,
                top + size
        );
    }

    @NotNull
    private static MobBounds captureBounds(@NotNull class_1308 mob) {
        class_238 boundingBox = mob.method_5829();
        double width = boundingBox.field_1320 - boundingBox.field_1323;
        double height = boundingBox.field_1325 - boundingBox.field_1322;
        double depth = boundingBox.field_1324 - boundingBox.field_1321;
        float widthF = (float) Math.max(width, 0.001F);
        float heightF = (float) Math.max(height, 0.001F);
        float depthF = (float) Math.max(depth, 0.001F);
        return new MobBounds(heightF, Math.max(widthF, depthF));
    }

    private static float computeScale(@NotNull MobBounds bounds, int size) {
        float dominant = Math.max(bounds.height, bounds.horizontal);
        float available = Math.max(size * VIEWPORT_FILL_RATIO, 1.0F);
        return available / dominant;
    }

    @Nullable
    private static class_1308 prepareRenderMob(@Nullable class_1308 source) {
        if (!isRenderableSource(source)) {
            evict(source);
            return null;
        }
        class_1937 level = source.method_73183();
        if (level == null) {
            evict(source);
            return null;
        }
        class_1308 clone = RENDER_CLONES.get(source);
        if (clone == null || clone.method_31481() || clone.method_73183() != level) {
            clone = createClone(source);
            if (clone == null) {
                evict(source);
                return null;
            }
            RENDER_CLONES.put(source, clone);
        }
        return clone;
    }

    private static boolean isRenderableSource(@Nullable class_1308 source) {
        return source != null && source.method_5805() && !source.method_31481();
    }

    private static void evict(@Nullable class_1308 source) {
        if (source != null) {
            RENDER_CLONES.remove(source);
        }
    }

    @Nullable
    private static class_1308 createClone(@NotNull class_1308 source) {
        class_1937 level = source.method_73183();
        if (level == null) {
            level = MC.field_1687;
        }
        if (level == null) {
            return null;
        }
        class_1308 copy = (class_1308) source.method_5864().method_5883(level, class_3730.field_52444);
        if (copy == null) {
            return null;
        }
        copy.method_5875(true);
        copy.method_5977(true);
        copy.field_5960 = true;
        copy.method_5803(true);
        copyMobData(source, copy);
        return copy;
    }

    private static void copyMobData(@NotNull class_1308 source, @NotNull class_1308 target) {
        class_11362 tagOutput = class_11362.method_71458(class_8942.field_60348);
        source.method_5647(tagOutput);
        class_2487 tag = tagOutput.method_71475();
        tag.method_10556("PersistenceRequired", false);
        target.method_5651(class_11352.method_71417(class_8942.field_60348, target.method_56673(), tag));
        target.method_5875(true);
        target.method_5977(true);
        target.field_5960 = true;
        target.method_5803(true);
    }

    private static final class MobBounds {
        private final float height;
        private final float horizontal;

        private MobBounds(float height, float horizontal) {
            this.height = height;
            this.horizontal = horizontal;
        }
    }

}
