package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.spiffyhud.mixin.mixins.common.client.IMixinGuiGraphics;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_8689;
import net.minecraft.class_8690;
import net.minecraft.class_9848;

public class SpiffyRenderUtils {

    private static boolean blendLocked = false;

    public static void lockBlend(boolean lock) {
        blendLocked = true;
    }

    public static boolean isBlendLocked() {
        return blendLocked;
    }

    /**
     * Draws a textured quad with the U texture coordinates swapped so that the image appears mirrored horizontally.
     * In 1.21.6, this uses the mixin implementation for proper UV coordinate mirroring.
     *
     * @param graphics             The graphics context.
     * @param atlasLocation        The texture atlas.
     * @param x                    The screen X coordinate.
     * @param y                    The screen Y coordinate.
     * @param u                    The source U coordinate (left edge) of the texture.
     * @param v                    The source V coordinate (top edge) of the texture.
     * @param width                The width of the quad.
     * @param height               The height of the quad.
     * @param textureWidth         The width of the texture.
     * @param textureHeight        The height of the texture.
     * @param color                The color to apply to the texture.
     */
    public static void blitMirrored(
            class_332 graphics,
            class_2960 atlasLocation,
            int x,
            int y,
            int u,
            int v,
            int width,
            int height,
            int textureWidth,
            int textureHeight,
            int color) {
        
        RenderSystem.assertOnRenderThread();
        
        // Cast to our extended interface and use the mixin method
        ExtendedGuiGraphics extended = (ExtendedGuiGraphics) graphics;
        extended.blitMirrored_Spiffy(
            class_10799.field_56883,
            atlasLocation,
            x, y,
            width, height,
            (float) u, (float) v,
            (float) width, (float) height,
            textureWidth, textureHeight,
            color
        );
    }

    /**
     * Draws a textured quad with the U texture coordinates swapped so that the image appears mirrored horizontally.
     * Uses white color.
     */
    public static void blitMirrored(
            class_332 graphics,
            class_2960 atlasLocation,
            int x,
            int y,
            int u,
            int v,
            int width,
            int height,
            int textureWidth,
            int textureHeight) {

        blitMirrored(
            graphics,
            atlasLocation,
            x,
            y,
            u,
            v,
            width,
            height,
            textureWidth,
            textureHeight,
            -1  // White (fully opaque)
        );
    }

    /**
     * Draws a sprite horizontally mirrored (flipped along the vertical axis).
     * This method is specifically designed for sprite resources and handles sprite texture coordinates.
     *
     * @param graphics         The graphics context.
     * @param sprite           The sprite resource location.
     * @param x                The screen X coordinate.
     * @param y                The screen Y coordinate.
     * @param width            The width of the sprite.
     * @param height           The height of the sprite.
     * @param color            The color to apply to the sprite.
     */
    public static void blitSpriteMirrored(
            class_332 graphics,
            class_2960 sprite,
            int x,
            int y,
            int width,
            int height,
            int color) {

        RenderSystem.assertOnRenderThread();
        
        IMixinGuiGraphics mixinGraphics = (IMixinGuiGraphics) graphics;
        class_1058 atlasSprite = mixinGraphics.get_guiSprites_Spiffy().method_4608(sprite);
        class_2960 atlasLocation = atlasSprite.method_45852();
        
        // Get the sprite's UV coordinates
        float u0 = atlasSprite.method_4594();
        float v0 = atlasSprite.method_4593();
        float u1 = atlasSprite.method_4577();
        float v1 = atlasSprite.method_4575();
        
        // Derive atlas dimensions from the normalized UV range
        int atlasWidth = (int) (atlasSprite.method_45851().method_45807() / (u1 - u0));
        int atlasHeight = (int) (atlasSprite.method_45851().method_45815() / (v1 - v0));
        
        // Calculate the actual pixel coordinates in the atlas
        float uPixel = u0 * atlasWidth;
        float vPixel = v0 * atlasHeight;
        float uWidth = (u1 - u0) * atlasWidth;
        float vHeight = (v1 - v0) * atlasHeight;
        
        // Use the mixin method with the sprite's texture coordinates
        ExtendedGuiGraphics extended = (ExtendedGuiGraphics) graphics;
        extended.blitMirrored_Spiffy(
            class_10799.field_56883,
            atlasLocation,
            x, y,
            width, height,
            uPixel, vPixel,
            uWidth, vHeight,
            atlasWidth, atlasHeight,
            color
        );
    }

    /**
     * Draws a sprite horizontally mirrored (flipped along the vertical axis).
     * Uses white color.
     */
    public static void blitSpriteMirrored(
            class_332 graphics,
            class_2960 sprite,
            int x,
            int y,
            int width,
            int height) {

        blitSpriteMirrored(
            graphics,
            sprite,
            x,
            y,
            width,
            height,
            -1  // White (fully opaque)
        );
    }

    /**
     * Blits a sprite with specific UV coordinates.
     * In 1.21.6, we use mixins to access the private blitSprite method for proper sprite rendering.
     */
    public static void blitSprite(
            class_332 graphics,
            class_2960 sprite,
            int textureWidth,
            int textureHeight,
            int uPosition,
            int vPosition,
            int x,
            int y,
            int uWidth,
            int vHeight,
            int color
    ) {
        IMixinGuiGraphics mixinGraphics = (IMixinGuiGraphics) graphics;
        class_1058 textureAtlasSprite = mixinGraphics.get_guiSprites_Spiffy().method_4608(sprite);
        class_8690 guiSpriteScaling = getSpriteScaling(textureAtlasSprite);
        
        if (guiSpriteScaling instanceof class_8690.class_8693) {
            mixinGraphics.invoke_private_blitSprite_Spiffy(
                class_10799.field_56883,
                textureAtlasSprite,
                textureWidth,
                textureHeight,
                uPosition,
                vPosition,
                x,
                y,
                uWidth,
                vHeight,
                color
            );
        } else {
            graphics.method_44379(x, y, x + uWidth, y + vHeight);
            graphics.method_52707(class_10799.field_56883, sprite, x - uPosition, y - vPosition, textureWidth, textureHeight, color);
            graphics.method_44380();
        }
    }

    /**
     * Draws a textured quad with the U texture coordinates swapped using matrix transformation.
     * This is an alternative mirroring approach using matrix scaling.
     *
     * @param graphics             The graphics context.
     * @param atlasLocation        The texture atlas.
     * @param x                    The screen X coordinate.
     * @param y                    The screen Y coordinate.
     * @param u                    The source U coordinate (left edge) of the texture.
     * @param v                    The source V coordinate (top edge) of the texture.
     * @param width                The width of the quad.
     * @param height               The height of the quad.
     * @param textureWidth         The width of the texture.
     * @param textureHeight        The height of the texture.
     * @param color                The color to apply to the texture.
     */
    public static void blitMirroredMatrix(
            class_332 graphics,
            class_2960 atlasLocation,
            int x,
            int y,
            int u,
            int v,
            int width,
            int height,
            int textureWidth,
            int textureHeight,
            int color) {
        
        RenderSystem.assertOnRenderThread();
        
        // Cast to our extended interface and use the matrix-based mixin method
        ExtendedGuiGraphics extended = (ExtendedGuiGraphics) graphics;
        extended.blitMirroredMatrix_Spiffy(
            class_10799.field_56883,
            atlasLocation,
            x, y,
            width, height,
            (float) u, (float) v,
            (float) width, (float) height,
            textureWidth, textureHeight,
            color
        );
    }

    /**
     * Returns the given color with the given alpha applied.
     *
     * @param color The original color value (ARGB format)
     * @param alpha The alpha value to apply (0.0f to 1.0f)
     *
     * @return The color with the new alpha value applied
     */
    public static int colorWithAlpha(int color, float alpha) {
        int alphaComponent = Math.round(alpha * 255.0f);
        if (alphaComponent > 255) alphaComponent = 255;
        if (alphaComponent < 0) alphaComponent = 0;
        // Extract color components
        int red = class_9848.method_61327(color);
        int green = class_9848.method_61329(color);
        int blue = class_9848.method_61331(color);
        // Create new color with the specified alpha
        return class_9848.method_61324(alphaComponent, red, green, blue);
    }

    private static class_8690 getSpriteScaling(class_1058 sprite) {
        return ((class_8689)sprite.method_45851().method_73021(class_8689.field_45647).orElse(class_8689.field_45645)).comp_1636();
    }

}
