/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.compass;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.compass.CompassEditorElement;
import de.keksuccino.spiffyhud.customization.elements.compass.CompassElement;
import de.keksuccino.spiffyhud.customization.marker.MarkerData;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompassElementBuilder
extends ElementBuilder<CompassElement, CompassEditorElement> {
    public CompassElementBuilder() {
        super("spiffy_player_compass");
    }

    @NotNull
    public CompassElement buildDefaultInstance() {
        CompassElement element = new CompassElement(this);
        element.baseWidth = 240;
        element.baseHeight = 60;
        return element;
    }

    public CompassElement deserializeElement(@NotNull SerializedElement serialized) {
        CompassElement element = this.buildDefaultInstance();
        element.backgroundColor = Objects.requireNonNullElse(serialized.getValue("background_color"), element.backgroundColor);
        element.barColor = Objects.requireNonNullElse(serialized.getValue("bar_color"), element.barColor);
        element.barTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("bar_texture"));
        String legacyMajorColor = serialized.getValue("major_tick_color");
        element.cardinalTickColor = Objects.requireNonNullElse(serialized.getValue("cardinal_tick_color"), Objects.requireNonNullElse(legacyMajorColor, element.cardinalTickColor));
        element.degreeTickColor = Objects.requireNonNullElse(serialized.getValue("degree_tick_color"), Objects.requireNonNullElse(legacyMajorColor, element.degreeTickColor));
        element.minorTickColor = Objects.requireNonNullElse(serialized.getValue("minor_tick_color"), element.minorTickColor);
        ResourceSupplier legacyMajorTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("major_tick_texture"));
        ResourceSupplier cardinalTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("cardinal_tick_texture"));
        element.cardinalTickTexture = cardinalTexture != null ? cardinalTexture : legacyMajorTexture;
        ResourceSupplier degreeTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("degree_tick_texture"));
        element.degreeTickTexture = degreeTexture != null ? degreeTexture : legacyMajorTexture;
        element.minorTickTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("minor_tick_texture"));
        element.northCardinalTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("cardinal_texture_north"));
        element.eastCardinalTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("cardinal_texture_east"));
        element.southCardinalTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("cardinal_texture_south"));
        element.westCardinalTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("cardinal_texture_west"));
        element.cardinalTextColor = Objects.requireNonNullElse(serialized.getValue("cardinal_text_color"), element.cardinalTextColor);
        element.numberTextColor = Objects.requireNonNullElse(serialized.getValue("number_text_color"), element.numberTextColor);
        element.cardinalTextScale = Objects.requireNonNullElse(serialized.getValue("cardinal_text_scale"), element.cardinalTextScale);
        element.degreeTextScale = Objects.requireNonNullElse(serialized.getValue("degree_text_scale"), element.degreeTextScale);
        element.needleColor = Objects.requireNonNullElse(serialized.getValue("needle_color"), element.needleColor);
        element.deathPointerColor = Objects.requireNonNullElse(serialized.getValue("death_pointer_color"), element.deathPointerColor);
        element.hostileDotsColor = Objects.requireNonNullElse(serialized.getValue("hostile_dots_color"), element.hostileDotsColor);
        element.passiveDotsColor = Objects.requireNonNullElse(serialized.getValue("passive_dots_color"), element.passiveDotsColor);
        element.needleTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("needle_texture"));
        element.deathPointerTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("death_pointer_texture"));
        element.hostileDotTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("hostile_dots_texture"));
        element.passiveDotTexture = CompassElementBuilder.deserializeImageResourceSupplier((String)serialized.getValue("passive_dots_texture"));
        element.hostileDotScale = Objects.requireNonNullElse(serialized.getValue("hostile_dots_scale"), element.hostileDotScale);
        element.passiveDotScale = Objects.requireNonNullElse(serialized.getValue("passive_dots_scale"), element.passiveDotScale);
        element.markerDotScale = Objects.requireNonNullElse(serialized.getValue("marker_dots_scale"), element.markerDotScale);
        element.needleYOffset = Objects.requireNonNullElse(serialized.getValue("needle_y_offset"), element.needleYOffset);
        element.markerDotYOffset = Objects.requireNonNullElse(serialized.getValue("marker_dot_y_offset"), element.markerDotYOffset);
        element.markerNeedleYOffset = Objects.requireNonNullElse(serialized.getValue("marker_needle_y_offset"), element.markerNeedleYOffset);
        element.markerDotLabelXOffset = Objects.requireNonNullElse(serialized.getValue("marker_dot_label_x_offset"), element.markerDotLabelXOffset);
        element.markerDotLabelYOffset = Objects.requireNonNullElse(serialized.getValue("marker_dot_label_y_offset"), element.markerDotLabelYOffset);
        element.markerNeedleLabelXOffset = Objects.requireNonNullElse(serialized.getValue("marker_needle_label_x_offset"), element.markerNeedleLabelXOffset);
        element.markerNeedleLabelYOffset = Objects.requireNonNullElse(serialized.getValue("marker_needle_label_y_offset"), element.markerNeedleLabelYOffset);
        element.markerLabelScale = Objects.requireNonNullElse(serialized.getValue("marker_label_scale"), element.markerLabelScale);
        element.deathPointerLabelXOffset = Objects.requireNonNullElse(serialized.getValue("death_pointer_label_x_offset"), element.deathPointerLabelXOffset);
        element.deathPointerLabelYOffset = Objects.requireNonNullElse(serialized.getValue("death_pointer_label_y_offset"), element.deathPointerLabelYOffset);
        element.deathPointerLabelScale = Objects.requireNonNullElse(serialized.getValue("death_pointer_label_scale"), element.deathPointerLabelScale);
        element.deathPointerYOffset = Objects.requireNonNullElse(serialized.getValue("death_pointer_y_offset"), element.deathPointerYOffset);
        element.hostileDotsYOffset = Objects.requireNonNullElse(serialized.getValue("hostile_dots_y_offset"), element.hostileDotsYOffset);
        element.passiveDotsYOffset = Objects.requireNonNullElse(serialized.getValue("passive_dots_y_offset"), element.passiveDotsYOffset);
        String legacyTickOffset = serialized.getValue("tick_y_offset");
        String cardinalTickOffset = serialized.getValue("cardinal_tick_y_offset");
        if (cardinalTickOffset != null) {
            element.cardinalTickYOffset = cardinalTickOffset;
        } else if (legacyTickOffset != null) {
            element.cardinalTickYOffset = legacyTickOffset;
        }
        String degreeTickOffset = serialized.getValue("degree_tick_y_offset");
        if (degreeTickOffset != null) {
            element.degreeTickYOffset = degreeTickOffset;
        } else if (legacyTickOffset != null) {
            element.degreeTickYOffset = legacyTickOffset;
        }
        String minorTickOffset = serialized.getValue("minor_tick_y_offset");
        if (minorTickOffset != null) {
            element.minorTickYOffset = minorTickOffset;
        } else if (legacyTickOffset != null) {
            element.minorTickYOffset = legacyTickOffset;
        }
        element.cardinalTextYOffset = Objects.requireNonNullElse(serialized.getValue("cardinal_text_y_offset"), element.cardinalTextYOffset);
        element.degreeTextYOffset = Objects.requireNonNullElse(serialized.getValue("degree_text_y_offset"), element.degreeTextYOffset);
        element.backgroundEnabled = this.deserializeBoolean(element.backgroundEnabled, serialized.getValue("background_enabled"));
        element.barEnabled = this.deserializeBoolean(element.barEnabled, serialized.getValue("bar_enabled"));
        element.cardinalTicksEnabled = this.deserializeBoolean(element.cardinalTicksEnabled, serialized.getValue("cardinal_ticks_enabled"));
        element.degreeTicksEnabled = this.deserializeBoolean(element.degreeTicksEnabled, serialized.getValue("degree_ticks_enabled"));
        String legacyMajorTicksEnabled = serialized.getValue("major_ticks_enabled");
        if (serialized.getValue("cardinal_ticks_enabled") == null) {
            element.cardinalTicksEnabled = this.deserializeBoolean(element.cardinalTicksEnabled, legacyMajorTicksEnabled);
        }
        if (serialized.getValue("degree_ticks_enabled") == null) {
            element.degreeTicksEnabled = this.deserializeBoolean(element.degreeTicksEnabled, legacyMajorTicksEnabled);
        }
        element.minorTicksEnabled = this.deserializeBoolean(element.minorTicksEnabled, serialized.getValue("minor_ticks_enabled"));
        element.needleEnabled = this.deserializeBoolean(element.needleEnabled, serialized.getValue("needle_enabled"));
        element.cardinalTextEnabled = this.deserializeBoolean(element.cardinalTextEnabled, serialized.getValue("cardinal_text_enabled"));
        element.degreeNumbersEnabled = this.deserializeBoolean(element.degreeNumbersEnabled, serialized.getValue("degree_numbers_enabled"));
        element.cardinalOutlineEnabled = this.deserializeBoolean(element.cardinalOutlineEnabled, serialized.getValue("cardinal_outline"));
        element.degreeOutlineEnabled = this.deserializeBoolean(element.degreeOutlineEnabled, serialized.getValue("degree_outline"));
        element.deathPointerEnabled = this.deserializeBoolean(element.deathPointerEnabled, serialized.getValue("death_pointer_enabled"));
        element.worldMarkersEnabled = this.deserializeBoolean(element.worldMarkersEnabled, serialized.getValue("world_markers_enabled"));
        element.markerLabelsEnabled = this.deserializeBoolean(element.markerLabelsEnabled, serialized.getValue("marker_labels_enabled"));
        element.markerLabelOutlineEnabled = this.deserializeBoolean(element.markerLabelOutlineEnabled, serialized.getValue("marker_label_outline_enabled"));
        element.deathPointerLabelEnabled = this.deserializeBoolean(element.deathPointerLabelEnabled, serialized.getValue("death_pointer_label_enabled"));
        element.deathPointerLabelOutlineEnabled = this.deserializeBoolean(element.deathPointerLabelOutlineEnabled, serialized.getValue("death_pointer_label_outline_enabled"));
        element.hostileDotsEnabled = this.deserializeBoolean(element.hostileDotsEnabled, serialized.getValue("hostile_dots_enabled"));
        element.passiveDotsEnabled = this.deserializeBoolean(element.passiveDotsEnabled, serialized.getValue("passive_dots_enabled"));
        element.mobDotsMoveUpDown = this.deserializeBoolean(element.mobDotsMoveUpDown, serialized.getValue("mob_dots_move_up_down"));
        element.hostileDotsRange = Objects.requireNonNullElse(serialized.getValue("hostile_dots_range"), element.hostileDotsRange);
        element.passiveDotsRange = Objects.requireNonNullElse(serialized.getValue("passive_dots_range"), element.passiveDotsRange);
        element.hostileDotsShowHeads = this.deserializeBoolean(element.hostileDotsShowHeads, serialized.getValue("hostile_dots_heads_enabled"));
        element.passiveDotsShowHeads = this.deserializeBoolean(element.passiveDotsShowHeads, serialized.getValue("passive_dots_heads_enabled"));
        return element;
    }

    @Nullable
    public CompassElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        CompassElement element = (CompassElement)super.deserializeElementInternal(serialized);
        if (element != null) {
            element.stayOnScreen = this.deserializeBoolean(element.stayOnScreen, serialized.getValue("stay_on_screen"));
        }
        return element;
    }

    protected SerializedElement serializeElement(@NotNull CompassElement element, @NotNull SerializedElement serializeTo) {
        ResourceSupplier<ITexture> passiveDotsTexture;
        ResourceSupplier<ITexture> hostileDotsTexture;
        ResourceSupplier<ITexture> deathTexture;
        ResourceSupplier<ITexture> needleTexture;
        ResourceSupplier<ITexture> westCardinalTexture;
        ResourceSupplier<ITexture> southCardinalTexture;
        ResourceSupplier<ITexture> eastCardinalTexture;
        ResourceSupplier<ITexture> northCardinalTexture;
        ResourceSupplier<ITexture> minorTickTexture;
        ResourceSupplier<ITexture> degreeTickTexture;
        ResourceSupplier<ITexture> cardinalTickTexture;
        serializeTo.putProperty("background_color", element.backgroundColor);
        serializeTo.putProperty("bar_color", element.barColor);
        serializeTo.putProperty("cardinal_tick_color", element.cardinalTickColor);
        serializeTo.putProperty("degree_tick_color", element.degreeTickColor);
        serializeTo.putProperty("minor_tick_color", element.minorTickColor);
        serializeTo.putProperty("cardinal_text_color", element.cardinalTextColor);
        serializeTo.putProperty("number_text_color", element.numberTextColor);
        serializeTo.putProperty("needle_color", element.needleColor);
        serializeTo.putProperty("death_pointer_color", element.deathPointerColor);
        serializeTo.putProperty("hostile_dots_color", element.hostileDotsColor);
        serializeTo.putProperty("passive_dots_color", element.passiveDotsColor);
        serializeTo.putProperty("hostile_dots_scale", element.hostileDotScale);
        serializeTo.putProperty("passive_dots_scale", element.passiveDotScale);
        serializeTo.putProperty("marker_dots_scale", element.markerDotScale);
        serializeTo.putProperty("needle_y_offset", element.needleYOffset);
        serializeTo.putProperty("marker_dot_y_offset", element.markerDotYOffset);
        serializeTo.putProperty("marker_needle_y_offset", element.markerNeedleYOffset);
        serializeTo.putProperty("marker_dot_label_x_offset", element.markerDotLabelXOffset);
        serializeTo.putProperty("marker_dot_label_y_offset", element.markerDotLabelYOffset);
        serializeTo.putProperty("marker_needle_label_x_offset", element.markerNeedleLabelXOffset);
        serializeTo.putProperty("marker_needle_label_y_offset", element.markerNeedleLabelYOffset);
        serializeTo.putProperty("marker_label_scale", element.markerLabelScale);
        serializeTo.putProperty("death_pointer_label_x_offset", element.deathPointerLabelXOffset);
        serializeTo.putProperty("death_pointer_label_y_offset", element.deathPointerLabelYOffset);
        serializeTo.putProperty("death_pointer_label_scale", element.deathPointerLabelScale);
        serializeTo.putProperty("death_pointer_y_offset", element.deathPointerYOffset);
        serializeTo.putProperty("hostile_dots_y_offset", element.hostileDotsYOffset);
        serializeTo.putProperty("passive_dots_y_offset", element.passiveDotsYOffset);
        serializeTo.putProperty("cardinal_tick_y_offset", element.cardinalTickYOffset);
        serializeTo.putProperty("degree_tick_y_offset", element.degreeTickYOffset);
        serializeTo.putProperty("minor_tick_y_offset", element.minorTickYOffset);
        serializeTo.putProperty("cardinal_text_y_offset", element.cardinalTextYOffset);
        serializeTo.putProperty("degree_text_y_offset", element.degreeTextYOffset);
        serializeTo.putProperty("cardinal_text_scale", element.cardinalTextScale);
        serializeTo.putProperty("degree_text_scale", element.degreeTextScale);
        ResourceSupplier<ITexture> barTexture = element.barTexture;
        if (barTexture != null) {
            serializeTo.putProperty("bar_texture", barTexture.getSourceWithPrefix());
        }
        if ((cardinalTickTexture = element.cardinalTickTexture) != null) {
            serializeTo.putProperty("cardinal_tick_texture", cardinalTickTexture.getSourceWithPrefix());
        }
        if ((degreeTickTexture = element.degreeTickTexture) != null) {
            serializeTo.putProperty("degree_tick_texture", degreeTickTexture.getSourceWithPrefix());
        }
        if ((minorTickTexture = element.minorTickTexture) != null) {
            serializeTo.putProperty("minor_tick_texture", minorTickTexture.getSourceWithPrefix());
        }
        if ((northCardinalTexture = element.northCardinalTexture) != null) {
            serializeTo.putProperty("cardinal_texture_north", northCardinalTexture.getSourceWithPrefix());
        }
        if ((eastCardinalTexture = element.eastCardinalTexture) != null) {
            serializeTo.putProperty("cardinal_texture_east", eastCardinalTexture.getSourceWithPrefix());
        }
        if ((southCardinalTexture = element.southCardinalTexture) != null) {
            serializeTo.putProperty("cardinal_texture_south", southCardinalTexture.getSourceWithPrefix());
        }
        if ((westCardinalTexture = element.westCardinalTexture) != null) {
            serializeTo.putProperty("cardinal_texture_west", westCardinalTexture.getSourceWithPrefix());
        }
        if ((needleTexture = element.needleTexture) != null) {
            serializeTo.putProperty("needle_texture", needleTexture.getSourceWithPrefix());
        }
        if ((deathTexture = element.deathPointerTexture) != null) {
            serializeTo.putProperty("death_pointer_texture", deathTexture.getSourceWithPrefix());
        }
        if ((hostileDotsTexture = element.hostileDotTexture) != null) {
            serializeTo.putProperty("hostile_dots_texture", hostileDotsTexture.getSourceWithPrefix());
        }
        if ((passiveDotsTexture = element.passiveDotTexture) != null) {
            serializeTo.putProperty("passive_dots_texture", passiveDotsTexture.getSourceWithPrefix());
        }
        serializeTo.putProperty("background_enabled", "" + element.backgroundEnabled);
        serializeTo.putProperty("bar_enabled", "" + element.barEnabled);
        serializeTo.putProperty("cardinal_ticks_enabled", Boolean.toString(element.cardinalTicksEnabled));
        serializeTo.putProperty("degree_ticks_enabled", Boolean.toString(element.degreeTicksEnabled));
        serializeTo.putProperty("minor_ticks_enabled", "" + element.minorTicksEnabled);
        serializeTo.putProperty("needle_enabled", "" + element.needleEnabled);
        serializeTo.putProperty("cardinal_text_enabled", "" + element.cardinalTextEnabled);
        serializeTo.putProperty("degree_numbers_enabled", "" + element.degreeNumbersEnabled);
        serializeTo.putProperty("cardinal_outline", "" + element.cardinalOutlineEnabled);
        serializeTo.putProperty("degree_outline", "" + element.degreeOutlineEnabled);
        serializeTo.putProperty("death_pointer_enabled", "" + element.deathPointerEnabled);
        serializeTo.putProperty("death_pointer_label_enabled", Boolean.toString(element.deathPointerLabelEnabled));
        serializeTo.putProperty("death_pointer_label_outline_enabled", Boolean.toString(element.deathPointerLabelOutlineEnabled));
        serializeTo.putProperty("world_markers_enabled", Boolean.toString(element.worldMarkersEnabled));
        serializeTo.putProperty("marker_labels_enabled", Boolean.toString(element.markerLabelsEnabled));
        serializeTo.putProperty("marker_label_outline_enabled", Boolean.toString(element.markerLabelOutlineEnabled));
        serializeTo.putProperty("hostile_dots_enabled", "" + element.hostileDotsEnabled);
        serializeTo.putProperty("passive_dots_enabled", "" + element.passiveDotsEnabled);
        serializeTo.putProperty("mob_dots_move_up_down", Boolean.toString(element.mobDotsMoveUpDown));
        serializeTo.putProperty("hostile_dots_range", element.hostileDotsRange);
        serializeTo.putProperty("passive_dots_range", element.passiveDotsRange);
        serializeTo.putProperty("hostile_dots_heads_enabled", Boolean.toString(element.hostileDotsShowHeads));
        serializeTo.putProperty("passive_dots_heads_enabled", Boolean.toString(element.passiveDotsShowHeads));
        return serializeTo;
    }

    @NotNull
    public CompassEditorElement wrapIntoEditorElement(@NotNull CompassElement element, @NotNull LayoutEditorScreen editor) {
        return new CompassEditorElement(element, editor);
    }

    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.translatable((String)"spiffyhud.elements.compass");
    }

    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.elements.compass.desc", (String[])new String[0]);
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }

    @NotNull
    public List<MarkerData> getMarkers(@NotNull CompassElement element) {
        return element.getMarkers();
    }

    public boolean addMarker(@NotNull CompassElement element, @NotNull MarkerData marker) {
        return element.addMarker(marker);
    }

    public boolean editMarker(@NotNull CompassElement element, @NotNull String markerName, @NotNull Consumer<MarkerData> editor) {
        return element.editMarker(markerName, editor);
    }

    public boolean removeMarker(@NotNull CompassElement element, @NotNull String markerName) {
        return element.removeMarker(markerName);
    }

    @NotNull
    public String getMarkerGroupKey(@NotNull CompassElement element) {
        return element.getMarkerGroupKey();
    }
}

