/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.playernbthelper;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlayerNbtHelperElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();

    public PlayerNbtHelperElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (PlayerNbtHelperElement.isEditor()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            RenderSystem.enableBlend();
            graphics.fill(x, y, x + w, y + h, this.inEditorColor.getColorInt());
            graphics.enableScissor(x, y, x + w, y + h);
            Font font = Minecraft.getInstance().font;
            Component component = this.getDisplayName();
            int n = x + w / 2;
            int n2 = y + h / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            graphics.drawCenteredString(font, component, n, n2 - 9 / 2, -1);
            graphics.disableScissor();
            RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        }
    }
}

