/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.slot;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SlotElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    public String slot = "0";
    public int parsedSlot = 0;
    public boolean useSelectedSlot = false;
    public boolean showDurability = true;
    protected final Font font;

    public SlotElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.font = Minecraft.getInstance().font;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            String slotString = PlaceholderParser.replacePlaceholders((String)this.slot).trim();
            this.parsedSlot = MathUtils.isInteger((String)slotString) ? Integer.parseInt(slotString) : 0;
            if (Minecraft.getInstance().player == null) {
                return;
            }
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            RenderSystem.enableBlend();
            if (SlotElement.isEditor()) {
                MutableComponent label;
                MutableComponent mutableComponent = label = this.useSelectedSlot ? Component.literal((String)"SEL") : Component.literal((String)("" + this.parsedSlot));
                if (this.customElementLayerName != null) {
                    label = SlotElement.buildComponent((String)this.customElementLayerName).copy();
                    label.append((Component)(this.useSelectedSlot ? Component.literal((String)" (SEL)") : Component.literal((String)(" (" + this.parsedSlot + ")"))));
                }
                graphics.fill(x, y, x + w, y + h, this.inEditorColor.getColorIntWithAlpha(0.5f));
                UIBase.renderBorder((GuiGraphics)graphics, (float)x, (float)y, (float)(x + w), (float)(y + h), (float)1.0f, (int)this.inEditorColor.getColorIntWithAlpha(0.8f), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                int n = x + w / 2;
                int n2 = y + h / 2;
                Objects.requireNonNull(this.font);
                graphics.drawCenteredString(this.font, (Component)label, n, n2 - 9 / 2, -1);
            } else {
                ItemStack slotItem;
                ItemStack itemStack = slotItem = this.useSelectedSlot ? Minecraft.getInstance().player.getInventory().getSelected() : Minecraft.getInstance().player.getInventory().getItem(this.parsedSlot);
                if (slotItem == ItemStack.EMPTY) {
                    return;
                }
                this.renderItem(graphics, x + 2, y + 2, w - 4, h - 4, mouseX, mouseY, slotItem);
            }
            RenderSystem.disableBlend();
        }
    }

    protected void renderItem(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, @NotNull ItemStack itemStack) {
        int count = itemStack.getCount();
        this.renderScaledItem(graphics, itemStack, x, y, width, height);
        if (count > 1) {
            this.renderItemCount(graphics, this.font, x, y, Math.max(width, height), count);
        }
    }

    protected void renderScaledItem(@NotNull GuiGraphics graphics, @NotNull ItemStack stack, int x, int y, int width, int height) {
        float cooldownProgress;
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        float scale = (float)Math.min(width, height) / 16.0f;
        pose.scale(scale, scale, 1.0f);
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        graphics.renderItem(stack, 0, 0);
        if (this.showDurability && stack.isBarVisible()) {
            int barWidth = stack.getBarWidth();
            int barColor = stack.getBarColor();
            int barX = 2;
            int barY = 13;
            graphics.fill(RenderType.guiOverlay(), barX, barY, barX + 13, barY + 2, -16777216);
            graphics.fill(RenderType.guiOverlay(), barX, barY, barX + barWidth, barY + 1, barColor | 0xFF000000);
        }
        if (Minecraft.getInstance().player != null && (cooldownProgress = Minecraft.getInstance().player.getCooldowns().getCooldownPercent(stack.getItem(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true))) > 0.0f) {
            int overlayTop = Mth.floor((float)(16.0f * (1.0f - cooldownProgress)));
            int overlayBottom = overlayTop + Mth.ceil((float)(16.0f * cooldownProgress));
            graphics.fill(RenderType.guiOverlay(), 0, overlayTop, 16, overlayBottom, Integer.MAX_VALUE);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        pose.popPose();
    }

    protected void renderItemCount(@NotNull GuiGraphics graphics, @NotNull Font font, int x, int y, int size, int count) {
        PoseStack pose = graphics.pose();
        String text = String.valueOf(count);
        float scaleFactor = (float)size / 16.0f;
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 200.0f);
        pose.pushPose();
        pose.scale(scaleFactor, scaleFactor, 1.0f);
        int scaledX = (int)((float)x / scaleFactor + 19.0f - 2.0f - (float)font.width(text));
        int scaledY = (int)((float)y / scaleFactor + 6.0f + 3.0f);
        graphics.drawString(font, text, scaledX, scaledY, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity), true);
        pose.popPose();
        pose.popPose();
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent c = super.getDisplayName().copy();
        c.append((Component)(this.useSelectedSlot ? Component.literal((String)" (SEL)") : Component.literal((String)(" (" + this.parsedSlot + ")"))));
        return c;
    }
}

