/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.armor;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.armor.VanillaLikePlayerArmorEditorElement;
import de.keksuccino.spiffyhud.customization.elements.vanillalike.armor.VanillaLikePlayerArmorElement;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerArmorElementBuilder
extends ElementBuilder<VanillaLikePlayerArmorElement, VanillaLikePlayerArmorEditorElement> {
    public VanillaLikePlayerArmorElementBuilder() {
        super("spiffy_vanillalike_player_armor_bar");
    }

    @NotNull
    public VanillaLikePlayerArmorElement buildDefaultInstance() {
        VanillaLikePlayerArmorElement e = new VanillaLikePlayerArmorElement(this);
        e.stickyAnchor = true;
        e.stayOnScreen = false;
        return e;
    }

    public VanillaLikePlayerArmorElement deserializeElement(@NotNull SerializedElement serialized) {
        VanillaLikePlayerArmorElement element = this.buildDefaultInstance();
        String alignment = serialized.getValue("body_alignment");
        if (alignment != null) {
            element.spiffyAlignment = Objects.requireNonNullElse(SpiffyAlignment.getByName(alignment), element.spiffyAlignment);
        }
        return element;
    }

    @Nullable
    public VanillaLikePlayerArmorElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        VanillaLikePlayerArmorElement e = (VanillaLikePlayerArmorElement)super.deserializeElementInternal(serialized);
        if (e != null) {
            e.stayOnScreen = this.deserializeBoolean(e.stayOnScreen, serialized.getValue("stay_on_screen"));
        }
        return e;
    }

    protected SerializedElement serializeElement(@NotNull VanillaLikePlayerArmorElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("body_alignment", element.spiffyAlignment.getName());
        return serializeTo;
    }

    @NotNull
    public VanillaLikePlayerArmorEditorElement wrapIntoEditorElement(@NotNull VanillaLikePlayerArmorElement element, @NotNull LayoutEditorScreen editor) {
        return new VanillaLikePlayerArmorEditorElement(element, editor);
    }

    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.translatable((String)"spiffyhud.elements.vanillalike.player_armor");
    }

    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return null;
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

