/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.attackindicator;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeAttackIndicatorElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_full");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_background");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_progress");
    private static final ResourceLocation HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_attack_indicator_background");
    private static final ResourceLocation HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_attack_indicator_progress");
    private final Minecraft minecraft = Minecraft.getInstance();
    public boolean isHotbar = false;

    public VanillaLikeAttackIndicatorElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.renderAttackIndicator(graphics, this.isHotbar, elementX, elementY, elementWidth, elementHeight);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    public void renderAttackIndicator(GuiGraphics graphics, boolean isHotbar, int x, int y, int width, int height) {
        float attackStrength = this.minecraft.player.getAttackStrengthScale(0.0f);
        if (VanillaLikeAttackIndicatorElement.isEditor()) {
            attackStrength = 0.5f;
        }
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        if (isHotbar) {
            if (attackStrength < 1.0f) {
                graphics.blitSprite(HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE, x, y, width, height);
                int fillHeight = (int)((float)height * attackStrength);
                if (fillHeight > 0) {
                    graphics.blitSprite(HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE, width, height, 0, height - fillHeight, x, y + height - fillHeight, width, fillHeight);
                }
            }
        } else {
            boolean readyToAttack = false;
            if (this.minecraft.crosshairPickEntity != null && this.minecraft.crosshairPickEntity instanceof LivingEntity && attackStrength >= 1.0f) {
                readyToAttack = this.minecraft.player.getCurrentItemAttackStrengthDelay() > 5.0f;
                readyToAttack &= this.minecraft.crosshairPickEntity.isAlive();
            }
            if (readyToAttack) {
                graphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, x, y, width, height);
            } else if (attackStrength < 1.0f) {
                int barHeight = height;
                if (width / height > 4) {
                    barHeight = Math.max(1, width / 4);
                }
                graphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, x, y, width, barHeight);
                int fillWidth = (int)((float)width * attackStrength);
                if (fillWidth > 0) {
                    graphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, width, barHeight, 0, 0, x, y, fillWidth, barHeight);
                }
            }
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

