/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeEffectsElement
extends AbstractElement {
    private static final ResourceLocation EFFECT_BACKGROUND_AMBIENT_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/effect_background_ambient");
    private static final ResourceLocation EFFECT_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/effect_background");
    private final Minecraft minecraft = Minecraft.getInstance();
    protected int tickCount;
    private int barHeight = 60;
    private int barWidth = 100;
    private boolean shouldRenderBar = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikeEffectsElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.player == null) {
            return;
        }
        if (this.minecraft.level == null) {
            return;
        }
        this.shouldRenderBar = false;
        this.renderEffects(graphics, 0, 0);
        int elementAbsX = this.getAbsoluteX();
        int elementAbsY = this.getAbsoluteY();
        int elementHeight = this.getAbsoluteHeight();
        int baseY = elementAbsY;
        if (this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT) {
            baseY += (elementHeight - this.barHeight) / 2;
        } else if (this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
            baseY += elementHeight - this.barHeight;
        }
        int baseX = elementAbsX;
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.shouldRenderBar = true;
        this.renderEffects(graphics, baseX, baseY);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    protected void renderEffects(GuiGraphics graphics, int baseX, int baseY) {
        float iconTransparency;
        int iconY;
        int iconX;
        TextureAtlasSprite effectSprite;
        int fadeFactor;
        float iconAlpha;
        int finalIconX;
        int relativeX;
        MobEffectInstance effectInstance;
        int i;
        int requiredWidth;
        Screen currentScreen;
        List<MobEffectInstance> activeEffects = Objects.requireNonNull(this.minecraft.player).getActiveEffects();
        if (VanillaLikeEffectsElement.isEditor()) {
            activeEffects = List.of(new MobEffectInstance(MobEffects.LUCK, 300), new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 300), new MobEffectInstance(MobEffects.BAD_OMEN, 300));
        }
        if (activeEffects.isEmpty() || (currentScreen = this.minecraft.screen) instanceof EffectRenderingInventoryScreen && ((EffectRenderingInventoryScreen)currentScreen).canSeeEffects()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        ArrayList<MobEffectInstance> beneficialEffects = new ArrayList<MobEffectInstance>();
        ArrayList<MobEffectInstance> harmfulEffects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effectInstance2 : Ordering.natural().reverse().sortedCopy(activeEffects)) {
            if (!effectInstance2.showIcon()) continue;
            if (((MobEffect)effectInstance2.getEffect().value()).isBeneficial()) {
                beneficialEffects.add(effectInstance2);
                continue;
            }
            harmfulEffects.add(effectInstance2);
        }
        ArrayList renderTasks = Lists.newArrayListWithExpectedSize((int)activeEffects.size());
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setWidthOffset(24);
        recorder.setHeightOffset(24);
        boolean isLeftAligned = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT;
        boolean isRightAligned = this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT;
        int baseRowOffset = 1;
        if (this.minecraft.isDemo()) {
            baseRowOffset += 15;
        }
        int beneficialRowY = baseY + baseRowOffset;
        int harmfulRowY = baseY + baseRowOffset + 26;
        int beneficialIconCount = beneficialEffects.size();
        int harmfulIconCount = harmfulEffects.size();
        int elementWidth = requiredWidth = Math.max(beneficialIconCount, harmfulIconCount) * 25;
        int beneficialStartX = isLeftAligned ? 0 : (isRightAligned ? elementWidth - beneficialIconCount * 25 : (elementWidth - beneficialIconCount * 25) / 2);
        int harmfulStartX = isLeftAligned ? 0 : (isRightAligned ? elementWidth - harmfulIconCount * 25 : (elementWidth - harmfulIconCount * 25) / 2);
        MobEffectTextureManager effectTextureManager = this.minecraft.getMobEffectTextures();
        for (i = 0; i < beneficialIconCount; ++i) {
            effectInstance = (MobEffectInstance)beneficialEffects.get(i);
            relativeX = beneficialStartX + 25 * i;
            finalIconX = baseX + relativeX;
            iconAlpha = 1.0f;
            if (this.shouldRenderBar) {
                if (effectInstance.isAmbient()) {
                    graphics.blitSprite(EFFECT_BACKGROUND_AMBIENT_SPRITE, finalIconX, beneficialRowY, 24, 24);
                } else {
                    graphics.blitSprite(EFFECT_BACKGROUND_SPRITE, finalIconX, beneficialRowY, 24, 24);
                    if (effectInstance.endsWithin(200)) {
                        int duration = effectInstance.getDuration();
                        fadeFactor = 10 - duration / 20;
                        iconAlpha = Mth.clamp((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.cos((float)((float)duration * (float)Math.PI / 5.0f)) * Mth.clamp((float)((float)fadeFactor / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
            }
            effectSprite = effectTextureManager.get(effectInstance.getEffect());
            recorder.updateX(finalIconX);
            recorder.updateY(beneficialRowY);
            iconX = finalIconX;
            iconY = beneficialRowY;
            float f = iconTransparency = iconAlpha > this.opacity ? this.opacity : iconAlpha;
            if (!this.shouldRenderBar) continue;
            renderTasks.add(() -> {
                graphics.setColor(1.0f, 1.0f, 1.0f, iconTransparency);
                graphics.blit(iconX + 3, iconY + 3, 0, 18, 18, effectSprite);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            });
        }
        for (i = 0; i < harmfulIconCount; ++i) {
            effectInstance = (MobEffectInstance)harmfulEffects.get(i);
            relativeX = harmfulStartX + 25 * i;
            finalIconX = baseX + relativeX;
            iconAlpha = 1.0f;
            if (this.shouldRenderBar) {
                if (effectInstance.isAmbient()) {
                    graphics.blitSprite(EFFECT_BACKGROUND_AMBIENT_SPRITE, finalIconX, harmfulRowY, 24, 24);
                } else {
                    graphics.blitSprite(EFFECT_BACKGROUND_SPRITE, finalIconX, harmfulRowY, 24, 24);
                    if (effectInstance.endsWithin(200)) {
                        int duration = effectInstance.getDuration();
                        fadeFactor = 10 - duration / 20;
                        iconAlpha = Mth.clamp((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.cos((float)((float)duration * (float)Math.PI / 5.0f)) * Mth.clamp((float)((float)fadeFactor / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
            }
            effectSprite = effectTextureManager.get(effectInstance.getEffect());
            recorder.updateX(finalIconX);
            recorder.updateY(harmfulRowY);
            iconX = finalIconX;
            iconY = harmfulRowY;
            float f = iconTransparency = iconAlpha > this.opacity ? this.opacity : iconAlpha;
            if (!this.shouldRenderBar) continue;
            renderTasks.add(() -> {
                graphics.setColor(1.0f, 1.0f, 1.0f, iconTransparency);
                graphics.blit(iconX + 3, iconY + 3, 0, 18, 18, effectSprite);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            });
        }
        this.barHeight = recorder.getHeight();
        this.barWidth = requiredWidth;
        renderTasks.forEach(Runnable::run);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }
}

