/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.food;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerFoodElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation FOOD_EMPTY_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/food_empty");
    private static final ResourceLocation FOOD_HALF_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/food_half");
    private static final ResourceLocation FOOD_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/food_full");
    private static final ResourceLocation FOOD_EMPTY_HUNGER_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/food_empty_hunger");
    private static final ResourceLocation FOOD_HALF_HUNGER_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/food_half_hunger");
    private static final ResourceLocation FOOD_FULL_HUNGER_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/food_full_hunger");
    private static final int BAR_WIDTH = 81;
    private static final int BAR_HEIGHT = 9;
    private final Minecraft minecraft = Minecraft.getInstance();
    protected final RandomSource random = RandomSource.create();
    protected int tickCount;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerFoodElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, this.getAbsoluteWidth(), this.getAbsoluteHeight(), 81, 9);
        int barPosX = alignedPosition[0];
        int barPosY = alignedPosition[1];
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.renderFoodBar(graphics, barPosX, barPosY);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderFoodBar(GuiGraphics graphics, int baseX, int baseY) {
        ResourceLocation fullSprite;
        ResourceLocation halfSprite;
        ResourceLocation emptySprite;
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        FoodData foodData = player.getFoodData();
        int foodLevel = foodData.getFoodLevel();
        if (VanillaLikePlayerFoodElement.isEditor()) {
            foodLevel = 9;
        }
        int numIcons = 10;
        int ICON_WIDTH = 9;
        int ICON_HEIGHT = 9;
        int ICON_SPACING = 8;
        boolean mirrorIcons = this.shouldRenderIconsLeftToRight();
        if (player.hasEffect(MobEffects.HUNGER)) {
            emptySprite = FOOD_EMPTY_HUNGER_SPRITE;
            halfSprite = FOOD_HALF_HUNGER_SPRITE;
            fullSprite = FOOD_FULL_HUNGER_SPRITE;
        } else {
            emptySprite = FOOD_EMPTY_SPRITE;
            halfSprite = FOOD_HALF_SPRITE;
            fullSprite = FOOD_FULL_SPRITE;
        }
        for (int i = 0; i < 10; ++i) {
            int iconX = mirrorIcons ? baseX + i * 8 : baseX + (9 - i) * 8;
            int iconY = baseY;
            if (foodData.getSaturationLevel() <= 0.0f && this.tickCount % (foodLevel * 3 + 1) == 0) {
                iconY += this.random.nextInt(3) - 1;
            }
            if (mirrorIcons) {
                SpiffyRenderUtils.blitSpriteMirrored(graphics, emptySprite, iconX, iconY, 9, 9);
                if (i * 2 + 1 < foodLevel) {
                    SpiffyRenderUtils.blitSpriteMirrored(graphics, fullSprite, iconX, iconY, 9, 9);
                    continue;
                }
                if (i * 2 + 1 != foodLevel) continue;
                SpiffyRenderUtils.blitSpriteMirrored(graphics, halfSprite, iconX, iconY, 9, 9);
                continue;
            }
            graphics.blitSprite(emptySprite, iconX, iconY, 9, 9);
            if (i * 2 + 1 < foodLevel) {
                graphics.blitSprite(fullSprite, iconX, iconY, 9, 9);
                continue;
            }
            if (i * 2 + 1 != foodLevel) continue;
            graphics.blitSprite(halfSprite, iconX, iconY, 9, 9);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private boolean shouldRenderIconsLeftToRight() {
        return this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED;
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return 81;
    }

    public int getAbsoluteHeight() {
        return 9;
    }
}

