/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeHotbarElement
extends AbstractElement {
    private static final ResourceLocation HOTBAR_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar");
    private static final ResourceLocation HOTBAR_SELECTION_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_selection");
    private static final ResourceLocation HOTBAR_OFFHAND_LEFT_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_offhand_left");
    private static final ResourceLocation HOTBAR_OFFHAND_RIGHT_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_offhand_right");
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 22;

    public VanillaLikeHotbarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        int elementWidth = this.getAbsoluteWidth();
        int elementHeight = this.getAbsoluteHeight();
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        if (Minecraft.getInstance().player == null) {
            return;
        }
        this.renderHotbar(graphics, partialTick, elementX, elementY, elementWidth, elementHeight);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderHotbar(GuiGraphics graphics, float partialTick, int elementX, int elementY, int elementWidth, int elementHeight) {
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
        ItemStack offhandItem = player.getOffhandItem();
        HumanoidArm oppositeMainArm = player.getMainArm().getOpposite();
        graphics.blitSprite(HOTBAR_SPRITE, elementX, elementY, elementWidth, elementHeight);
        int selectedSlot = player.getInventory().selected;
        graphics.blitSprite(HOTBAR_SELECTION_SPRITE, elementX - 1 + selectedSlot * 20, elementY - 1, 24, 23);
        if (!VanillaLikeHotbarElement.isEditor()) {
            if (!offhandItem.isEmpty()) {
                if (oppositeMainArm == HumanoidArm.LEFT) {
                    graphics.blitSprite(HOTBAR_OFFHAND_LEFT_SPRITE, elementX - 29, elementY - 1, 29, 24);
                } else {
                    graphics.blitSprite(HOTBAR_OFFHAND_RIGHT_SPRITE, elementX + elementWidth, elementY - 1, 29, 24);
                }
            }
        } else {
            graphics.blitSprite(HOTBAR_OFFHAND_LEFT_SPRITE, elementX - 29, elementY - 1, 29, 24);
            graphics.blitSprite(HOTBAR_OFFHAND_RIGHT_SPRITE, elementX + elementWidth, elementY - 1, 29, 24);
        }
        int slotStartX = elementX + 3;
        int slotY = elementY + 3;
        int renderSeed = 1;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int slotX = slotStartX + slotIndex * 20;
            this.renderSlot(graphics, slotX, slotY, partialTick, player, (ItemStack)player.getInventory().items.get(slotIndex), renderSeed++);
        }
        if (!offhandItem.isEmpty()) {
            if (oppositeMainArm == HumanoidArm.LEFT) {
                this.renderSlot(graphics, elementX - 26, slotY, partialTick, player, offhandItem, renderSeed++);
            } else {
                this.renderSlot(graphics, elementX + elementWidth + 10, slotY, partialTick, player, offhandItem, renderSeed++);
            }
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderSlot(GuiGraphics graphics, int slotX, int slotY, float partialTick, Player player, ItemStack stack, int renderSeed) {
        if (stack.isEmpty()) {
            return;
        }
        float popTimeRemaining = (float)stack.getPopTime() - partialTick;
        if (popTimeRemaining > 0.0f) {
            float scaleFactor = 1.0f + popTimeRemaining / 5.0f;
            graphics.pose().pushPose();
            graphics.pose().translate((float)(slotX + 8), (float)(slotY + 12), 0.0f);
            graphics.pose().scale(1.0f / scaleFactor, (scaleFactor + 1.0f) / 2.0f, 1.0f);
            graphics.pose().translate((float)(-(slotX + 8)), (float)(-(slotY + 12)), 0.0f);
        }
        graphics.renderItem((LivingEntity)player, stack, slotX, slotY, renderSeed);
        if (popTimeRemaining > 0.0f) {
            graphics.pose().popPose();
        }
        this.renderSlotDecorations(graphics, player, stack, slotX, slotY);
    }

    private void renderSlotDecorations(GuiGraphics graphics, @Nullable Player player, ItemStack stack, int slotX, int slotY) {
        float cooldownProgress;
        graphics.pose().pushPose();
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        if (stack.getCount() != 1) {
            String countText = String.valueOf(stack.getCount());
            graphics.pose().translate(0.0f, 0.0f, 200.0f);
            graphics.drawString(font, countText, slotX + 19 - 2 - font.width(countText), slotY + 6 + 3, 0xFFFFFF, true);
        }
        if (stack.isBarVisible()) {
            int barWidth = stack.getBarWidth();
            int barColor = stack.getBarColor();
            int barX = slotX + 2;
            int barY = slotY + 13;
            graphics.fill(RenderType.guiOverlay(), barX, barY, barX + 13, barY + 2, -16777216);
            graphics.fill(RenderType.guiOverlay(), barX, barY, barX + barWidth, barY + 1, barColor | 0xFF000000);
        }
        if (player != null && (cooldownProgress = player.getCooldowns().getCooldownPercent(stack.getItem(), minecraft.getTimer().getGameTimeDeltaPartialTick(true))) > 0.0f) {
            int overlayTop = slotY + Mth.floor((float)(16.0f * (1.0f - cooldownProgress)));
            int overlayBottom = overlayTop + Mth.ceil((float)(16.0f * cooldownProgress));
            graphics.fill(RenderType.guiOverlay(), slotX, overlayTop, slotX + 16, overlayBottom, Integer.MAX_VALUE);
        }
        graphics.pose().popPose();
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return 182;
    }

    public int getAbsoluteHeight() {
        return 22;
    }
}

